/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import org.opensha.data.DataPoint2D;
import org.opensha.exceptions.DataPoint2DException;
import org.opensha.exceptions.DiscretizedFuncException;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.MagFreqDistException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class YC_1985_CharMagFreqDist
extends IncrementalMagFreqDist {
    private String C = new String("YC_1985_CharMagFreqDist");
    public static String NAME = new String("Youngs and Coppersmith Dist");
    private double magLower;
    private double magUpper;
    private double deltaMagChar;
    private double magPrime;
    private double deltaMagPrime;
    private double bValue;

    public YC_1985_CharMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
    }

    public YC_1985_CharMagFreqDist(double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
    }

    public YC_1985_CharMagFreqDist(double min, int num, double delta, double magLower, double magUpper, double deltaMagChar, double magPrime, double deltaMagPrime, double bValue, double totMoRate) throws InvalidRangeException, DataPoint2DException {
        super(min, num, delta);
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.deltaMagChar = deltaMagChar;
        this.magPrime = magPrime;
        this.deltaMagPrime = deltaMagPrime;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public YC_1985_CharMagFreqDist(double min, int num, double delta, double deltaMagChar, double magPrime, double deltaMagPrime, double bValue, double totMoRate) throws InvalidRangeException, DataPoint2DException {
        super(min, num, delta);
        this.magLower = this.minX;
        this.magUpper = this.maxX;
        this.deltaMagChar = deltaMagChar;
        this.magPrime = magPrime;
        this.deltaMagPrime = deltaMagPrime;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButTotCharRate(double magLower, double magUpper, double deltaMagChar, double magPrime, double deltaMagPrime, double bValue, double totMoRate) throws DataPoint2DException, InvalidRangeException {
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.deltaMagChar = deltaMagChar;
        this.magPrime = magPrime;
        this.deltaMagPrime = deltaMagPrime;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButTotMoRate(double magLower, double magUpper, double deltaMagChar, double magPrime, double deltaMagPrime, double bValue, double totCharRate) throws DataPoint2DException, InvalidRangeException {
        this.magLower = magLower;
        this.magUpper = magUpper;
        this.deltaMagChar = deltaMagChar;
        this.magPrime = magPrime;
        this.deltaMagPrime = deltaMagPrime;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToCumRate(magUpper - deltaMagChar, totCharRate);
    }

    public void set(DataPoint2D point) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the YC_1985_CharMagFreqDist from outside this class");
    }

    public void set(double x, double y) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the YC_1985_CharMagFreqDist from outside this class");
    }

    public void set(int index, double y) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the YC_1985_CharMagFreqDist from outside this class");
    }

    private void calculateRelativeRates() throws DataPoint2DException, InvalidRangeException {
        int i;
        if (this.deltaMagChar < 0.0) {
            throw new InvalidRangeException("deltaMagChar must be positive");
        }
        if (this.deltaMagPrime < 0.0) {
            throw new InvalidRangeException("deltaMagPrime must be positive");
        }
        if (this.magLower < this.minX || this.magLower > this.maxX) {
            throw new DataPoint2DException("magLower should lie between minX and maxX");
        }
        if (this.magLower > this.magUpper) {
            throw new InvalidRangeException("magLower cannot be less than magUpper");
        }
        if (this.magPrime > this.magUpper || this.magPrime < this.magLower) {
            throw new InvalidRangeException("magPrime must be between magLower and magUpper");
        }
        if (this.magPrime - this.deltaMagPrime < this.magLower) {
            throw new InvalidRangeException("magPrime-deltaMagPrime must be greater than magLower");
        }
        if (this.deltaMagChar > this.magUpper - this.magPrime + this.deltaMagPrime) {
            throw new InvalidRangeException("deltaMagChar > (magUpper-magPrime+deltaMagPrime), which is not allowed");
        }
        if (this.magPrime > this.magUpper - this.deltaMagChar) {
            throw new InvalidRangeException("magPrime > (magUpper-deltaMagChar), which is not allowed");
        }
        double magForRate = this.magPrime - this.deltaMagPrime;
        int indexLower = this.getXIndex(this.magLower);
        int indexUpper = this.getXIndex(this.magUpper);
        int indexMagPrime = this.getXIndex(this.magPrime);
        int indexForRate = this.getXIndex(magForRate);
        int indexCharStart = this.getXIndex(this.magUpper - this.deltaMagChar);
        for (i = 0; i < this.num; ++i) {
            super.set(i, 0.0);
        }
        for (i = indexLower; i <= indexMagPrime; ++i) {
            super.set(i, Math.pow(10.0, -this.bValue * this.getX(i)));
        }
        for (i = indexCharStart; i <= indexUpper; ++i) {
            super.set(i, Math.pow(10.0, -this.bValue * magForRate));
        }
    }

    public double getTotCumRate() {
        return this.getCumRate(this.magLower);
    }

    public double get_bValue() {
        return this.bValue;
    }

    public double getMagLower() {
        return this.magLower;
    }

    public double getMagUpper() {
        return this.magUpper;
    }

    public double getMagPrime() {
        return this.magPrime;
    }

    public double getDeltaMagPrime() {
        return this.deltaMagPrime;
    }

    public double getDeltaMagChar() {
        return this.deltaMagChar;
    }

    public String getDefaultName() {
        return NAME;
    }

    public String getDefaultInfo() {
        return "minMag=" + this.minX + "; maxMag=" + this.maxX + "; numMag=" + this.num + "; magLower=" + this.magLower + "; magUpper=" + this.magUpper + "; deltaMagChar=" + this.getDeltaMagChar() + "; magPrime=" + this.getMagPrime() + "; deltaMagPrime=" + this.getDeltaMagPrime() + " bValue=" + this.bValue + "; totMoRate=" + (float)this.getTotalMomentRate() + "; totCumRate=" + (float)this.getCumRate(this.magLower);
    }
}

