/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param;

import java.util.ListIterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Location;
import org.opensha.exceptions.ConstraintException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.WarningParameterAPI;
import org.opensha.sha.param.WarningDoublePropagationEffectParameter;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;

public class DistanceSeisParameter
extends WarningDoublePropagationEffectParameter
implements WarningParameterAPI {
    protected static final String C = "DistanceSeisParameter";
    protected static final boolean D = false;
    public static final String NAME = "DistanceSeis";
    private static final String UNITS = "km";
    private static final String INFO = "Seismogenic Distance (closest distance to seismogenic part of fault surface)";
    private static final Double MAX = new Double(Double.MAX_VALUE);
    public static final double seisDepth = 3.0;

    public DistanceSeisParameter() {
        this.init();
    }

    public DistanceSeisParameter(ParameterConstraintAPI warningConstraint) throws ConstraintException {
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceSeisParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(3.0, Double.MAX_VALUE);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.constraint.setNullAllowed(false);
        this.units = UNITS;
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            Location loc1 = this.site.getLocation();
            double minDistance = Double.MAX_VALUE;
            EvenlyGriddedSurfaceAPI rupSurf = this.eqkRupture.getRuptureSurface();
            boolean projectToDepth = false;
            if (rupSurf.getNumRows() == 1 && rupSurf.getLocation(0, 0).getDepth() < 3.0) {
                projectToDepth = true;
            }
            ListIterator it = rupSurf.getLocationsIterator();
            while (it.hasNext()) {
                double totalDist;
                double horzDist;
                Location loc2 = (Location)it.next();
                if (loc2.getDepth() >= 3.0) {
                    double vertDist;
                    horzDist = RelativeLocation.getHorzDistance(loc1, loc2);
                    totalDist = horzDist * horzDist + (vertDist = RelativeLocation.getVertDistance(loc1, loc2)) * vertDist;
                    if (!(totalDist < minDistance)) continue;
                    minDistance = totalDist;
                    continue;
                }
                if (!projectToDepth || !((totalDist = (horzDist = RelativeLocation.getHorzDistance(loc1, loc2)) * horzDist + 9.0) < minDistance)) continue;
                minDistance = totalDist;
            }
            this.setValueIgnoreWarning(new Double(Math.pow(minDistance, 0.5)));
        } else {
            this.setValue(null);
        }
    }

    public String getType() {
        String type = "DoubleParameter";
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = new Double(val);
        }
        DistanceSeisParameter param = new DistanceSeisParameter();
        param.info = this.info;
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }
}

