/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.surface;

import java.util.ListIterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Direction;
import org.opensha.data.Location;
import org.opensha.exceptions.FaultException;
import org.opensha.sha.fault.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.fault.FaultTrace;
import org.opensha.sha.fault.SimpleFaultData;

public class FrankelGriddedSurface
extends EvenlyGriddedSurfFromSimpleFaultData {
    protected static final String C = "FrankelGriddedSurface";
    protected static final boolean D = false;
    protected static final double PI_RADIANS = Math.PI / 180;
    protected static final String ERR = " is null, unable to process.";

    public FrankelGriddedSurface(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public FrankelGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    private void createEvenlyGriddedSurface() throws FaultException {
        Location firstLoc;
        String S = "FrankelGriddedSurface: createEvenlyGriddedSurface():";
        this.assertValidData();
        int numSegments = this.faultTrace.getNumLocations() - 1;
        double avDipRadians = this.aveDip * (Math.PI / 180);
        double gridSpacingCosAveDipRadians = this.gridSpacing * Math.cos(avDipRadians);
        double gridSpacingSinAveDipRadians = this.gridSpacing * Math.sin(avDipRadians);
        double[] segmentLenth = new double[numSegments];
        double[] segmentAzimuth = new double[numSegments];
        double[] segmentCumLenth = new double[numSegments];
        double cumDistance = 0.0;
        int i = 0;
        ListIterator it = this.faultTrace.listIterator();
        Location lastLoc = firstLoc = (Location)it.next();
        Location loc = null;
        Direction dir = null;
        while (it.hasNext()) {
            loc = (Location)it.next();
            dir = RelativeLocation.getDirection(lastLoc, loc);
            double azimuth = dir.getAzimuth();
            double distance = dir.getHorzDistance();
            segmentLenth[i] = distance;
            segmentAzimuth[i] = azimuth;
            segmentCumLenth[i] = cumDistance += distance;
            ++i;
            lastLoc = loc;
        }
        double downDipWidth = (this.lowerSeismogenicDepth - this.upperSeismogenicDepth) / Math.sin(avDipRadians);
        int rows = 1 + Math.round((float)(downDipWidth / this.gridSpacing));
        int cols = 1 + Math.round((float)(segmentCumLenth[numSegments - 1] / this.gridSpacing));
        this.setNumRowsAndNumCols(rows, cols);
        for (int ith_col = 0; ith_col < cols; ++ith_col) {
            Location topLocation;
            double hDistance;
            double vDistance;
            int segmentNumber;
            double distanceAlong = (double)ith_col * this.gridSpacing;
            for (segmentNumber = 1; segmentNumber <= numSegments && distanceAlong > segmentCumLenth[segmentNumber - 1]; ++segmentNumber) {
            }
            if (segmentNumber == numSegments + 1) {
                --segmentNumber;
            }
            double distance = segmentNumber > 1 ? distanceAlong - segmentCumLenth[segmentNumber - 2] : distanceAlong;
            Location location1 = this.faultTrace.getLocationAt(segmentNumber - 1);
            Location traceLocation = RelativeLocation.getLocation(location1, dir = new Direction(0.0, distance, segmentAzimuth[segmentNumber - 1], 0.0));
            if (traceLocation.getDepth() < this.upperSeismogenicDepth) {
                vDistance = traceLocation.getDepth() - this.upperSeismogenicDepth;
                hDistance = vDistance / Math.tan(avDipRadians);
                dir = new Direction(vDistance, hDistance, segmentAzimuth[segmentNumber - 1] + 90.0, 0.0);
                topLocation = RelativeLocation.getLocation(traceLocation, dir);
            } else {
                topLocation = traceLocation;
            }
            this.setLocation(0, ith_col, (Location)topLocation.clone());
            for (int ith_row = 1; ith_row < rows; ++ith_row) {
                hDistance = (double)ith_row * gridSpacingCosAveDipRadians;
                vDistance = (double)(-ith_row) * gridSpacingSinAveDipRadians;
                dir = new Direction(vDistance, hDistance, segmentAzimuth[segmentNumber - 1] + 90.0, 0.0);
                Location depthLocation = RelativeLocation.getLocation(topLocation, dir);
                this.setLocation(ith_row, ith_col, (Location)depthLocation.clone());
            }
        }
    }
}

