/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.surface;

import java.util.ListIterator;
import org.opensha.data.ContainerSubset2D;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.exceptions.LocationException;
import org.opensha.sha.surface.EvenlyGriddedSurface;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;

public class GriddedSubsetSurface
extends ContainerSubset2D
implements EvenlyGriddedSurfaceAPI {
    static final char TAB = '\t';

    public GriddedSubsetSurface(int numRows, int numCols, int startRow, int startCol) throws ArrayIndexOutOfBoundsException {
        super(numRows, numCols, startRow, startCol);
    }

    public GriddedSubsetSurface(int numRows, int numCols, int startRow, int startCol, EvenlyGriddedSurfaceAPI data) throws ArrayIndexOutOfBoundsException {
        super(numRows, numCols, startRow, startCol, data);
    }

    public void setLocation(int row, int col, Location location) {
        throw new UnsupportedOperationException("This function is not implemented in this subclass");
    }

    public void setLimits(int startRow, int startCol, int numRows, int numCols) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: setLimits():";
        this.initTransaction();
        this.window.setStartRow(startRow);
        this.window.setStartCol(startCol);
        this.window.setNumRows(numRows);
        this.window.setNumCols(numCols);
        try {
            this.window.checkLowerBounds(S);
            this.window.calcUpperBounds();
            if (this.data != null) {
                this.window.checkUpperBounds(S);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.rollback();
            throw e;
        }
        this.commit();
    }

    public void setNewMainSurface(EvenlyGriddedSurface gs) {
        super.setContainer2D(gs);
    }

    public Location getLocation(int row, int col) throws LocationException {
        String S = "ContainerSubset2D: getLocation():";
        if (this.exist(row, col)) {
            return (Location)this.get(row, col);
        }
        throw new LocationException(S + "Requested object doesn't exist in " + row + ", " + col);
    }

    public ListIterator getLocationsIterator() {
        return this.listIterator();
    }

    public LocationList getLocationList() {
        LocationList locList = new LocationList();
        ListIterator it = this.getLocationsIterator();
        locList.addLocation((Location)it.next());
        return locList;
    }

    public int getMainNumRows() {
        return this.data.getNumRows();
    }

    public int getMainNumCols() {
        return this.data.getNumCols();
    }

    public double getAveStrike() {
        return ((EvenlyGriddedSurfaceAPI)this.data).getAveStrike();
    }

    public double getAveDip() {
        return ((EvenlyGriddedSurface)this.data).getAveDip();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("ContainerSubset2D\n");
        if (this.data != null) {
            b.append("Ave. Strike = " + ((EvenlyGriddedSurface)this.data).getAveStrike() + '\n');
        }
        if (this.data != null) {
            b.append("Ave. Dip = " + ((EvenlyGriddedSurface)this.data).getAveDip() + '\n');
        }
        b.append("Row\tCol\tLatitude\tLongitude\tDepth");
        String superStr = super.toString();
        b.append('\n' + superStr);
        return b.toString();
    }

    public double getSurfaceLength() {
        return this.getGridSpacing() * (double)(this.getNumCols() - 1);
    }

    public double getSurfaceWidth() {
        return this.getGridSpacing() * (double)(this.getNumRows() - 1);
    }

    public String getSurfaceMetadata() {
        return ((EvenlyGriddedSurfaceAPI)this.data).getSurfaceMetadata();
    }

    public double getGridSpacing() {
        return ((EvenlyGriddedSurfaceAPI)this.data).getGridSpacing();
    }
}

