/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.surface;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Direction;
import org.opensha.data.Location;
import org.opensha.exceptions.FaultException;
import org.opensha.sha.fault.FaultTrace;
import org.opensha.sha.surface.EvenlyGriddedSurface;
import org.opensha.util.FaultUtils;

public class SimpleListricGriddedSurface
extends EvenlyGriddedSurface {
    protected static final String C = "SimpleListricGriddedFaultFactory";
    protected static final boolean D = false;
    protected static final double PI_RADIANS = Math.PI / 180;
    protected FaultTrace faultTrace;
    protected ArrayList dips;
    protected ArrayList depths;

    public SimpleListricGriddedSurface(FaultTrace faultTrace, ArrayList dips, ArrayList depths, double gridSpacing) throws FaultException {
        this.faultTrace = faultTrace;
        this.dips = dips;
        this.depths = depths;
        this.gridSpacing = gridSpacing;
        this.createEvenlyGriddedSurface();
    }

    private void createEvenlyGriddedSurface() throws FaultException {
        double dip;
        String S = "SimpleListricGriddedFaultFactory: createEvenlyGriddedSurface():";
        this.assertValidData();
        int numSegments = this.faultTrace.getNumLocations() - 1;
        double[] segmentLenth = new double[numSegments];
        double[] segmentAzimuth = new double[numSegments];
        double[] segmentCumLenth = new double[numSegments];
        double cumDistance = 0.0;
        int i = 0;
        Location firstLoc = this.faultTrace.getLocationAt(0);
        Location lastLoc = this.faultTrace.getLocationAt(this.faultTrace.getNumLocations() - 1);
        Direction aveDir = RelativeLocation.getDirection(firstLoc, lastLoc);
        double aveDipDirection = aveDir.getAzimuth() + 90.0;
        ListIterator it = this.faultTrace.listIterator();
        lastLoc = firstLoc = (Location)it.next();
        Location loc = null;
        Direction dir = null;
        while (it.hasNext()) {
            loc = (Location)it.next();
            dir = RelativeLocation.getDirection(lastLoc, loc);
            double azimuth = dir.getAzimuth();
            double distance = dir.getHorzDistance();
            segmentLenth[i] = distance;
            segmentAzimuth[i] = azimuth;
            segmentCumLenth[i] = cumDistance += distance;
            ++i;
            lastLoc = loc;
        }
        double downDipWidth = 0.0;
        double totVert = 0.0;
        double totHorz = 0.0;
        double depthLast = (Double)this.depths.get(0);
        for (i = 1; i < this.depths.size(); ++i) {
            double depth = (Double)this.depths.get(i);
            dip = (Double)this.dips.get(i - 1);
            downDipWidth += Math.abs(depth - depthLast) / Math.sin(dip * (Math.PI / 180));
            totVert += depth - depthLast;
            totHorz += Math.abs(depth - depthLast) / Math.tan(dip * (Math.PI / 180));
            depthLast = depth;
        }
        this.aveDip = Math.atan(totVert / totHorz) / (Math.PI / 180);
        int rows = 1 + Math.round((float)(downDipWidth / this.gridSpacing));
        int cols = 1 + Math.round((float)(segmentCumLenth[numSegments - 1] / this.gridSpacing));
        this.setNumRowsAndNumCols(rows, cols);
        for (int ith_col = 0; ith_col < cols; ++ith_col) {
            int segmentNumber;
            double distanceAlong = (double)ith_col * this.gridSpacing;
            for (segmentNumber = 1; segmentNumber <= numSegments && distanceAlong > segmentCumLenth[segmentNumber - 1]; ++segmentNumber) {
            }
            if (segmentNumber == numSegments + 1) {
                --segmentNumber;
            }
            double distance = segmentNumber > 1 ? distanceAlong - segmentCumLenth[segmentNumber - 2] : distanceAlong;
            Location location1 = this.faultTrace.getLocationAt(segmentNumber - 1);
            dir = new Direction(0.0, distance, segmentAzimuth[segmentNumber - 1], 0.0);
            Location topLocation = RelativeLocation.getLocation(location1, dir);
            this.setLocation(0, ith_col, (Location)topLocation.clone());
            dip = (Double)this.dips.get(0);
            double hDistance = this.gridSpacing * Math.cos(dip * (Math.PI / 180));
            double vDistance = -this.gridSpacing * Math.sin(dip * (Math.PI / 180));
            dir = new Direction(vDistance, hDistance, aveDipDirection, 0.0);
            int depthNum = 1;
            Location lastLocation = topLocation;
            for (int ith_row = 1; ith_row < rows; ++ith_row) {
                Location nextLocation = RelativeLocation.getLocation(lastLocation, dir);
                this.setLocation(ith_row, ith_col, (Location)nextLocation.clone());
                if (nextLocation.getDepth() > (Double)this.depths.get(depthNum) && ith_row != rows - 1) {
                    dip = (Double)this.dips.get(depthNum);
                    hDistance = this.gridSpacing * Math.cos(dip * (Math.PI / 180));
                    vDistance = -this.gridSpacing * Math.sin(dip * (Math.PI / 180));
                    dir = new Direction(vDistance, hDistance, aveDipDirection, 0.0);
                    ++depthNum;
                }
                lastLocation = nextLocation;
            }
        }
        this.setAveDip(this.aveDip);
    }

    protected void assertValidData() throws FaultException {
        ListIterator it1 = this.dips.listIterator();
        while (it1.hasNext()) {
            FaultUtils.assertValidDip((Double)it1.next());
        }
        ListIterator it2 = this.depths.listIterator();
        double depth = (Double)it2.next();
        FaultUtils.assertValidDepth(depth);
        double lastDepth = depth;
        while (it2.hasNext()) {
            double nextDepth = (Double)it2.next();
            FaultUtils.assertValidDepth(nextDepth);
            if (nextDepth < lastDepth) {
                throw new FaultException("SimpleListricGriddedFaultFactoryFault depths must be monotonically increasing");
            }
            lastDepth = nextDepth;
        }
        if (this.depths.size() != this.dips.size() + 1) {
            throw new FaultException("SimpleListricGriddedFaultFactoryNumber of Depths must equal Number of Dips + 1");
        }
        if (this.faultTrace == null) {
            throw new FaultException("SimpleListricGriddedFaultFactoryFault Trace is null");
        }
        ListIterator it = this.faultTrace.listIterator();
        while (it.hasNext()) {
            if (((Location)it.next()).getDepth() == depth) continue;
            throw new FaultException("SimpleListricGriddedFaultFactoryAll depths of faultTrace locations must be same as the first depth in the depths ArrayList");
        }
        if (!(this.gridSpacing > 0.0)) {
            throw new FaultException("SimpleListricGriddedFaultFactoryinvalid gridSpacing");
        }
    }

    private void setAveDip(double aveDip) throws FaultException {
        FaultUtils.assertValidDip(aveDip);
        this.aveDip = aveDip;
    }

    public static void main(String[] args) {
        FaultTrace faultTrace = new FaultTrace("test");
        faultTrace.addLocation(new Location(38.2248, -122.0, 0.0));
        faultTrace.addLocation(new Location(38.0, -122.0, 0.0));
        faultTrace.addLocation(new Location(37.8, -122.2, 0.0));
        ArrayList<Double> dips = new ArrayList<Double>();
        dips.add(new Double(60.0));
        dips.add(new Double(45.0));
        ArrayList<Double> depths = new ArrayList<Double>();
        depths.add(new Double(0.0));
        depths.add(new Double(5.0));
        depths.add(new Double(10.0));
        SimpleListricGriddedSurface test = new SimpleListricGriddedSurface(faultTrace, dips, depths, 1.0);
        ListIterator it = test.getLocationsIterator();
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            System.out.println(loc.getLatitude() + "  " + loc.getLongitude() + "  " + loc.getDepth());
        }
    }
}

