/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CallBackStringParam;
import com.isti.util.FileUtils;
import com.isti.util.IstiDialogInterface;
import com.isti.util.IstiNotifyThread;
import com.isti.util.IstiThread;
import com.isti.util.LogFile;
import com.isti.util.ProgressIndicatorInterface;
import com.isti.util.UtilFns;
import com.isti.util.ZipFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.zip.ZipFile;

public class FileDownloader
extends IstiNotifyThread {
    private final String fileNameStr;
    private final File outputDir;
    private final IstiDialogInterface dialogObj;
    private final ProgressIndicatorInterface progressBarObj;
    private final boolean unzipDownloadedFileFlag;
    private CallBackStringParam callBackObj = null;
    private int retryDelayTimeMS = 1000;
    private int maxRetryCount = 10;
    private long downloadLength = 0L;
    long maxProgressVal = 0L;
    private File outputFile = null;
    private ZipFile zf = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean downloadDoneFlag = false;
    private final Object threadFinishedSyncObj = new Object();

    public FileDownloader(String fileNameStr, File outputDir, CallBackStringParam callBackObj, IstiDialogInterface dialogObj, ProgressIndicatorInterface progressBarObj, boolean unzipDownloadedFileFlag) {
        super("FileDownloader-" + IstiThread.nextThreadNum());
        this.fileNameStr = fileNameStr;
        this.outputDir = outputDir;
        this.callBackObj = callBackObj;
        this.dialogObj = dialogObj;
        this.progressBarObj = progressBarObj;
        this.unzipDownloadedFileFlag = unzipDownloadedFileFlag;
    }

    public FileDownloader(String fileNameStr, File outputDir, CallBackStringParam callBackObj, IstiDialogInterface dialogObj, ProgressIndicatorInterface progressBarObj) {
        this(fileNameStr, outputDir, callBackObj, dialogObj, progressBarObj, true);
    }

    public void setCallBackObj(CallBackStringParam callBackObj) {
        this.callBackObj = callBackObj;
    }

    public void run() {
        String callBackStr;
        block32: {
            LogFile.getGlobalLogObj(false).debug3("FileDownloader:  Started download thread for \"" + this.fileNameStr + "\"");
            if (this.isTerminated()) {
                this.downloadDoneFlag = true;
                LogFile.getGlobalLogObj(false).debug("FileDownloader:  Terminate flag set at startup; aborting");
                return;
            }
            callBackStr = null;
            try {
                if (!this.outputDir.exists() ? !this.outputDir.mkdirs() : !this.outputDir.isDirectory()) {
                    callBackStr = "Unable to create output directory: " + this.outputDir;
                    throw new RuntimeException(callBackStr);
                }
                if (this.dialogObj != null) {
                    this.dialogObj.show();
                }
                URL fileUrl = new URL(this.fileNameStr);
                URLConnection fileUrlCon = fileUrl.openConnection();
                if (this.isTerminated()) break block32;
                this.downloadLength = fileUrlCon.getContentLength();
                if (this.progressBarObj != null) {
                    this.maxProgressVal = this.downloadLength;
                    if (this.maxProgressVal > Integer.MAX_VALUE) {
                        this.maxProgressVal = Integer.MAX_VALUE;
                    }
                    this.progressBarObj.setMaximum((int)this.maxProgressVal);
                }
                File inputFile = new File(fileUrl.getFile());
                String zipFileNameStr = inputFile.getName();
                this.outputFile = new File(this.outputDir, zipFileNameStr);
                try {
                    this.out = new FileOutputStream(this.outputFile);
                }
                catch (Exception ex) {
                    callBackStr = "Unable to open output directory: " + this.outputDir;
                    throw ex;
                }
                LogFile.getGlobalLogObj(false).debug3("FileDownloader:  Opening input stream to \"" + this.fileNameStr + "\"");
                int retryCount = 0;
                while (!this.isTerminated()) {
                    try {
                        this.in = fileUrl.openStream();
                        if (this.isTerminated()) {
                            try {
                                this.in.close();
                            }
                            catch (IOException ex) {}
                            break;
                        }
                        LogFile.getGlobalLogObj(false).debug3("FileDownloader:  Opening output stream to \"" + this.outputFile + "\"");
                        LogFile.getGlobalLogObj(false).debug3("FileDownloader:  Starting transfer of data");
                        this.transferStream(this.in, this.out);
                        LogFile.getGlobalLogObj(false).debug3("FileDownloader:  Finished transfer of data");
                        break;
                    }
                    catch (Exception ex) {
                        if (++retryCount >= this.maxRetryCount) {
                            throw ex;
                        }
                        if (this.out != null) {
                            try {
                                this.out.close();
                            }
                            catch (IOException ex2) {
                                // empty catch block
                            }
                            this.out = null;
                        }
                        this.waitForNotify(this.retryDelayTimeMS);
                        LogFile.getGlobalLogObj(false).debug("FileDownloader:  Retrying transfer from \"" + this.fileNameStr + "\" after error:  " + ex);
                    }
                }
                this.closeStreams();
                if (!this.isTerminated()) {
                    if (this.unzipDownloadedFileFlag && ZipFileUtils.hasZipExtension(this.outputFile.getName())) {
                        this.zf = ZipFileUtils.openZipFile(this.outputFile);
                        ZipFileUtils.unzipZipFile(this.zf, this.outputDir, true);
                    }
                } else {
                    LogFile.getGlobalLogObj(false).debug3("FileDownloader:  Terminate flag set; aborting");
                }
            }
            catch (Throwable ex) {
                LogFile.getGlobalLogObj(false).warning("FileDownloader:  " + ex);
                if (callBackStr != null) break block32;
                if (ex instanceof FileNotFoundException) {
                    callBackStr = "Unable to find file:  " + this.fileNameStr;
                }
                if (ex instanceof UnknownHostException) {
                    callBackStr = "Unable to find file (\"" + this.fileNameStr + "\"):  " + ex;
                }
                LogFile.getGlobalLogObj(false).warning(UtilFns.getStackTraceString(ex));
                callBackStr = "Error loading data:  " + ex;
            }
        }
        try {
            this.closeStreams();
            if (this.zf != null) {
                try {
                    this.zf.close();
                    this.zf = null;
                }
                catch (Exception ex) {
                    LogFile.getGlobalLogObj(false).warning("FileDownloader zip close: " + ex.toString());
                    LogFile.getGlobalLogObj(false).warning(UtilFns.getStackTraceString(ex));
                }
                if (this.outputFile != null) {
                    this.outputFile.delete();
                }
            }
            if ((this.isTerminated() || callBackStr != null) && this.outputFile != null && this.outputFile.exists() && this.outputFile.length() == 0L) {
                this.outputFile.delete();
            }
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(false).warning("FileDownloader cleanup: " + ex.toString());
            LogFile.getGlobalLogObj(false).warning(UtilFns.getStackTraceString(ex));
        }
        this.downloadDoneFlag = true;
        if (this.dialogObj != null) {
            this.dialogObj.close();
        }
        this.threadFinished(callBackStr);
    }

    protected void closeStreams() {
        if (this.in != null) {
            FileUtils.closeStream(this.in);
            this.in = null;
        }
        if (this.out != null) {
            FileUtils.closeStream(this.out);
            this.out = null;
        }
    }

    protected void transferStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int b;
        long progressValue = 0L;
        byte[] buffer = new byte[FileUtils.STREAM_TRANSFER_BUFFER_SIZE];
        while (!this.isTerminated() && (b = inputStream.read(buffer, 0, FileUtils.STREAM_TRANSFER_BUFFER_SIZE)) > 0) {
            if (this.progressBarObj != null && this.downloadLength > 0L) {
                int dialogVal = (int)((progressValue += (long)b) * this.maxProgressVal / this.downloadLength);
                this.progressBarObj.setValue(dialogVal);
            }
            outputStream.write(buffer, 0, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void threadFinished(String errMsgStr) {
        Object object = this.threadFinishedSyncObj;
        synchronized (object) {
            if (!this.isTerminated()) {
                this.doThreadFinished(errMsgStr);
            } else {
                LogFile.getGlobalLogObj(false).debug2("FileDownloader.threadFinished():  Terminate flag already set");
            }
        }
    }

    protected void doThreadFinished(String errMsgStr) {
        LogFile.getGlobalLogObj(false).debug3("FileDownloader:  Performing thread-finished operations");
        if (this.callBackObj != null) {
            this.callBackObj.callBackMethod(errMsgStr);
        }
    }

    public void terminate() {
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateThread(String msgStr) {
        Object object = this.threadFinishedSyncObj;
        synchronized (object) {
            if (!this.isTerminated()) {
                LogFile.getGlobalLogObj(false).debug2("FileDownloader:  Download terminate requested");
                this.doThreadFinished(msgStr);
                super.terminate();
            }
        }
    }

    public void requestDialogFocus() {
        try {
            if (this.dialogObj != null) {
                this.dialogObj.requestFocus();
            }
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(false).debug("FileDownloader.requestDialogFocus():  " + ex);
            LogFile.getGlobalLogObj(false).debug(UtilFns.getStackTraceString(ex));
        }
    }

    public boolean isDownloadDone() {
        return this.downloadDoneFlag;
    }

    public File getOutputFileObj() {
        return this.outputFile;
    }
}

