/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CallBackCompletion;
import com.isti.util.IstiFileFilter;
import com.isti.util.StreamTransferThread;
import com.isti.util.topleveldummy.TopLevelDummyUtil;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarFile;

public class FileUtils {
    protected static final boolean DEBUG_FLAG = false;
    protected static Applet appletObj = null;
    protected static FileUtils fileUtilsObj = new FileUtils();
    protected static int STREAM_TRANSFER_BUFFER_SIZE = 2048;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;
    protected static String lastCreateUnusedFileNameStr = "";
    protected static final Object lastCreateUnusedFNSyncObj = new Object();

    private FileUtils() {
    }

    public static InputStream fileMultiOpenInputStream(String nameStr) {
        InputStream stmObj;
        if (nameStr.indexOf(92) >= 0 && (stmObj = FileUtils.doFileMultiOpenInputStream(nameStr.replace('\\', '/'))) != null) {
            return stmObj;
        }
        return FileUtils.doFileMultiOpenInputStream(nameStr);
    }

    protected static InputStream doFileMultiOpenInputStream(String nameStr) {
        try {
            return new FileInputStream(nameStr);
        }
        catch (Exception ex) {
            InputStream stmObj;
            URL urlObj = null;
            try {
                urlObj = new URL(nameStr);
                stmObj = urlObj.openStream();
                if (stmObj != null) {
                    return stmObj;
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                stmObj = ClassLoader.getSystemResourceAsStream(nameStr);
                if (stmObj != null) {
                    return stmObj;
                }
            }
            catch (Exception ex3) {
                // empty catch block
            }
            urlObj = null;
            try {
                urlObj = ClassLoader.getSystemResource(nameStr);
                if (urlObj != null) {
                    File fileObj = new File(urlObj.getFile());
                    if (fileObj.exists()) {
                        return new FileInputStream(fileObj);
                    }
                    return urlObj.openConnection().getInputStream();
                }
            }
            catch (Exception ex4) {
                // empty catch block
            }
            try {
                stmObj = TopLevelDummyUtil.getTopLevelDummyClass().getResourceAsStream(nameStr);
                if (stmObj != null) {
                    return stmObj;
                }
                stmObj = fileUtilsObj.getClass().getResourceAsStream(nameStr);
                if (stmObj != null) {
                    return stmObj;
                }
            }
            catch (Exception ex5) {
            }
            catch (Throwable ex6) {
                ex6.printStackTrace();
            }
            try {
                int xPos = nameStr.indexOf(33);
                if (xPos > 0) {
                    int p = nameStr.indexOf(58);
                    p = p >= 0 && p < xPos ? ++p : 0;
                    JarFile jarFileObj = new JarFile(nameStr.substring(p, xPos));
                    return jarFileObj.getInputStream(jarFileObj.getJarEntry(nameStr.substring(xPos + 1)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static BufferedInputStream fileMultiOpenStream(String nameStr) {
        InputStream stmObj = FileUtils.fileMultiOpenInputStream(nameStr);
        return stmObj != null ? new BufferedInputStream(stmObj) : null;
    }

    public static BufferedReader fileMultiOpen(String nameStr) {
        InputStream stmObj = FileUtils.fileMultiOpenInputStream(nameStr);
        return FileUtils.getBufferedReader(stmObj);
    }

    public static InputStream appletResourceOpenInputStream(Applet appletObj, String nameStr) {
        InputStream stmObj;
        try {
            URL[] codeBaseArr = new URL[]{appletObj.getCodeBase()};
            URLClassLoader loaderObj = URLClassLoader.newInstance(codeBaseArr);
            URL urlObj = loaderObj.getResource(nameStr);
            if (urlObj != null) {
                return urlObj.openConnection().getInputStream();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            stmObj = TopLevelDummyUtil.getTopLevelDummyClass().getResourceAsStream(nameStr);
            if (stmObj != null) {
                return stmObj;
            }
            stmObj = fileUtilsObj.getClass().getResourceAsStream(nameStr);
            if (stmObj != null) {
                return stmObj;
            }
        }
        catch (Exception ex) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        URL urlObj = null;
        try {
            urlObj = TopLevelDummyUtil.getTopLevelDummyClass().getResource(nameStr);
            if (urlObj != null || (urlObj = fileUtilsObj.getClass().getResource(nameStr)) != null) {
                File fileObj = new File(urlObj.getFile());
                if (fileObj.exists()) {
                    return new FileInputStream(fileObj);
                }
                return urlObj.openConnection().getInputStream();
            }
        }
        catch (Exception ex) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            stmObj = ClassLoader.getSystemResourceAsStream(nameStr);
            if (stmObj != null) {
                return stmObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return null;
    }

    public static BufferedInputStream appletResourceOpenStream(Applet appletObj, String nameStr) {
        InputStream stmObj = FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
        return stmObj != null ? new BufferedInputStream(stmObj) : null;
    }

    public static BufferedReader appletResourceOpen(Applet appletObj, String nameStr) {
        InputStream stmObj = FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
        return FileUtils.getBufferedReader(stmObj);
    }

    public static void setAppletObj(Applet appletObj) {
        FileUtils.appletObj = appletObj;
    }

    public static InputStream appResourceOpenInputStream(String nameStr) {
        return appletObj == null ? FileUtils.fileMultiOpenInputStream(nameStr) : FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
    }

    public static BufferedInputStream appResourceOpenStream(String nameStr) {
        return appletObj == null ? FileUtils.fileMultiOpenStream(nameStr) : FileUtils.appletResourceOpenStream(appletObj, nameStr);
    }

    public static BufferedReader appResourceOpen(String nameStr) {
        InputStream stmObj = appletObj == null ? FileUtils.fileMultiOpenInputStream(nameStr) : FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
        return FileUtils.getBufferedReader(stmObj);
    }

    public static URL fileMultiOpenInputURL(String nameStr) {
        URL urlObj;
        if (nameStr.indexOf(92) >= 0 && (urlObj = FileUtils.doFileMultiOpenInputURL(nameStr.replace('\\', '/'))) != null) {
            return urlObj;
        }
        return FileUtils.doFileMultiOpenInputURL(nameStr);
    }

    protected static URL doFileMultiOpenInputURL(String nameStr) {
        try {
            File fileObj = new File(nameStr);
            if (fileObj.isFile()) {
                return fileObj.toURL();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        URL urlObj = null;
        try {
            urlObj = new URL(nameStr);
            InputStream stmObj = urlObj.openStream();
            if (stmObj != null) {
                stmObj.close();
                return urlObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            urlObj = ClassLoader.getSystemResource(nameStr);
            if (urlObj != null) {
                return urlObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            urlObj = TopLevelDummyUtil.getTopLevelDummyClass().getResource(nameStr);
            if (urlObj != null) {
                return urlObj;
            }
            urlObj = fileUtilsObj.getClass().getResource(nameStr);
            if (urlObj != null) {
                return urlObj;
            }
        }
        catch (Exception ex) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void writeStringToFile(String fileNameStr, String dataStr, boolean appendFlag) throws IOException {
        FileWriter wtrObj = new FileWriter(fileNameStr, appendFlag);
        wtrObj.write(dataStr);
        wtrObj.close();
    }

    public static void writeStringToFile(String fileNameStr, String dataStr) throws IOException {
        FileUtils.writeStringToFile(fileNameStr, dataStr, false);
    }

    public static void writeStringToFile(File fileObj, String dataStr, boolean appendFlag) throws IOException {
        FileUtils.writeStringToFile(fileObj.getPath(), dataStr, appendFlag);
    }

    public static void writeStringToFile(File fileObj, String dataStr) throws IOException {
        FileUtils.writeStringToFile(fileObj.getPath(), dataStr, false);
    }

    public static String readStreamToString(BufferedReader rdrObj) throws IOException {
        String str;
        StringWriter strWtrObj = new StringWriter();
        PrintWriter prtWtrObj = new PrintWriter(strWtrObj);
        while ((str = rdrObj.readLine()) != null) {
            prtWtrObj.println(str);
        }
        prtWtrObj.flush();
        return strWtrObj.toString();
    }

    public static String readStreamToString(InputStream stmObj) throws IOException {
        return FileUtils.readStreamToString(FileUtils.getBufferedReader(stmObj));
    }

    public static String readFileToString(String fileNameStr) throws FileNotFoundException, IOException {
        BufferedReader rdrObj = new BufferedReader(new FileReader(fileNameStr));
        String retStr = FileUtils.readStreamToString(rdrObj);
        rdrObj.close();
        return retStr;
    }

    public static String readFileToString(File fileObj) throws FileNotFoundException, IOException {
        return FileUtils.readFileToString(fileObj.getPath());
    }

    public static String readMultiOpenFileToString(String fileNameStr) throws FileNotFoundException, IOException {
        BufferedReader rdrObj = FileUtils.fileMultiOpen(fileNameStr);
        if (rdrObj == null) {
            throw new FileNotFoundException("Unable to open \"" + fileNameStr + "\" as file or URL");
        }
        String retStr = FileUtils.readStreamToString(rdrObj);
        rdrObj.close();
        return retStr;
    }

    public static byte[] readStreamToBuffer(InputStream stmObj) throws IOException {
        ByteArrayOutputStream outStmObj = new ByteArrayOutputStream();
        FileUtils.transferStream(stmObj, outStmObj);
        outStmObj.flush();
        return outStmObj.toByteArray();
    }

    public static byte[] readFileToBuffer(String fileNameStr) throws FileNotFoundException, IOException {
        BufferedInputStream inStm = new BufferedInputStream(new FileInputStream(fileNameStr));
        byte[] byteArr = FileUtils.readStreamToBuffer(inStm);
        inStm.close();
        return byteArr;
    }

    public static byte[] readFileToBuffer(File fileObj) throws FileNotFoundException, IOException {
        return FileUtils.readFileToBuffer(fileObj.getPath());
    }

    public static byte[] readMultiOpenFileToBuffer(String fileNameStr) throws FileNotFoundException, IOException {
        BufferedInputStream inStm = FileUtils.fileMultiOpenStream(fileNameStr);
        if (inStm == null) {
            throw new FileNotFoundException("Unable to open \"" + fileNameStr + "\" as file or URL");
        }
        byte[] byteArr = FileUtils.readStreamToBuffer(inStm);
        inStm.close();
        return byteArr;
    }

    public static boolean createParentDirs(File fileObj) {
        try {
            File parentFileObj;
            if (!fileObj.exists() && (parentFileObj = fileObj.getParentFile()) != null && !parentFileObj.isDirectory()) {
                return parentFileObj.mkdirs();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean createParentDirs(String nameStr) {
        try {
            File parentFileObj;
            File fileObj = new File(nameStr);
            if (!fileObj.exists() && (parentFileObj = fileObj.getParentFile()) != null && !parentFileObj.isDirectory()) {
                return parentFileObj.mkdirs();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static File[] listFiles(File directoryObj) {
        return directoryObj.listFiles();
    }

    public static File[] listFiles(File directoryObj, FileFilter filter) {
        return filter != null ? directoryObj.listFiles(filter) : directoryObj.listFiles();
    }

    public static File[] listAllFiles(File dirFileObj, FileFilter filterObj) {
        File[] dirFileArr = dirFileObj.listFiles(filterObj);
        if (dirFileArr != null && dirFileArr.length > 0) {
            ArrayList<File> fileListObj = null;
            for (int dfIdx = 0; dfIdx < dirFileArr.length; ++dfIdx) {
                File[] foundFilesArr;
                if (!dirFileArr[dfIdx].isDirectory()) continue;
                if (fileListObj == null) {
                    fileListObj = new ArrayList<File>();
                    for (int i = 0; i < dirFileArr.length; ++i) {
                        File fileObj = dirFileArr[i];
                        if (fileObj.isDirectory()) continue;
                        fileListObj.add(fileObj);
                    }
                }
                if ((foundFilesArr = FileUtils.listAllFiles(dirFileArr[dfIdx], filterObj)) == null || foundFilesArr.length <= 0) continue;
                fileListObj.addAll(Arrays.asList(foundFilesArr));
            }
            if (fileListObj != null) {
                return fileListObj.toArray(new File[fileListObj.size()]);
            }
        }
        return dirFileArr;
    }

    public static BufferedReader getBufferedReader(InputStream stmObj) {
        return stmObj != null ? new BufferedReader(new InputStreamReader(stmObj)) : null;
    }

    public static long getFileAge(File f, long currentTime) {
        long fileTime = f.lastModified();
        long age = currentTime - fileTime;
        return age;
    }

    public static void deleteFiles(File file) {
        File[] fileList;
        if (file.isDirectory() && (fileList = file.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                FileUtils.deleteFiles(fileList[i]);
            }
        }
        file.delete();
    }

    public static void deleteFiles(File[] fileList, long maxAgeMs) {
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < fileList.length; ++i) {
            long age = FileUtils.getFileAge(fileList[i], currentTime);
            if (age <= maxAgeMs) continue;
            fileList[i].delete();
        }
    }

    public static void deleteFiles(File[] fileList, int maxAgeDays) {
        FileUtils.deleteFiles(fileList, (long)maxAgeDays * 86400000L);
    }

    public static void deleteOldFiles(File directoryObj, long maxAgeMs, String filterStr) {
        if (maxAgeMs > 0L && directoryObj.isDirectory()) {
            File[] fileList = FileUtils.listFiles(directoryObj, filterStr != null ? IstiFileFilter.createFileFilter(filterStr) : null);
            FileUtils.deleteFiles(fileList, maxAgeMs);
        }
    }

    public static void deleteOldFiles(File directoryObj, long maxAgeMs) {
        FileUtils.deleteOldFiles(directoryObj, maxAgeMs, null);
    }

    public static void deleteOldFiles(File directoryObj, int maxAgeDays, String filterStr) {
        FileUtils.deleteOldFiles(directoryObj, (long)maxAgeDays * 86400000L, filterStr);
    }

    public static void deleteOldFiles(File directoryObj, int maxAgeDays) {
        FileUtils.deleteOldFiles(directoryObj, (long)maxAgeDays * 86400000L, null);
    }

    public static int getFileExtensionIndex(String fileNameStr) {
        return fileNameStr.lastIndexOf(46);
    }

    public static String getFileExtension(String fileNameStr) {
        int extIndex = fileNameStr.lastIndexOf(".");
        if (extIndex > 0 && extIndex < fileNameStr.length() - 1) {
            return fileNameStr.substring(extIndex + 1);
        }
        return null;
    }

    public static String getFileNameWithoutExtension(String fileNameStr) {
        int extIdx = FileUtils.getFileExtensionIndex(fileNameStr);
        if (extIdx >= 0) {
            fileNameStr = fileNameStr.substring(0, extIdx);
        }
        return fileNameStr;
    }

    public static String removeLeadingDotDir(String fileNameStr) {
        return fileNameStr != null && fileNameStr.length() > 1 && fileNameStr.charAt(0) == '.' && (fileNameStr.charAt(1) == '/' || fileNameStr.charAt(1) == '\\') ? fileNameStr.substring(2) : fileNameStr;
    }

    public static long getLastModifiedTime(String nameStr) {
        try {
            URLConnection urlConnObj;
            long timeVal;
            File fileObj = new File(nameStr);
            if (fileObj.exists() && (timeVal = fileObj.lastModified()) > 0L) {
                return timeVal;
            }
            URL urlObj = FileUtils.fileMultiOpenInputURL(nameStr);
            if (urlObj != null && (urlConnObj = urlObj.openConnection()) != null && (timeVal = urlConnObj.getLastModified()) > 0L) {
                return timeVal;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public static long getFileLength(String nameStr) {
        try {
            URLConnection urlConnObj;
            long lengthVal;
            File fileObj = new File(nameStr);
            if (fileObj.exists() && (lengthVal = fileObj.length()) >= 0L) {
                return lengthVal;
            }
            URL urlObj = FileUtils.fileMultiOpenInputURL(nameStr);
            if (urlObj != null && (urlConnObj = urlObj.openConnection()) != null && (lengthVal = (long)urlConnObj.getContentLength()) >= 0L) {
                return lengthVal;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public static boolean urlExists(URL urlObj) throws IOException {
        InputStream stmObj = urlObj.openStream();
        stmObj.close();
        return true;
    }

    public static URL getURL(String nameStr) {
        URL urlObj;
        if (nameStr.indexOf(92) >= 0 && (urlObj = FileUtils.doGetURL(nameStr.replace('\\', '/'))) != null) {
            return urlObj;
        }
        return FileUtils.doGetURL(nameStr);
    }

    protected static URL doGetURL(String nameStr) {
        URL urlObj = null;
        try {
            urlObj = new URL(nameStr);
            if (FileUtils.urlExists(urlObj)) {
                return urlObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            urlObj = new File(nameStr).toURL();
            if (FileUtils.urlExists(urlObj)) {
                return urlObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            urlObj = ClassLoader.getSystemResource(nameStr);
            if (FileUtils.urlExists(urlObj)) {
                return urlObj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean existsMultiOpen(String nameStr) {
        if (!new File(nameStr).exists()) {
            InputStream stmObj = FileUtils.fileMultiOpenInputStream(nameStr);
            if (stmObj == null) {
                return false;
            }
            FileUtils.closeStream(stmObj);
        }
        return true;
    }

    public static boolean isDirSepChar(char ch) {
        return ch == '/' || ch == '\\' || ch == ':';
    }

    public static boolean endsWithDirSepChar(String str) {
        int len;
        return str != null && (len = str.length()) > 0 && FileUtils.isDirSepChar(str.charAt(len - 1));
    }

    public static String buildPathName(String dirStr, String fileStr, boolean forwardSlashFlag) {
        String pathStr = dirStr + (FileUtils.endsWithDirSepChar(dirStr) ? "" : "/") + fileStr;
        return forwardSlashFlag ? pathStr.replace('\\', '/') : pathStr;
    }

    public static String buildPathName(String dirStr, String fileStr) {
        return FileUtils.buildPathName(dirStr, fileStr, true);
    }

    public static String addStrToFileName(String fileNameStr, String s) {
        int extIndex = fileNameStr.lastIndexOf(".");
        fileNameStr = extIndex >= 0 ? fileNameStr.substring(0, extIndex) + s + fileNameStr.substring(extIndex, fileNameStr.length()) : fileNameStr + s;
        return fileNameStr;
    }

    public static String createBackupFileName(String fileNameStr) {
        return FileUtils.createBackupFileName(fileNameStr, null);
    }

    public static String createBackupFileName(String fileNameStr, String backupStr) {
        if (backupStr != null) {
            fileNameStr = FileUtils.addStrToFileName(fileNameStr, backupStr);
        }
        String lastNameStr = new File(fileNameStr).getName();
        lastNameStr = FileUtils.getFileNameWithoutExtension(lastNameStr).toLowerCase();
        String filterString = FileUtils.addStrToFileName(fileNameStr, "*");
        IstiFileFilter filter = new IstiFileFilter(filterString);
        File[] fileList = FileUtils.listFiles(new File(fileNameStr).getParentFile(), filter);
        int lastNameStrLength = lastNameStr.length();
        int maxBn = 0;
        for (int i = 0; i < fileList.length; ++i) {
            int bn;
            String fn = fileList[i].getName();
            int bnIdx = (fn = FileUtils.getFileNameWithoutExtension(fn)).toLowerCase().indexOf(lastNameStr);
            if (bnIdx < 0 || (bn = new Integer(fn.substring(bnIdx += lastNameStrLength)).intValue()) <= maxBn) continue;
            maxBn = bn;
        }
        return FileUtils.addStrToFileName(fileNameStr, Integer.toString(++maxBn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createUnusedFileNameObj(String tmplStr, String parentDirStr, boolean useTimeFlag, boolean fileExtFlag) {
        Object object;
        String retFileStr;
        File retFileObj;
        block18: {
            int tmplStrLen;
            String sepStr;
            int maxAttempts = 1000;
            int cnt = 0;
            if (tmplStr == null) {
                tmplStr = "";
            }
            String string = sepStr = (tmplStrLen = tmplStr.length()) > 0 ? "_" : "";
            if (useTimeFlag) {
                while (true) {
                    boolean sameFNameFlag;
                    String fNameStr = fileExtFlag ? FileUtils.addStrToFileName(tmplStr, sepStr + Long.toString(System.currentTimeMillis())) : tmplStr + sepStr + Long.toString(System.currentTimeMillis());
                    retFileObj = new File(parentDirStr, fNameStr);
                    retFileStr = retFileObj.getAbsolutePath();
                    object = lastCreateUnusedFNSyncObj;
                    synchronized (object) {
                        sameFNameFlag = retFileStr.equals(lastCreateUnusedFileNameStr);
                    }
                    if (sameFNameFlag || retFileObj.exists()) {
                        if (++cnt >= 1000) {
                            return null;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ex) {}
                        continue;
                    }
                    break block18;
                    break;
                }
            }
            if (tmplStrLen <= 0) {
                ++cnt;
            }
            do {
                boolean sameFNameFlag;
                String fNameStr = cnt == 0 ? tmplStr : (fileExtFlag ? FileUtils.addStrToFileName(tmplStr, sepStr + Integer.toString(cnt)) : tmplStr + sepStr + Integer.toString(cnt));
                retFileObj = new File(parentDirStr, fNameStr);
                retFileStr = retFileObj.getAbsolutePath();
                object = lastCreateUnusedFNSyncObj;
                synchronized (object) {
                    sameFNameFlag = retFileStr.equals(lastCreateUnusedFileNameStr);
                }
                if (!sameFNameFlag && !retFileObj.exists()) break block18;
            } while (++cnt < 1000);
            return null;
        }
        object = lastCreateUnusedFNSyncObj;
        synchronized (object) {
            lastCreateUnusedFileNameStr = retFileStr;
        }
        return retFileObj;
    }

    public static File createUnusedFileNameObj(String tmplStr, String parentDirStr, boolean useTimeFlag) {
        return FileUtils.createUnusedFileNameObj(tmplStr, parentDirStr, useTimeFlag, true);
    }

    public static File createUnusedFileNameObj(String tmplStr, File parentDirFileObj, boolean useTimeFlag, boolean fileExtFlag) {
        return FileUtils.createUnusedFileNameObj(tmplStr, parentDirFileObj != null ? parentDirFileObj.getPath() : null, useTimeFlag, fileExtFlag);
    }

    public static File createUnusedFileNameObj(String tmplStr, File parentDirFileObj, boolean useTimeFlag) {
        return FileUtils.createUnusedFileNameObj(tmplStr, parentDirFileObj, useTimeFlag, true);
    }

    public static void transferStream(InputStream inputStreamObj, OutputStream outputStreamObj) throws IOException {
        int b;
        byte[] buffer = new byte[STREAM_TRANSFER_BUFFER_SIZE];
        while ((b = inputStreamObj.read(buffer, 0, STREAM_TRANSFER_BUFFER_SIZE)) > 0) {
            outputStreamObj.write(buffer, 0, b);
        }
    }

    public static void transferStream(InputStream inputStreamObj, OutputStream outputStreamObj, long maxBytesLimit) throws IOException {
        int b;
        if (maxBytesLimit <= 0L) {
            FileUtils.transferStream(inputStreamObj, outputStreamObj);
            return;
        }
        long byteTotal = 0L;
        byte[] buffer = new byte[STREAM_TRANSFER_BUFFER_SIZE];
        while (byteTotal + (long)STREAM_TRANSFER_BUFFER_SIZE < maxBytesLimit) {
            b = inputStreamObj.read(buffer, 0, STREAM_TRANSFER_BUFFER_SIZE);
            if (b <= 0) {
                return;
            }
            outputStreamObj.write(buffer, 0, b);
            byteTotal += (long)b;
        }
        b = inputStreamObj.read(buffer, 0, (int)(maxBytesLimit - byteTotal));
        if (b > 0) {
            outputStreamObj.write(buffer, 0, b);
        }
    }

    public static void transferStream(InputStream inputStreamObj, OutputStream outputStreamObj, CallBackCompletion callBack) throws IOException {
        if (callBack == null) {
            FileUtils.transferStream(inputStreamObj, outputStreamObj);
        } else {
            new StreamTransferThread(inputStreamObj, outputStreamObj, callBack).start();
        }
    }

    public static void copyFile(String sourceFileNameStr, String destFileNameStr) throws FileNotFoundException, IOException {
        if (destFileNameStr.equals(sourceFileNameStr)) {
            throw new IOException("Destination same as source");
        }
        BufferedInputStream inStm = new BufferedInputStream(new FileInputStream(sourceFileNameStr));
        BufferedOutputStream outStm = new BufferedOutputStream(new FileOutputStream(destFileNameStr));
        FileUtils.transferStream(inStm, outStm);
        FileUtils.closeStream(outStm);
        FileUtils.closeStream(inStm);
    }

    public static void copyFile(File sourceFileObj, File destFileObj) throws FileNotFoundException, IOException {
        FileUtils.copyFile(sourceFileObj.getPath(), destFileObj.getPath());
    }

    public static void readFileTail(String sourceFileNameStr, long numberOfLines, OutputStream outputStreamObj) throws FileNotFoundException, IOException {
        if (numberOfLines <= 0L) {
            return;
        }
        RandomAccessFile rndAccFileObj = new RandomAccessFile(sourceFileNameStr, "r");
        long srcFileLen = rndAccFileObj.length();
        int buffLen = 10240;
        byte[] buff = new byte[10240];
        long numBuffs = 0L;
        long srcFilePos = srcFileLen;
        int buffPos = 10240;
        int buffUseLen = 10240;
        long lineCount = 0L;
        boolean firstBuffFlag = true;
        block0: while (srcFilePos > 0L) {
            if ((srcFilePos -= 10240L) >= 0L) {
                rndAccFileObj.seek(srcFilePos);
                rndAccFileObj.readFully(buff);
                ++numBuffs;
            } else {
                if ((buffUseLen = (int)((long)buffUseLen + srcFilePos)) > 0) {
                    rndAccFileObj.seek(0L);
                    rndAccFileObj.readFully(buff, 0, buffUseLen);
                    ++numBuffs;
                }
                srcFilePos = 0L;
            }
            if (buffUseLen <= 0) break;
            buffPos = buffUseLen;
            if (firstBuffFlag) {
                firstBuffFlag = false;
                if (buff[buffPos - 1] == 10) {
                    --buffPos;
                }
            }
            while (buffPos > 0) {
                if (buff[--buffPos] != 10 || ++lineCount < numberOfLines) continue;
                ++buffPos;
                break block0;
            }
        }
        if (buffPos < buffUseLen) {
            outputStreamObj.write(buff, buffPos, buffUseLen - buffPos);
        }
        while (--numBuffs > 0L) {
            rndAccFileObj.readFully(buff);
            outputStreamObj.write(buff);
        }
        rndAccFileObj.close();
    }

    public static boolean closeStream(InputStream inputStreamObj) {
        try {
            inputStreamObj.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream outputStreamObj) {
        try {
            outputStreamObj.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

