/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.CfgPropValidator;
import com.isti.util.UtilFns;
import com.isti.util.VectorSet;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class IstiLocale
implements Archivable {
    public static String DEFAULT_DISPLAY_NAME = "Default";
    private Date _archiveDate = null;
    private final Locale _localeObj;
    private final String _displayName;

    public IstiLocale(IstiLocale istiLocaleObj) {
        this._archiveDate = istiLocaleObj._archiveDate;
        this._displayName = istiLocaleObj._displayName;
        this._localeObj = istiLocaleObj._localeObj;
    }

    public IstiLocale(Locale localeObj) {
        this._localeObj = localeObj;
        this._displayName = localeObj == null ? DEFAULT_DISPLAY_NAME : IstiLocale.getDisplayName(localeObj, "");
    }

    public IstiLocale(String dataStr, Archivable.Marker mkrObj) {
        if (dataStr == null || DEFAULT_DISPLAY_NAME.equals(dataStr)) {
            this._displayName = DEFAULT_DISPLAY_NAME;
            this._localeObj = null;
        } else {
            this._localeObj = IstiLocale.getLocaleFromDataString(dataStr);
            this._displayName = IstiLocale.getDisplayName(this._localeObj, "");
        }
    }

    public IstiLocale(String displayName) {
        if (displayName == null || DEFAULT_DISPLAY_NAME.equals(displayName)) {
            this._displayName = DEFAULT_DISPLAY_NAME;
            this._localeObj = null;
        } else {
            this._displayName = displayName;
            this._localeObj = IstiLocale.getLocaleFromDisplayName(displayName);
        }
    }

    public Object clone() {
        return new IstiLocale(this);
    }

    public boolean equals(IstiLocale obj) {
        return this.getDisplayName().equals(obj.getDisplayName());
    }

    public boolean equals(Locale obj) {
        return this.getLocale().equals(obj);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IstiLocale) {
            return this.equals((IstiLocale)obj);
        }
        if (obj instanceof Locale) {
            return this.equals((Locale)obj);
        }
        if (obj instanceof String) {
            return this.getDisplayName().equals(obj);
        }
        return false;
    }

    public Date getArchiveDate() {
        if (this._archiveDate == null) {
            return new Date();
        }
        return this._archiveDate;
    }

    public static Locale[] getAvailableNumberLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public static String getDisplayName(Locale localeObj) {
        return IstiLocale.getDisplayName(localeObj, null);
    }

    public static String getDisplayName(Locale localeObj, String defaultDisplayName) {
        String displayCountry = localeObj.getDisplayCountry();
        if (displayCountry != null && displayCountry.length() > 0) {
            return localeObj.getDisplayName();
        }
        return defaultDisplayName;
    }

    public Locale getLocale() {
        if (this._localeObj == null) {
            return UtilFns.getDefaultLocale();
        }
        return this._localeObj;
    }

    public static Locale getLocaleFromDataString(String dataStr) {
        if (dataStr == null || dataStr.length() <= 0 | dataStr.equals(DEFAULT_DISPLAY_NAME)) {
            return UtilFns.getSystemLocale();
        }
        Locale[] locales = IstiLocale.getAvailableNumberLocales();
        int numLocales = locales.length;
        for (int i = 0; i < numLocales; ++i) {
            String localeDataStr = locales[i].toString();
            if (localeDataStr == null || !dataStr.equals(localeDataStr)) continue;
            return locales[i];
        }
        return null;
    }

    public static Locale getLocaleFromDisplayName(String displayName) {
        if (displayName == null || displayName.length() <= 0 | displayName.equals(DEFAULT_DISPLAY_NAME)) {
            return UtilFns.getSystemLocale();
        }
        Locale[] locales = IstiLocale.getAvailableNumberLocales();
        int numLocales = locales.length;
        for (int i = 0; i < numLocales; ++i) {
            String localeDisplayName = IstiLocale.getDisplayName(locales[i]);
            if (localeDisplayName == null || !displayName.equals(localeDisplayName)) continue;
            return locales[i];
        }
        return null;
    }

    public static CfgPropValidator getCfgPropValidator() {
        Locale[] locales = IstiLocale.getAvailableNumberLocales();
        int numLocales = locales.length;
        VectorSet localeDisplayNamesVector = new VectorSet();
        ((Vector)localeDisplayNamesVector).add(DEFAULT_DISPLAY_NAME);
        for (int i = 0; i < numLocales; ++i) {
            String localeDisplayName = IstiLocale.getDisplayName(locales[i]);
            if (localeDisplayName == null) continue;
            ((Vector)localeDisplayNamesVector).add(localeDisplayName);
        }
        Object[] displayNames = localeDisplayNamesVector.toArray(new String[localeDisplayNamesVector.size()]);
        Arrays.sort(displayNames, 1, displayNames.length);
        return new CfgPropValidator(displayNames);
    }

    public int hashCode() {
        return this.getLocale().hashCode();
    }

    public void setArchiveDate(Date dateObj) {
        this._archiveDate = dateObj;
    }

    public String toArchivedForm() {
        if (DEFAULT_DISPLAY_NAME.equals(this.getDisplayName())) {
            return DEFAULT_DISPLAY_NAME;
        }
        return this.getLocale().toString();
    }

    public String toString() {
        return this.getDisplayName();
    }
}

