/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import javax.swing.SwingUtilities;

public class IstiThread
extends Thread {
    public static int DEFAULT_TERMINATE_WAIT_TIME = 100;
    protected boolean terminateFlag = false;
    private static int threadInitNumber = 0;
    private final Object threadWaitSyncObject = new Object();
    private boolean threadWaitNotifyFlag = false;
    private final Object startSyncObj = new Object();
    private boolean startedFlag = false;

    protected static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public IstiThread(Runnable target, String name) {
        this(null, target, name);
    }

    public IstiThread(String name) {
        this(null, null, name);
    }

    public IstiThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
        try {
            if (SwingUtilities.isEventDispatchThread() && Thread.currentThread().getPriority() > 5) {
                this.setPriority(5);
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    public IstiThread(ThreadGroup group, String name) {
        this(group, null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startSyncObj;
        synchronized (object) {
            if (this.startedFlag) {
                return;
            }
            this.startedFlag = true;
        }
        if (!this.terminateFlag && !this.isAlive()) {
            super.start();
        }
    }

    public void terminate() {
        this.terminate(DEFAULT_TERMINATE_WAIT_TIME);
    }

    public void terminate(long waitTimeMs) {
        if (!this.terminateFlag && this.isAlive()) {
            this.terminateFlag = true;
            try {
                this.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.waitForTerminate(waitTimeMs);
        }
    }

    public boolean isTerminated() {
        return this.terminateFlag;
    }

    public void waitForNotify() {
        this.waitForNotify(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForNotify(long waitTimeMs) {
        try {
            Object object = this.threadWaitSyncObject;
            synchronized (object) {
                if (!this.isTerminated()) {
                    if (!this.threadWaitNotifyFlag) {
                        this.threadWaitSyncObject.wait(waitTimeMs);
                        if (!this.threadWaitNotifyFlag) {
                            return true;
                        }
                    }
                    this.threadWaitNotifyFlag = false;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThread() {
        Object object = this.threadWaitSyncObject;
        synchronized (object) {
            this.threadWaitNotifyFlag = true;
            this.threadWaitSyncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearThreadWaitNotifyFlag() {
        Object object = this.threadWaitSyncObject;
        synchronized (object) {
            this.threadWaitNotifyFlag = false;
        }
    }

    public boolean wasStarted() {
        return this.startedFlag;
    }

    public void waitForTerminate() {
        this.waitForTerminate(DEFAULT_TERMINATE_WAIT_TIME);
    }

    public void waitForTerminate(long waitTimeMs) {
        try {
            this.join(waitTimeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

