/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.UtilFns;

public class IstiVersion
implements Comparable {
    private static final int MAJOR = 0;
    private static final int MINOR = 1;
    private static final int PATCH = 2;
    private static final int BUILD = 3;
    private static final int MIN_INDEX = 4;
    public static final String BETA_STRING = "beta";
    public static final String DIVIDER = ".";
    private final boolean beta;
    private final int[] versions;
    private final String versionString;

    public IstiVersion(String complete) {
        this(IstiVersion.getArgs(complete), IstiVersion.isBeta(complete));
    }

    public IstiVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public IstiVersion(String major, String minor) {
        this(major, minor, null);
    }

    public IstiVersion(int major, int minor, int patch) {
        this(major, minor, patch, 0);
    }

    public IstiVersion(String major, String minor, String patch) {
        this(major, minor, patch, null);
    }

    public IstiVersion(int major, int minor, int patch, int build) {
        this(major, minor, patch, build, false);
    }

    public IstiVersion(int major, int minor, int patch, int build, boolean beta) {
        this.beta = beta;
        this.versions = new int[4];
        this.versions[0] = major;
        this.versions[1] = minor;
        this.versions[2] = patch;
        this.versions[3] = build;
        this.versionString = this.createVersionString();
    }

    public IstiVersion(String major, String minor, String patch, String build) {
        this(major, minor, patch, build, false);
    }

    public IstiVersion(String major, String minor, String patch, String build, boolean beta) {
        this(IstiVersion.parseInt(major), IstiVersion.parseInt(minor), IstiVersion.parseInt(patch), IstiVersion.parseInt(build), beta);
    }

    public IstiVersion(int[] args) {
        this(args, false);
    }

    public IstiVersion(int[] args, boolean beta) {
        int i;
        this.beta = beta;
        int versionsLen = args.length;
        if (versionsLen >= 4) {
            for (i = versionsLen - 1; i >= 4 && args[i] <= 0; --i) {
                --versionsLen;
            }
        } else {
            versionsLen = 4;
        }
        if (versionsLen == args.length) {
            this.versions = args;
        } else {
            this.versions = new int[versionsLen];
            for (i = 0; i < args.length && i < versionsLen; ++i) {
                this.versions[i] = args[i];
            }
            while (i < versionsLen) {
                this.versions[i] = 0;
                ++i;
            }
        }
        this.versionString = this.createVersionString();
    }

    public IstiVersion(String[] args) {
        this(args, false);
    }

    public IstiVersion(String[] args, boolean beta) {
        this(IstiVersion.getArgs(args), beta);
    }

    protected String createVersionString() {
        StringBuffer versionStr = new StringBuffer(String.valueOf(this.versions[0]));
        for (int i = 1; i < this.versions.length; ++i) {
            versionStr.append(DIVIDER + this.versions[i]);
        }
        if (this.isBeta()) {
            versionStr.append(BETA_STRING);
        }
        return versionStr.toString();
    }

    protected static int[] getArgs(String complete) {
        int i;
        String[] subStrings = UtilFns.parseSeparatedSubstrings(complete, " ");
        for (i = subStrings.length - 1; i >= 0 && !Character.isDigit(subStrings[i].charAt(0)); --i) {
        }
        if (i < 0) {
            return new int[0];
        }
        String verStr = subStrings[i];
        String[] strArr = UtilFns.parseSeparatedSubstrings(verStr, DIVIDER);
        int[] integerArr = new int[strArr.length];
        for (i = 0; i < strArr.length; ++i) {
            integerArr[i] = IstiVersion.parseInt(strArr[i]);
        }
        return integerArr;
    }

    protected static int[] getArgs(String[] args) {
        int[] intArgs = new int[args.length];
        for (int i = args.length - 1; i >= 0; --i) {
            intArgs[i] = IstiVersion.parseInt(args[i]);
        }
        return intArgs;
    }

    protected static boolean isBeta(String complete) {
        return complete.toLowerCase().indexOf(BETA_STRING) >= 0;
    }

    protected static int parseInt(String s) {
        if (s != null) {
            try {
                return UtilFns.parseLeadingInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((IstiVersion)o);
    }

    public int compareTo(IstiVersion o) {
        int len1 = this.versions.length;
        int len2 = o.versions.length;
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            int v1 = this.versions[i];
            int v2 = o.versions[i];
            if (v1 == v2) continue;
            if (v1 < v2) {
                return -1;
            }
            return 1;
        }
        if (len1 != len2) {
            if (len1 < len2) {
                return -1;
            }
            return 1;
        }
        if (o.isBeta()) {
            if (!this.isBeta()) {
                return 1;
            }
        } else if (this.isBeta()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof IstiVersion && this.equals((IstiVersion)o);
    }

    public boolean equals(IstiVersion o) {
        return o != null && this.compareTo(o) == 0;
    }

    public int getBuild() {
        return this.versions[3];
    }

    int getMajor() {
        return this.versions[0];
    }

    public int getMinor() {
        return this.versions[1];
    }

    public int getPatch() {
        return this.versions[2];
    }

    public boolean isBeta() {
        return this.beta;
    }

    public String toString() {
        return this.versionString;
    }
}

