/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.database.ConnectionJDBC;
import com.isti.util.database.IstiConnectionInfoPanel;
import com.isti.util.database.MySQLConnectionJDBC;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.IstiDialogUtil;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class IstiConnectionInfoDialog
extends IstiDialogPopup {
    public static String LOGIN_DIALOG_DEFAULT_TITLE_STRING = IstiConnectionInfoPanel.LOGIN_DIALOG_DEFAULT_TITLE_STRING;
    private final IstiConnectionInfoPanel connectionInfoPanel;
    private final IstiDialogUtil dialogUtilObj;

    public IstiConnectionInfoDialog(Component parentComp) {
        this(parentComp, new IstiConnectionInfoPanel(), LOGIN_DIALOG_DEFAULT_TITLE_STRING, new IstiDialogUtil(parentComp));
        this.connectionInfoPanel.setHostname("localhost");
    }

    public IstiConnectionInfoDialog(Component parentComp, IstiConnectionInfoPanel infoPanel, String titleStr, IstiDialogUtil dialogUtilObj) {
        super(parentComp, (Object)infoPanel, titleStr, 2);
        this.connectionInfoPanel = infoPanel;
        this.setInitialFocusComponent(this.connectionInfoPanel.getUsernameFieldObj());
        this.dialogUtilObj = dialogUtilObj;
    }

    public Connection createMySQLConnection(String hostName, String port, String userName, String password, String dataBase) {
        try {
            MySQLConnectionJDBC.registerDriver();
            String url = MySQLConnectionJDBC.getUrl(hostName, null, port, dataBase);
            Properties info = ConnectionJDBC.saveUserPassword(null, userName, password);
            MySQLConnectionJDBC mySqlConn = new MySQLConnectionJDBC(url, info, null);
            mySqlConn.createConnection();
            return mySqlConn.getConnection();
        }
        catch (ClassNotFoundException ex) {
            this.showErrorMessage("The MySQL driver's class could not be found: " + ex);
        }
        catch (InstantiationException ex) {
            this.showErrorMessage("The MySQL driver could not be instantiated:" + ex);
        }
        catch (IllegalAccessException ex) {
            this.showErrorMessage("The MySQL driver's class or initializer is not accessible:" + ex);
        }
        catch (SQLException ex) {
            this.showErrorMessage("MySQL database access error:" + ex);
        }
        return null;
    }

    public IstiConnectionInfoPanel getConnectionInfoPanel() {
        return this.connectionInfoPanel;
    }

    public IstiDialogUtil getDialogUtil() {
        return this.dialogUtilObj;
    }

    public Connection getConnection() {
        Connection dbConnection = null;
        if (this.showAndReturnIndex() == 0) {
            dbConnection = this.createMySQLConnection(this.connectionInfoPanel.getHostname(), this.connectionInfoPanel.getPort(), this.connectionInfoPanel.getUsername(), this.connectionInfoPanel.getPassword(), this.connectionInfoPanel.getDatabase());
        }
        return dbConnection;
    }

    public void showErrorMessage(String msgStr) {
        if (this.dialogUtilObj != null) {
            this.dialogUtilObj.popupErrorMessage(msgStr);
        } else {
            System.err.println(msgStr);
        }
    }
}

