/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gis;

import com.isti.util.MeasurementUnits;
import com.isti.util.MeasurementUnitsInformation;

public class LocationDistanceInformation
implements MeasurementUnitsInformation {
    private MeasurementUnits measurementUnits = new MeasurementUnits();
    protected double distance;
    protected double azim;
    protected String name;
    private static final String[] sAzim = new String[]{"N", "NNE", "NE", "ENE", "E", "ESE", "SE", "SSE", "S", "SSW", "SW", "WSW", "W", "WNW", "NW", "NNW"};
    private static final double DEG_PER_SECTOR = 360.0 / (double)sAzim.length;

    public LocationDistanceInformation() {
        this(0.0, 0.0, "");
    }

    public LocationDistanceInformation(double distance, double azim, String name) {
        this.distance = distance;
        this.azim = azim;
        this.name = name;
    }

    public double getAzim() {
        return this.azim;
    }

    public String getAzimString() {
        int i = (int)((this.getAzim() + DEG_PER_SECTOR / 2.0) / DEG_PER_SECTOR);
        if (i >= sAzim.length) {
            i = sAzim.length - 1;
        }
        return sAzim[i];
    }

    public int getMeasurementUnits() {
        return this.measurementUnits.getMeasurementUnits();
    }

    public void setMeasurementUnits(int mu) {
        this.measurementUnits.setMeasurementUnits(mu);
    }

    public double getDistance() {
        return this.measurementUnits.getValue(this.distance);
    }

    public String getDistanceString() {
        return this.measurementUnits.getValueString(this.distance);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDistanceString() + " " + this.getAzimString() + " of " + this.getName();
    }
}

