/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.applet.Applet;
import java.util.Calendar;
import java.util.Date;
import netscape.javascript.JSObject;

public class CookieAccess {
    protected final boolean DEBUG_FLAG = false;
    protected final JSObject browserObj;
    protected final JSObject documentObj;

    public CookieAccess(Applet appletObj) {
        Object obj;
        this.browserObj = JSObject.getWindow((Applet)appletObj);
        this.documentObj = this.browserObj != null && (obj = this.browserObj.getMember("document")) instanceof JSObject ? (JSObject)obj : null;
    }

    public boolean setCookie(String nameStr, String dataStr, Date expireDateObj, boolean verifyFlag) {
        return this.setRawCookie(CookieAccess.encodeString(nameStr), CookieAccess.encodeString(dataStr), expireDateObj, verifyFlag);
    }

    public boolean setCookie(String nameStr, String dataStr, Date expireDateObj) {
        return this.setRawCookie(CookieAccess.encodeString(nameStr), CookieAccess.encodeString(dataStr), expireDateObj, false);
    }

    public String getCookie(String nameStr) {
        String str = this.getRawCookie(CookieAccess.encodeString(nameStr));
        return str != null ? CookieAccess.decodeString(str) : null;
    }

    public String removeCookie(String name) {
        return this.removeRawCookie(CookieAccess.encodeString(name));
    }

    public boolean setRawCookie(String nameStr, String dataStr, Date expireDateObj, boolean verifyFlag) {
        String cookieStr;
        if (dataStr != null && (cookieStr = (nameStr != null && nameStr.length() > 0 ? nameStr + "=" : "") + (expireDateObj != null ? dataStr + "; expires=" + expireDateObj : dataStr)).length() < 4016) {
            String readBackStr;
            try {
                this.documentObj.setMember("cookie", cookieStr);
                if (!verifyFlag) {
                    return true;
                }
                readBackStr = this.getRawCookie(nameStr);
                if (readBackStr != null && readBackStr.equals(dataStr)) {
                    return true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.browserObj.call("setCookieValue", cookieStr);
                if (!verifyFlag) {
                    return true;
                }
                readBackStr = this.getRawCookie(nameStr);
                if (readBackStr != null && readBackStr.equals(dataStr)) {
                    return true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean setRawCookie(String nameStr, String dataStr, Date expireDateObj) {
        return this.setRawCookie(nameStr, dataStr, expireDateObj, false);
    }

    public String getRawCookie(String nameStr) {
        String retStr = null;
        String allStr = this.getAllRawCookies();
        if (allStr != null) {
            if (nameStr != null && nameStr.length() > 0) {
                int allStrLen = allStr.length();
                int nameStrLen = nameStr.length();
                int p = 0;
                while ((p = allStr.indexOf(nameStr, p)) >= 0) {
                    int ePos = allStr.indexOf(59, p += nameStrLen);
                    if (ePos < 0) {
                        ePos = allStrLen;
                    }
                    if (p < ePos && allStr.charAt(p) == '=') {
                        retStr = allStr.substring(p + 1, ePos);
                    } else {
                        retStr = "";
                        if (ePos < allStrLen) {
                            p = ePos + 1;
                            continue;
                        }
                    }
                    break;
                }
            } else {
                retStr = allStr;
            }
        }
        return retStr;
    }

    public String getAllRawCookies() {
        try {
            Object obj = this.documentObj.getMember("cookie");
            if (obj instanceof String) {
                return (String)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String removeRawCookie(String name) {
        try {
            String str = this.getRawCookie(name);
            if (str != null) {
                Calendar calObj = Calendar.getInstance();
                calObj.add(2, -1);
                return this.setRawCookie(name, str, calObj.getTime()) ? str : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String encodeString(String sourceStr) {
        StringBuffer buff = new StringBuffer();
        if (sourceStr != null) {
            int len = sourceStr.length();
            for (int p = 0; p < len; ++p) {
                int ch = sourceStr.charAt(p);
                if (!Character.isLetterOrDigit((char)ch) && ch != 95 && ch != 46) {
                    int val = ch >= 0 ? ch : 127 - ch;
                    String numStr = Integer.toHexString(ch).toUpperCase();
                    buff.append("%" + (numStr.length() != 1 ? numStr : "0" + numStr));
                    continue;
                }
                buff.append((char)ch);
            }
        }
        return buff.toString();
    }

    public static String decodeString(String sourceStr) {
        StringBuffer buff = new StringBuffer();
        if (sourceStr != null) {
            int len = sourceStr.length();
            int chkLen = len - 2;
            for (int p = 0; p < len; ++p) {
                char ch = sourceStr.charAt(p);
                if (ch == '%' && p < chkLen && CookieAccess.isHexDigit(sourceStr.charAt(p + 1)) && CookieAccess.isHexDigit(sourceStr.charAt(p + 2))) {
                    try {
                        int val = Integer.parseInt(sourceStr.substring(p + 1, p + 3), 16);
                        if (val >= 0 && val <= 255) {
                            ch = val <= 127 ? (char)val : (char)(127 - val);
                            p += 2;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                buff.append(ch);
            }
        }
        return buff.toString();
    }

    public static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }
}

