/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.IstiFileChooserAccessoryPanel;
import com.isti.util.gui.IstiFixedJFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class IstiFileChooser
extends IstiFixedJFileChooser {
    public static final String APPROVE_BUTTON_TEXT = "OK";
    protected String currentSelection = null;
    protected Dimension windowSize = null;
    protected boolean appendFlag;
    protected static File defaultDirectory = null;
    protected boolean confirmOverwriteFlag = false;
    protected Component defaultParent = null;

    protected IstiFileChooser(int frameWidth, int frameHeight, boolean appendButtonFlag) {
        this.setApproveButtonText(APPROVE_BUTTON_TEXT);
        this.setApproveButtonMnemonic(APPROVE_BUTTON_TEXT.charAt(0));
        if (frameWidth > 0 && frameHeight > 0) {
            this.setPreferredSize(new Dimension(frameWidth, frameHeight));
        }
        if (appendButtonFlag) {
            this.setAccessory(new IstiFileChooserAccessoryPanel(this));
        }
    }

    protected IstiFileChooser(int frameWidth, int frameHeight) {
        this(frameWidth, frameHeight, false);
    }

    protected IstiFileChooser(boolean appendButtonFlag) {
        this(0, 0, appendButtonFlag);
    }

    protected IstiFileChooser() {
        this(0, 0, false);
    }

    public static IstiFileChooser createFileChooser(int frameWidth, int frameHeight, boolean appendButtonFlag) {
        int c;
        for (c = 0; c < 1000; ++c) {
            try {
                return new IstiFileChooser(frameWidth, frameHeight, appendButtonFlag);
            }
            catch (Exception ex) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        System.err.println("IstiFileChooser:  Unable to create 'JFileChooser' after " + c + " retries; making last attempt");
        return new IstiFileChooser(frameWidth, frameHeight, appendButtonFlag);
    }

    public static IstiFileChooser createFileChooser(int frameWidth, int frameHeight) {
        return IstiFileChooser.createFileChooser(frameWidth, frameHeight, false);
    }

    public static IstiFileChooser createFileChooser(boolean appendButtonFlag) {
        return IstiFileChooser.createFileChooser(0, 0, appendButtonFlag);
    }

    public static IstiFileChooser createFileChooser() {
        return IstiFileChooser.createFileChooser(0, 0, false);
    }

    public Component getDefaultParent() {
        return this.defaultParent;
    }

    public boolean isConfirmOverwriteEnable() {
        return this.confirmOverwriteFlag;
    }

    public void setDefaultParent(Component parent) {
        this.defaultParent = parent;
    }

    public void setConfirmOverwriteEnable(boolean confirmOverwriteFlag) {
        this.confirmOverwriteFlag = confirmOverwriteFlag;
    }

    public int showDialog(Component parent) {
        this.setApproveButtonToolTipText("Use the current selection" + (this.isMultiSelectionEnabled() ? "(s)" : ""));
        return this.showDialog(parent, APPROVE_BUTTON_TEXT);
    }

    public int showDialog(Component parent, String approveButtonText) {
        this.setSelectedFiles(this.currentSelection);
        if (this.windowSize != null) {
            this.setPreferredSize(this.windowSize);
        }
        this.appendFlag = false;
        if (approveButtonText != null && this.getDialogTitle() == null) {
            this.setDialogTitle(this.getTitleText());
        }
        int result = super.showDialog(parent, approveButtonText);
        try {
            Window windowObj;
            if (parent != null && !parent.hasFocus() && (windowObj = IstiDialogPopup.getWindowForComponent(parent)) != null && !windowObj.hasFocus()) {
                windowObj.requestFocus();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result != 0) {
            return result;
        }
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return -1;
        }
        if (!this.appendFlag) {
            this.currentSelection = null;
        }
        if (this.currentSelection == null) {
            this.currentSelection = "";
        }
        if (this.currentSelection.length() > 0) {
            File lastDir = IstiFileChooser.getLastDirectory(this.currentSelection);
            File selectionDir = IstiFileChooser.getLastDirectory(selectedFile.getAbsolutePath());
            this.currentSelection = this.currentSelection + File.pathSeparator;
            this.currentSelection = lastDir != null && selectionDir != null && lastDir.getAbsolutePath().compareTo(selectionDir.getAbsolutePath()) == 0 ? this.currentSelection + selectedFile.getName() : this.currentSelection + selectedFile.getAbsolutePath();
        } else {
            this.currentSelection = selectedFile.getAbsolutePath();
        }
        File[] files = this.getSelectedFiles();
        for (int i = 1; i < files.length; ++i) {
            this.currentSelection = this.currentSelection + File.pathSeparator;
            this.currentSelection = this.currentSelection + files[i].getName();
        }
        this.windowSize = this.getSize();
        return result;
    }

    public int showDialog() {
        return this.showDialog(this.defaultParent);
    }

    public String getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(String currentFile) {
        this.currentSelection = currentFile;
    }

    protected void setSelectedFiles(String files) {
        this.setSelectedFile(new File(""));
        if (defaultDirectory != null) {
            this.setCurrentDirectory(defaultDirectory);
        }
        if (files == null || files.trim().length() <= 0) {
            return;
        }
        File lastDir = IstiFileChooser.getLastDirectory(files);
        if (lastDir != null) {
            this.setCurrentDirectory(lastDir);
        } else {
            this.setCurrentDirectory(new File(".").getAbsoluteFile());
        }
    }

    public static File[] getFileArray(String files) {
        if (files == null || files.length() <= 0) {
            return null;
        }
        int firstIndex = files.indexOf(File.pathSeparatorChar);
        if (firstIndex < 0) {
            File[] fileArray = new File[]{new File(files)};
            return fileArray;
        }
        Vector<File> vector = new Vector<File>();
        int beginIndex = 0;
        int endIndex = firstIndex;
        while (endIndex >= 0 && beginIndex < files.length()) {
            vector.add(new File(files.substring(beginIndex, endIndex)));
            beginIndex = endIndex + 1;
            endIndex = files.indexOf(File.pathSeparatorChar, beginIndex);
        }
        vector.add(new File(files.substring(beginIndex)));
        File[] fileArray = new File[vector.size()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = (File)vector.get(i);
        }
        return fileArray;
    }

    public static File getLastDirectory(String files) {
        return IstiFileChooser.getLastDirectory(IstiFileChooser.getFileArray(files));
    }

    public static File getLastDirectory(File[] fileArray) {
        if (fileArray == null || fileArray.length <= 0) {
            return null;
        }
        for (int i = fileArray.length - 1; i >= 0; --i) {
            File file = fileArray[i];
            if (file == null || file.toString().length() <= 0 || (file = file.getParentFile()) == null || file.toString().length() <= 0) continue;
            return file;
        }
        return null;
    }

    public String getTitleText() {
        String titleText = this.getFileSelectionMode() == 1 ? "Choose Director" + (this.isMultiSelectionEnabled() ? "ies" : "y") : "Choose File" + (this.isMultiSelectionEnabled() ? "s" : "");
        return titleText;
    }

    public static File getDefaultDirectory() {
        return defaultDirectory;
    }

    public static void setDefaultDirectory(File defaultDirectory) {
        IstiFileChooser.defaultDirectory = defaultDirectory;
    }

    public void approveSelection() {
        int retVal;
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null || selectedFile.getName().length() <= 0) {
            return;
        }
        if (this.confirmOverwriteFlag && selectedFile.exists() && (retVal = JOptionPane.showConfirmDialog(this.defaultParent, "File exists: \"" + selectedFile.getName() + "\". Do you wish to overwrite it?", "Overwrite File", 1, 3)) != 0) {
            if (retVal == 2) {
                super.cancelSelection();
            }
            return;
        }
        super.approveSelection();
    }

    public void appendSelection() {
        this.appendFlag = true;
        this.approveSelection();
    }

    public void setCurrentDirectory(File dirObj) {
        if (dirObj != null) {
            try {
                dirObj = dirObj.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.setCurrentDirectory(dirObj);
    }
}

