/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.FifoHashtable;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ToolTipManager;

public class IstiMenu
extends JList
implements MouseMotionListener,
MouseListener {
    private final FifoHashtable optionNameToOptionInfo = new FifoHashtable();
    private Cursor mouseoverCursor = null;
    private static final int ACTION_VECTOR_INDEX = 0;
    private static final int TOOLTIP_INDEX = 1;
    private static Vector defaultActionListeners = new Vector();

    public IstiMenu() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void addDefaultActionListener(ActionListener listener) {
        defaultActionListeners.add(listener);
    }

    public void removeDefaultActionListener(ActionListener listener) {
        defaultActionListeners.remove(listener);
    }

    public void addMenuItem(String name, String tooltipStr, ActionListener listener) {
        Object[] optionInfo = new Object[]{new Vector(), tooltipStr != null ? tooltipStr : ""};
        if (listener != null) {
            ((Vector)optionInfo[0]).add(listener);
        }
        this.optionNameToOptionInfo.put(name, optionInfo);
        this.updateList();
    }

    public void removeMenuItem(String name) {
        if (this.optionNameToOptionInfo.containsKey(name)) {
            this.optionNameToOptionInfo.remove(name);
            this.updateList();
        }
    }

    public void addMenuItem(String name, String tooltipStr) {
        Object[] optionInfo = new Object[]{new Vector(), tooltipStr != null ? tooltipStr : ""};
        this.optionNameToOptionInfo.put(name, optionInfo);
        this.updateList();
    }

    public int getNumMenuItems() {
        return this.optionNameToOptionInfo.size();
    }

    public void addActionListenerToMenuItem(String name, ActionListener l) {
        ((Vector)((Object[])this.optionNameToOptionInfo.get(name))[0]).add(l);
    }

    public String getToolTipText(MouseEvent e) {
        String tip;
        if (this.getSelectedValue() == null) {
            this.mouseMoved(e);
            if (this.getSelectedValue() == null) {
                return "";
            }
        }
        if ((tip = (String)((Object[])this.optionNameToOptionInfo.get(this.getSelectedValue()))[1]) != null) {
            return tip;
        }
        return "";
    }

    private void updateList() {
        this.setListData(this.optionNameToOptionInfo.getKeysVector());
    }

    public void setMouseoverCursor(Cursor c) {
        this.mouseoverCursor = c;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int xPos = e.getX();
        int yPos = e.getY();
        int whichElement = this.locationToIndex(new Point(xPos, yPos));
        String whichItem = (String)this.getModel().getElementAt(whichElement);
        Vector actionVector = (Vector)((Object[])this.optionNameToOptionInfo.get(whichItem))[0];
        if (actionVector.size() > 0) {
            this.setSelectedIndex(whichElement);
        } else {
            this.clearSelection();
        }
    }

    public void mouseClicked(MouseEvent e) {
        String selection = (String)this.getSelectedValue();
        if (selection != null) {
            ActionEvent triggeredEvent = new ActionEvent(this, 1001, selection);
            if (selection != null) {
                Vector actionVector = (Vector)((Object[])this.optionNameToOptionInfo.get(selection))[0];
                Enumeration actions = actionVector.elements();
                if (!actions.hasMoreElements()) {
                    actions = defaultActionListeners.elements();
                }
                while (actions.hasMoreElements()) {
                    ActionListener thisAction = (ActionListener)actions.nextElement();
                    thisAction.actionPerformed(triggeredEvent);
                }
            }
        }
    }

    public void setSelectedIndex(int index) {
        String whichItem = (String)this.getModel().getElementAt(index);
        Vector actionVector = (Vector)((Object[])this.optionNameToOptionInfo.get(whichItem))[0];
        if (actionVector.size() > 0) {
            super.setSelectedIndex(index);
        } else {
            this.clearSelection();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.mouseoverCursor != null) {
            this.setCursor(this.mouseoverCursor);
        }
    }

    public void mouseExited(MouseEvent e) {
        this.clearSelection();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

