/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class IstiTableModel
implements TableModel {
    private final AbstractTableModel abstractTableModel;
    private final TableModel tableModel;
    private final Object columnInfoSyncObj = new Object();
    private int[] columnIndexValues = null;
    private boolean[] columnsVisible = null;
    private int visibleColumnCount = -1;

    public IstiTableModel(AbstractTableModel tableModel) {
        this.abstractTableModel = tableModel;
        this.tableModel = tableModel;
    }

    public void addTableModelListener(TableModelListener listener) {
        this.tableModel.addTableModelListener(listener);
    }

    public void fireTableStructureChanged() {
        if (this.abstractTableModel != null) {
            this.abstractTableModel.fireTableStructureChanged();
        }
    }

    public Class getColumnClass(int columnIndex) {
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        if (this.visibleColumnCount < 0) {
            this.updateColumnInfo();
        }
        return this.visibleColumnCount;
    }

    public String getColumnName(int columnIndex) {
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.getColumnName(columnIndex);
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        columnIndex = this.getActualColumnIndex(columnIndex);
        return this.tableModel.isCellEditable(rowIndex, columnIndex);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.tableModel.removeTableModelListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnVisible(int columnIndex, boolean b) {
        Object object = this.columnInfoSyncObj;
        synchronized (object) {
            if (this.columnsVisible == null) {
                this.initColumnInfo();
            }
            this.columnsVisible[columnIndex] = b;
            this.updateColumnInfo();
        }
        this.fireTableStructureChanged();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        columnIndex = this.getActualColumnIndex(columnIndex);
        this.tableModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getActualColumnIndex(int columnIndex) {
        Object object = this.columnInfoSyncObj;
        synchronized (object) {
            if (this.columnIndexValues == null) {
                return columnIndex;
            }
            return this.columnIndexValues[columnIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumnInfo() {
        Object object = this.columnInfoSyncObj;
        synchronized (object) {
            int columnCount = this.tableModel.getColumnCount();
            this.columnIndexValues = new int[columnCount];
            this.columnsVisible = new boolean[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                this.columnIndexValues[i] = i;
                this.columnsVisible[i] = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateColumnInfo() {
        Object object = this.columnInfoSyncObj;
        synchronized (object) {
            if (this.columnsVisible == null) {
                this.visibleColumnCount = this.tableModel.getColumnCount();
            } else {
                this.visibleColumnCount = 0;
                for (int i = 0; i < this.columnsVisible.length; ++i) {
                    if (!this.columnsVisible[i]) continue;
                    this.columnIndexValues[this.visibleColumnCount++] = i;
                }
            }
        }
    }
}

