/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.LaunchBrowser;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class LaunchBrowserButton
extends JButton
implements ActionListener {
    private String urlString = null;
    private final LaunchBrowser launchBrowserObj;

    public LaunchBrowserButton(String labelStr, LaunchBrowser launchBrowserObj) {
        super(labelStr);
        this.launchBrowserObj = launchBrowserObj;
        this.setLinkStr(null);
        this.setupButton();
    }

    public LaunchBrowserButton(String labelStr, ImageIcon iconObj, LaunchBrowser launchBrowserObj, String linkStr) {
        super(labelStr, iconObj);
        this.launchBrowserObj = launchBrowserObj;
        this.urlString = linkStr;
        this.setupButton();
    }

    public LaunchBrowserButton(String labelStr, LaunchBrowser launchBrowserObj, String linkStr) {
        super(labelStr);
        this.launchBrowserObj = launchBrowserObj;
        this.urlString = linkStr;
        this.setupButton();
    }

    public LaunchBrowserButton(ImageIcon iconObj, LaunchBrowser launchBrowserObj, String linkStr) {
        super(iconObj);
        this.launchBrowserObj = launchBrowserObj;
        this.urlString = linkStr;
        this.setupButton();
    }

    protected LaunchBrowser getLaunchBrowser() {
        return this.launchBrowserObj;
    }

    protected String getLinkStr() {
        return this.urlString;
    }

    public void setLinkStr(String linkStr) {
        this.urlString = linkStr;
        this.setVisible(this.urlString != null);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    private void setupButton() {
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRequestFocusEnabled(false);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setCursor(new Cursor(12));
        this.addActionListener(this);
    }

    public static LaunchBrowserButton createButton(String labelStr, ImageIcon iconObj, LaunchBrowser launchBrowserObj, String linkStr) {
        if (iconObj != null && iconObj.getImageLoadStatus() != 8) {
            return labelStr != null ? new LaunchBrowserButton(labelStr, iconObj, launchBrowserObj, linkStr) : new LaunchBrowserButton(iconObj, launchBrowserObj, linkStr);
        }
        return new LaunchBrowserButton(labelStr != null ? labelStr : "", iconObj, launchBrowserObj, linkStr);
    }

    public static LaunchBrowserButton createButton(ImageIcon iconObj, LaunchBrowser launchBrowserObj, String linkStr) {
        return LaunchBrowserButton.createButton(null, iconObj, launchBrowserObj, linkStr);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.urlString != null && this.urlString.length() > 0) {
            this.launchBrowserObj.showURL(this.urlString, "Browser");
        }
    }
}

