/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PopPanel
extends JPanel {
    public static final String okButtonText = "OK";
    private static final int MIN_CHAR_WIDTH = 30;
    private static final int MAX_CHAR_WIDTH = 100;
    private static final int EXTRA_WIDTH = 50;
    private static final int EXTRA_HT_WBUT = 110;
    private static final int EXTRA_HT_WOBUT = 75;
    private static int widthPerChar;
    private static int heightPerChar;
    private JButton popButton;

    public PopPanel(String message, String title) {
        this(message, title, 0, null, okButtonText);
    }

    public PopPanel(String message, String title, int charWidth) {
        this(message, title, charWidth, null, okButtonText);
    }

    public PopPanel(String message, String title, Cursor buttonCursor) {
        this(message, title, 0, buttonCursor, okButtonText);
    }

    public PopPanel(String message, String title, String buttonText) {
        this(message, title, 0, null, buttonText);
    }

    public PopPanel(String message, String title, int charWidth, String buttonText) {
        this(message, title, charWidth, null, buttonText);
    }

    public PopPanel(String message, String title, Cursor buttonCursor, String buttonText) {
        this(message, title, 0, buttonCursor, buttonText);
    }

    public PopPanel(String message, String title, int charWidth, Cursor buttonCursor, String buttonText) {
        this(message, title, charWidth, buttonCursor, buttonText, null);
    }

    public PopPanel(String message, String title, int charWidth, Cursor buttonCursor, String buttonText, JPanel bottomPanel) {
        int ePos;
        int msgLen = message.length();
        if (charWidth < 2) {
            charWidth = msgLen / 10;
            if (charWidth < 30) {
                charWidth = 30;
            } else if (charWidth > 100) {
                charWidth = 100;
            }
        }
        int sPos = 0;
        int numRows = 0;
        do {
            if ((ePos = message.indexOf(10, sPos)) < 0) {
                ePos = msgLen;
            }
            numRows += (ePos - sPos) / charWidth + 1;
            sPos = ePos + 1;
        } while (ePos < msgLen);
        int preferredWidth = charWidth * widthPerChar + 50;
        int preferredHeight = numRows * heightPerChar + (buttonText != null ? 110 : 75);
        if (bottomPanel != null) {
            preferredWidth = Math.max(preferredWidth, bottomPanel.getPreferredSize().width);
            preferredHeight += bottomPanel.getPreferredSize().height;
        }
        this.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        JTextArea textArea = new JTextArea(message);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBackground(this.getBackground());
        if (buttonText != null) {
            if (buttonText.length() <= 0) {
                buttonText = okButtonText;
            }
            this.popButton = new JButton(buttonText);
            if (buttonCursor != null) {
                this.popButton.setCursor(buttonCursor);
            }
            this.popButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PopPanel.this.setVisible(false);
                    PopPanel.this.stopModal();
                }
            });
        } else {
            this.popButton = null;
        }
        this.setLayout(new GridBagLayout());
        this.setBorder(PopPanel.createShadowedBevelBorder(title));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 10, 5, 10);
        JScrollPane textScrollPane = new JScrollPane(textArea, 20, 30);
        textScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)textScrollPane, constraints);
        if (this.popButton != null) {
            constraints.gridy = 1;
            constraints.weighty = 0.0;
            constraints.weightx = 0.0;
            constraints.fill = 0;
            constraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.popButton, constraints);
        }
        if (bottomPanel != null) {
            ++constraints.gridy;
            constraints.weighty = 0.0;
            constraints.weightx = 0.0;
            constraints.fill = 0;
            constraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)bottomPanel, constraints);
        }
    }

    public void waitForButton() {
        this.startModal();
    }

    synchronized void startModal() {
        if (this.isVisible() && !this.isShowing()) {
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.isVisible()) continue;
                parent.setVisible(true);
            }
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object src = event.getSource();
                    if (src instanceof Component) {
                        ((Component)src).dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        ((MenuComponent)src).dispatchEvent(event);
                        continue;
                    }
                    System.err.println("PopPanel:  Unable to dispatch event: " + event);
                }
            } else {
                while (this.isVisible()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void stopModal() {
        try {
            this.notifyAll();
        }
        catch (IllegalMonitorStateException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static Border createShadowedBevelBorder(String title) {
        CompoundBorder innerBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), title, 1, 1));
        return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 2, 2, Color.darkGray), innerBorder);
    }

    static {
        FontMetrics fMetrics;
        widthPerChar = 7;
        heightPerChar = 17;
        JTextArea txtArea = new JTextArea();
        Font textAreaFont = txtArea.getFont();
        if (textAreaFont != null && (fMetrics = ((Component)txtArea).getFontMetrics(textAreaFont)) != null) {
            int val = fMetrics.getHeight();
            if (val > 0 && val < 100) {
                heightPerChar = val;
            }
            if ((val = fMetrics.charWidth('m')) > 0 && val < 100) {
                widthPerChar = val;
            }
        }
    }
}

