/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.EvtJPanel;
import com.isti.util.gui.PopPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PopPanelHost
extends JLayeredPane {
    private final JPanel mainPanel;
    private final EvtJPanel popupHostPanel;
    private JPanel pPanel = null;
    private ComponentListener hostCompListener = null;
    private ComponentListener userCompListener = null;
    private boolean displayedFlag = false;
    private Cursor buttonCursor = null;
    private final GridBagConstraints fullConstraints;
    private final GridBagConstraints centerConstraints;
    private boolean freezeLayoutMgrFlag = false;
    private final Object panelHostSyncObj = new Object();

    public PopPanelHost() {
        this(true);
    }

    public PopPanelHost(boolean doubleBuffFlag) {
        this.setLayout(new GridBagLayout());
        this.freezeLayoutMgrFlag = true;
        this.mainPanel = new JPanel(doubleBuffFlag);
        this.setLayer(this.mainPanel, JLayeredPane.DEFAULT_LAYER);
        this.popupHostPanel = new EvtJPanel(doubleBuffFlag);
        this.setLayer(this.popupHostPanel, JLayeredPane.POPUP_LAYER);
        this.popupHostPanel.evtEnableEvents(56L);
        this.popupHostPanel.setLayout(new GridBagLayout());
        this.popupHostPanel.setOpaque(false);
        this.popupHostPanel.setRequestFocusEnabled(false);
        this.fullConstraints = new GridBagConstraints();
        this.fullConstraints.gridy = 0;
        this.fullConstraints.gridx = 0;
        this.fullConstraints.gridheight = 1;
        this.fullConstraints.gridwidth = 1;
        this.fullConstraints.weighty = 1.0;
        this.fullConstraints.weightx = 1.0;
        this.fullConstraints.fill = 1;
        this.fullConstraints.anchor = 10;
        this.add((Component)this.mainPanel, this.fullConstraints);
        this.centerConstraints = new GridBagConstraints();
        this.centerConstraints.gridy = 0;
        this.centerConstraints.gridx = 0;
        this.centerConstraints.gridheight = 1;
        this.centerConstraints.gridwidth = 1;
        this.centerConstraints.weighty = 1.0;
        this.centerConstraints.weightx = 1.0;
        this.centerConstraints.fill = 0;
        this.centerConstraints.anchor = 10;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JPanel getPopupHostPanel() {
        return this.popupHostPanel;
    }

    public void showPopupPanel(String message, String title) {
        this.showPopupPanel(message, title, 0, false, "OK", null);
    }

    public void showPopupPanel(String message, String title, int popupCharWidth) {
        this.showPopupPanel(message, title, popupCharWidth, false, "OK", null);
    }

    public void showPopupPanel(String message, String title, boolean waitFlag) {
        this.showPopupPanel(message, title, 0, waitFlag, "OK", null);
    }

    public void showPopupPanel(String message, String title, int popupCharWidth, boolean waitFlag) {
        this.showPopupPanel(message, title, popupCharWidth, waitFlag, "OK", null);
    }

    public void showPopupPanel(String message, String title, ComponentListener cListener) {
        this.showPopupPanel(message, title, 0, false, "OK", cListener);
    }

    public void showPopupPanel(String message, String title, int popupCharWidth, ComponentListener cListener) {
        this.showPopupPanel(message, title, popupCharWidth, false, "OK", cListener);
    }

    public void showPopupPanel(String message, String title, String buttonText) {
        this.showPopupPanel(message, title, 0, false, buttonText, null);
    }

    public void showPopupPanel(String message, String title, String buttonText, int popupCharWidth) {
        this.showPopupPanel(message, title, popupCharWidth, false, buttonText, null);
    }

    public void showPopupPanel(String message, String title, boolean waitFlag, String buttonText) {
        this.showPopupPanel(message, title, 0, waitFlag, buttonText, null);
    }

    public void showPopupPanel(String message, String title, int popupCharWidth, boolean waitFlag, String buttonText) {
        this.showPopupPanel(message, title, popupCharWidth, waitFlag, buttonText, null);
    }

    public void showPopupPanel(String message, String title, String buttonText, ComponentListener cListener) {
        this.showPopupPanel(message, title, 0, false, buttonText, cListener);
    }

    public void showPopupPanel(String message, String title, int popupCharWidth, String buttonText, ComponentListener cListener) {
        this.showPopupPanel(message, title, popupCharWidth, false, buttonText, cListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopupPanel(String message, String title, int popupCharWidth, boolean waitFlag, String buttonText, ComponentListener cListener) {
        Object object = this.panelHostSyncObj;
        synchronized (object) {
            PopPanel panel = popupCharWidth > 0 ? new PopPanel(message, title, popupCharWidth, this.buttonCursor, buttonText) : new PopPanel(message, title, this.buttonCursor, buttonText);
            this.showPopupPanel(panel, waitFlag, cListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopupPanel(JPanel panel) {
        Object object = this.panelHostSyncObj;
        synchronized (object) {
            this.showPopupPanel(panel, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopupPanel(final JPanel panel, final boolean waitFlag, final ComponentListener cListener) {
        Object object = this.panelHostSyncObj;
        synchronized (object) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doShowPopupPanel(panel, waitFlag, cListener);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PopPanelHost.this.doShowPopupPanel(panel, waitFlag, cListener);
                    }
                });
            }
        }
    }

    private void doShowPopupPanel(JPanel panel, boolean waitFlag, ComponentListener cListener) {
        if (!this.displayedFlag) {
            this.displayedFlag = true;
            this.pPanel = panel;
            this.userCompListener = cListener;
            this.pPanel.setVisible(true);
            Dimension pPanelDim = this.pPanel.getPreferredSize();
            Dimension hostDim = this.getSize();
            if (pPanelDim.height > hostDim.height) {
                pPanelDim.height = hostDim.height;
            }
            if (pPanelDim.width > hostDim.width) {
                pPanelDim.width = hostDim.width;
            }
            this.popupHostPanel.add((Component)this.pPanel, this.centerConstraints);
            this.add((Component)this.popupHostPanel, this.fullConstraints);
            this.popupHostPanel.setVisible(true);
            this.popupHostPanel.requestDefaultFocus();
            this.validate();
            this.hostCompListener = new ComponentAdapter(){

                public void componentHidden(ComponentEvent e) {
                    PopPanelHost.this.doRemovePopupPanel();
                }
            };
            this.pPanel.addComponentListener(this.hostCompListener);
            if (this.userCompListener != null) {
                this.pPanel.addComponentListener(this.userCompListener);
            }
            if (waitFlag && this.pPanel instanceof PopPanel) {
                ((PopPanel)this.pPanel).waitForButton();
            }
        }
    }

    private void doRemovePopupPanel() {
        if (this.pPanel != null) {
            if (this.hostCompListener != null) {
                this.pPanel.removeComponentListener(this.hostCompListener);
                this.hostCompListener = null;
            }
            if (this.userCompListener != null) {
                this.pPanel.removeComponentListener(this.userCompListener);
                this.userCompListener = null;
            }
            this.pPanel.setVisible(false);
            this.popupHostPanel.setVisible(false);
            this.popupHostPanel.remove(this.pPanel);
            this.pPanel = null;
        }
        this.remove(this.popupHostPanel);
        this.validate();
        this.displayedFlag = false;
    }

    public void removePopupPanel() {
        this.removePopupPanel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePopupPanel(boolean removeNowFlag) {
        Object object = this.panelHostSyncObj;
        synchronized (object) {
            if (removeNowFlag) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.doRemovePopupPanel();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PopPanelHost.this.doRemovePopupPanel();
                        }
                    });
                }
            } else if (SwingUtilities.isEventDispatchThread()) {
                if (this.pPanel != null) {
                    this.pPanel.setVisible(false);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (PopPanelHost.this.pPanel != null) {
                            PopPanelHost.this.pPanel.setVisible(false);
                        }
                    }
                });
            }
        }
    }

    public void setButtonCursor(Cursor buttonCursor) {
        this.buttonCursor = buttonCursor;
    }

    public Cursor getButtonCursor() {
        return this.buttonCursor;
    }

    public boolean isPopupShowing() {
        return this.pPanel != null;
    }

    public void setLayout(LayoutManager mgr) {
        if (this.freezeLayoutMgrFlag) {
            throw new RuntimeException("Cannot change layout on 'PopPanelHost' object; use 'getMainPanel()' object instead");
        }
        super.setLayout(mgr);
    }
}

