/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.ImageIconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class SplashWindow
extends JWindow {
    public static final int DEF_INC_WIDTH = 100;
    public static final int DEF_INC_HEIGHT = 25;
    public static final String DEF_TEXT_STR = "Program loading...";
    protected static Dimension screenSizeDimObj = null;

    public SplashWindow(Component compObj, int incWidth, int incHeight) {
        this.createComponentWindow(compObj, incWidth, incHeight);
    }

    public SplashWindow(Component compObj) {
        this.createComponentWindow(compObj, 100, 25);
    }

    public SplashWindow(String textStr, Icon iconObj, int horizontalAlignment, int incWidth, int incHeight) {
        this.createLabelWindow(textStr, iconObj, horizontalAlignment, incWidth, incHeight);
    }

    public SplashWindow(String textStr, Icon iconObj, int horizontalAlignment) {
        this.createLabelWindow(textStr, iconObj, horizontalAlignment, 100, 25);
    }

    public SplashWindow(String textStr, Icon iconObj) {
        this.createLabelWindow(textStr, iconObj, 0, 100, 25);
    }

    public SplashWindow(String textStr, String iconURLStr, int horizontalAlignment, int incWidth, int incHeight, boolean textBackupFlag) {
        this.createLabelWindow(textStr, iconURLStr, horizontalAlignment, incWidth, incHeight, textBackupFlag);
    }

    public SplashWindow(String textStr, String iconURLStr, int horizontalAlignment, boolean textBackupFlag) {
        this.createLabelWindow(textStr, iconURLStr, horizontalAlignment, 100, 25, textBackupFlag);
    }

    public SplashWindow(String textStr, String iconURLStr, boolean textBackupFlag) {
        this.createLabelWindow(textStr, iconURLStr, 0, 100, 25, textBackupFlag);
    }

    public SplashWindow(String textStr, String iconURLStr, int horizontalAlignment, int incWidth, int incHeight) {
        this.createLabelWindow(textStr, iconURLStr, horizontalAlignment, incWidth, incHeight, false);
    }

    public SplashWindow(String textStr, String iconURLStr, int horizontalAlignment) {
        this.createLabelWindow(textStr, iconURLStr, horizontalAlignment, 100, 25, false);
    }

    public SplashWindow(String textStr, String iconURLStr) {
        this.createLabelWindow(textStr, iconURLStr, 0, 100, 25, false);
    }

    public SplashWindow(String textStr, int horizontalAlignment, int incWidth, int incHeight) {
        this.createLabelWindow(textStr, null, horizontalAlignment, incWidth, incHeight);
    }

    public SplashWindow(String textStr, int horizontalAlignment) {
        this.createLabelWindow(textStr, null, horizontalAlignment, 100, 25);
    }

    public SplashWindow(String textStr) {
        this.createLabelWindow(textStr, null, 0, 100, 25);
    }

    public SplashWindow() {
        this.createLabelWindow(DEF_TEXT_STR, null, 0, 100, 25);
    }

    protected void createComponentWindow(Component compObj, int incWidth, int incHeight) {
        Container paneObj = this.getContentPane();
        paneObj.setLayout(new BorderLayout());
        paneObj.add(compObj, "Center");
        this.pack();
        Dimension dimObj = this.getPreferredSize();
        int windowWidth = dimObj.width + incWidth;
        int windowHeight = dimObj.height + incHeight;
        Dimension ssDimObj = SplashWindow.getDisplayScreenSize();
        int windowXPos = ssDimObj.width / 2 - windowWidth / 2;
        int windowYPos = ssDimObj.height / 2 - windowHeight / 2;
        ((Component)this).setBounds(windowXPos, windowYPos, windowWidth, windowHeight);
    }

    protected void createLabelWindow(String textStr, Icon iconObj, int horizontalAlignment, int incWidth, int incHeight) {
        JLabel labelObj = new JLabel(textStr, iconObj, horizontalAlignment);
        Font fontObj = labelObj.getFont();
        labelObj.setFont(fontObj.deriveFont(fontObj.getSize2D() + 6.0f));
        labelObj.setForeground(Color.blue);
        labelObj.setBackground(Color.white);
        labelObj.setOpaque(true);
        labelObj.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
        this.createComponentWindow(labelObj, incWidth, incHeight);
    }

    protected void createLabelWindow(String textStr, String iconURLStr, int horizontalAlignment, int incWidth, int incHeight, boolean textBackupFlag) {
        ImageIcon iconObj = ImageIconLoader.load(iconURLStr);
        if (textBackupFlag && iconObj != null) {
            textStr = null;
        }
        this.createLabelWindow(textStr, iconObj, horizontalAlignment, incWidth, incHeight);
    }

    public void pack(int incWidth, int incHeight, boolean centerFlag) {
        int windowHeight;
        int windowWidth;
        Dimension dimObj;
        this.pack();
        if (incWidth != 0 || incHeight != 0) {
            dimObj = this.getPreferredSize();
            windowWidth = dimObj.width + incWidth;
            windowHeight = dimObj.height + incHeight;
            if (!centerFlag) {
                ((Component)this).setSize(windowWidth, windowHeight);
                return;
            }
        } else {
            if (!centerFlag) {
                return;
            }
            dimObj = this.getPreferredSize();
            windowWidth = dimObj.width;
            windowHeight = dimObj.height;
        }
        Dimension ssDimObj = SplashWindow.getDisplayScreenSize();
        int windowXPos = ssDimObj.width / 2 - windowWidth / 2;
        int windowYPos = ssDimObj.height / 2 - windowHeight / 2;
        ((Component)this).setBounds(windowXPos, windowYPos, windowWidth, windowHeight);
    }

    public void pack(boolean centerFlag) {
        this.pack(0, 0, centerFlag);
    }

    public void showWindow() {
        super.setVisible(true);
    }

    public void close() {
        this.dispose();
    }

    public static Dimension getDisplayScreenSize() {
        if (screenSizeDimObj == null) {
            try {
                screenSizeDimObj = Toolkit.getDefaultToolkit().getScreenSize();
            }
            catch (Exception ex) {
                System.err.println("Error retrieving screen size:  " + ex);
                screenSizeDimObj = new Dimension(800, 600);
            }
        }
        return screenSizeDimObj;
    }
}

