/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.UtilFns;
import com.isti.util.gui.textvalidator.AllowedCharactersConstants;
import com.isti.util.gui.textvalidator.TextValidator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ValidatedDocument
extends PlainDocument
implements AllowedCharactersConstants {
    public final String specialChars;
    public final boolean numericFlag;
    public final int maxNumChars;
    public final boolean allowFlag;
    private TextValidator textValidator = null;

    public ValidatedDocument(String specialChars, boolean numericFlag, int maxNumChars, boolean allowFlag) {
        this.specialChars = specialChars;
        this.numericFlag = numericFlag;
        this.maxNumChars = maxNumChars;
        this.allowFlag = allowFlag;
    }

    public void insertString(int insOffs, String insStr, AttributeSet aSet) throws BadLocationException {
        int p;
        int insLen;
        String dataStr = null;
        if (insStr == null || (insLen = insStr.length()) <= 0) {
            return;
        }
        String cmpString = insStr;
        char decimalSeparator = UtilFns.getDecimalSeparator();
        if (this.numericFlag && decimalSeparator != '.') {
            insStr = insStr.replace('.', decimalSeparator);
            cmpString = cmpString.replace(decimalSeparator, '.');
        }
        int dataLen = this.getLength();
        if (this.maxNumChars > 0 && dataLen + insLen > this.maxNumChars) {
            return;
        }
        if (this.specialChars != null && this.specialChars.length() > 0) {
            int q;
            char ch;
            int offs;
            if (insOffs >= 0 && insOffs <= dataLen) {
                offs = insOffs;
                dataStr = (this.getText(0, offs) + insStr + this.getText(offs, dataLen - offs)).toLowerCase();
                dataLen = dataStr.length();
            } else {
                dataStr = insStr;
                offs = dataLen;
            }
            p = 0;
            while (this.specialChars.indexOf(ch = cmpString.charAt(p)) < 0 != this.allowFlag && (!this.numericFlag || (ch != '-' && ch != '+' || offs + p <= 0 || dataStr.substring(offs + p - 1, offs + p).equalsIgnoreCase("e") && (offs + p + 1 >= dataLen || "0123456789".indexOf(dataStr.charAt(offs + p + 1)) >= 0)) && (ch != decimalSeparator || (q = dataStr.indexOf(decimalSeparator)) < 0 || q >= dataLen || dataStr.indexOf(decimalSeparator, q + 1) < 0) && (ch != 'e' && ch != 'E' || offs + p != 0 && "0123456789".indexOf(dataStr.charAt(offs + p - 1)) >= 0) && ((q = dataStr.indexOf(101)) < 0 || q >= dataLen || dataStr.indexOf(101, q + 1) < 0)) && ++p < insLen) {
            }
        } else {
            p = insLen;
        }
        if (p > 0) {
            if (this.textValidator != null && !this.textValidator.isValid(dataStr)) {
                return;
            }
            super.insertString(insOffs, insStr.substring(0, p), aSet);
        }
    }

    public TextValidator getTextValidator() {
        return this.textValidator;
    }

    public void setTextValidator(TextValidator tv) {
        this.textValidator = tv;
    }
}

