/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.gui.HandJButton;
import com.isti.util.gui.IstiFileChooser;
import com.isti.util.propertyeditor.AbstractPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class FilePropertyEditor
extends AbstractPropertyEditor {
    private static final String SIZING_STRING = "CISN_Display_banner.gif";
    protected static final int MAX_BUTTON_TEXT = "CISN_Display_banner.gif".length();
    protected String fileText = "";
    protected final IstiFileChooser fileChooser = IstiFileChooser.createFileChooser();
    protected static String curWorkingDirDotStr = ".";
    protected static final File currentWorkingDirFileObj = new File(curWorkingDirDotStr).getAbsoluteFile().getParentFile();
    protected static final String currentWorkingDirPathString = currentWorkingDirFileObj.getPath() + File.separator;
    protected static final int curWorkingDirPathStringLen = currentWorkingDirPathString.length();
    protected final JPanel panelObj = new JPanel(new BorderLayout());
    protected final JButton buttonObj = new HandJButton();

    public FilePropertyEditor() {
        this(false);
    }

    public FilePropertyEditor(boolean directoryFlag) {
        if (directoryFlag) {
            this.fileChooser.setFileSelectionMode(1);
        }
        this.buttonObj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilePropertyEditor.this.fileChooser.setCurrentSelection(FilePropertyEditor.this.getAsText());
                if (FilePropertyEditor.this.fileChooser.showDialog() == 0) {
                    FilePropertyEditor.this.setAsText(FilePropertyEditor.this.fileChooser.getCurrentSelection());
                }
            }
        });
        this.buttonObj.setMargin(new Insets(0, 0, 0, 0));
        FontMetrics metObj = ((Component)this.buttonObj).getFontMetrics(this.buttonObj.getFont());
        this.buttonObj.setPreferredSize(new Dimension(metObj.stringWidth(SIZING_STRING) + 15, metObj.getHeight() + 4));
        this.fileChooser.setDefaultParent(this.getCustomEditor());
        this.panelObj.add((Component)this.buttonObj, "Center");
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this.panelObj;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setValue(Object someObj) {
        String buttonText;
        if (someObj == null) {
            return;
        }
        this.fileText = someObj.toString();
        File fTextFileObj = new File(this.fileText);
        if (currentWorkingDirFileObj.equals(fTextFileObj)) {
            this.fileText = curWorkingDirDotStr;
        }
        if (this.fileText.startsWith(currentWorkingDirPathString)) {
            this.fileText = this.fileText.substring(curWorkingDirPathStringLen);
            fTextFileObj = new File(this.fileText);
        }
        if (this.fileText.length() > 0) {
            try {
                fTextFileObj = fTextFileObj.getCanonicalFile();
            }
            catch (IOException ex) {
                fTextFileObj = fTextFileObj.getAbsoluteFile();
            }
            buttonText = fTextFileObj.getName();
            if (buttonText.endsWith(File.pathSeparator)) {
                buttonText = fTextFileObj.getPath();
            }
        } else {
            buttonText = this.fileChooser.getTitleText();
        }
        if (buttonText.length() > MAX_BUTTON_TEXT) {
            buttonText = buttonText.substring(0, MAX_BUTTON_TEXT - 3) + "...";
        }
        this.buttonObj.setText(buttonText);
    }

    public void setAsText(String text) {
        if (text == null) {
            return;
        }
        this.setValue(text);
    }

    public Object getValue() {
        return this.getAsText();
    }

    public String getAsText() {
        return this.fileText;
    }

    public void addActionListener(ActionListener l) {
        this.fileChooser.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.fileChooser.removeActionListener(l);
    }
}

