/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextComponent;
import java.beans.PropertyEditor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

public class PropertyComponentPanel
extends JPanel {
    private final JPanel itemsPanel = new JPanel(new GridBagLayout());
    private final GridBagConstraints constraints = new GridBagConstraints();
    private Component firstPropEditorCompObj = null;
    private Component firstFocusComponentObj = null;

    public PropertyComponentPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.itemsPanel, "North");
        this.constraints.anchor = 17;
        this.constraints.gridy = 0;
        this.constraints.gridx = 0;
        this.constraints.insets = new Insets(2, 1, 1, 1);
    }

    public void addProperty(Component propertyLabel, PropertyEditor propertyEditor) {
        if (propertyEditor.supportsCustomEditor()) {
            this.addProperty(propertyLabel, propertyEditor.getCustomEditor());
        }
    }

    public void addProperty(Component propertyLabel, Component propertyEditor) {
        this.constraints.gridx = 0;
        if (!(propertyEditor instanceof JToggleButton) || !(propertyLabel instanceof JLabel)) {
            if (propertyLabel != null) {
                this.constraints.gridwidth = 1;
                this.itemsPanel.add(propertyLabel, this.constraints);
                ++this.constraints.gridx;
                this.itemsPanel.add(propertyEditor, this.constraints);
            } else {
                this.constraints.gridwidth = 2;
                this.itemsPanel.add(propertyEditor, this.constraints);
            }
        } else {
            String promptStr = ((JLabel)propertyLabel).getText();
            if (promptStr != null) {
                int len = (promptStr = promptStr.trim()).length();
                if (len > 0 && promptStr.charAt(len - 1) == ':') {
                    promptStr = promptStr.substring(0, len - 1);
                }
                ((JToggleButton)propertyEditor).setText(promptStr);
            }
            this.constraints.gridwidth = 2;
            this.itemsPanel.add(propertyEditor, this.constraints);
        }
        ++this.constraints.gridy;
        if (this.firstPropEditorCompObj == null) {
            this.firstPropEditorCompObj = propertyEditor;
        }
    }

    public Component getFirstPropEditorCompObj() {
        return this.firstPropEditorCompObj;
    }

    public Component getFirstFocusComponentObj() {
        try {
            if (this.firstFocusComponentObj == null && this.firstPropEditorCompObj != null) {
                this.firstFocusComponentObj = PropertyComponentPanel.getFirstFocusChildCompObj(this.firstPropEditorCompObj);
            }
            return this.firstFocusComponentObj;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Component getFirstFocusChildCompObj(Component compObj) {
        Component[] compArr;
        if (compObj instanceof JTextComponent || compObj instanceof AbstractButton || compObj instanceof TextComponent || compObj instanceof Button) {
            return compObj;
        }
        if (compObj instanceof JComponent) {
            compArr = ((JComponent)compObj).getComponents();
        } else if (compObj instanceof Container) {
            compArr = ((Container)compObj).getComponents();
        } else {
            return compObj;
        }
        if (compArr == null || compArr.length <= 0 || compArr[0] == null) {
            return compObj;
        }
        return PropertyComponentPanel.getFirstFocusChildCompObj(compArr[0]);
    }
}

