/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.snwagent;

import com.isti.util.LogFile;
import com.isti.util.TypeCastException;
import com.isti.util.snwagent.ByteArrayFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.util.HashMap;

public class ByteHandler {
    DataOutputStream dos = null;
    DataInputStream dis = null;
    DataInputStream dis_forreader = null;
    ByteArrayOutputStream baos = null;
    ByteArrayInputStream bais = null;
    OutputStreamWriter osw = null;
    InputStreamReader isr = null;
    ByteArrayFormat byteformat;
    HashMap objects = new HashMap();
    static /* synthetic */ Class class$com$isti$util$snwagent$ByteHandler$pad;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    public ByteHandler() {
        this.byteformat = new ByteArrayFormat();
    }

    public boolean parseByteAr(byte[] ba) throws Exception {
        this.bais = new ByteArrayInputStream(ba);
        this.dis = new DataInputStream(this.bais);
        ByteArrayInputStream tbais = new ByteArrayInputStream(ba);
        this.dis_forreader = new DataInputStream(tbais);
        this.isr = new InputStreamReader((InputStream)this.dis_forreader, "US-ASCII");
        for (int i = 0; i < this.byteformat.size(); ++i) {
            if (this.parseValue(i)) continue;
            return false;
        }
        return true;
    }

    public boolean parseValue(int position) throws Exception {
        int size;
        Class ctype;
        char type = this.byteformat.charAt(position);
        Constable ob = null;
        if ((class$com$isti$util$snwagent$ByteHandler$pad == null ? (class$com$isti$util$snwagent$ByteHandler$pad = ByteHandler.class$("com.isti.util.snwagent.ByteHandler$pad")) : class$com$isti$util$snwagent$ByteHandler$pad).equals(ctype = this.getClassType(type))) {
            return true;
        }
        char[] ca = null;
        byte[] ba = null;
        if (ctype.getName().equals((class$java$lang$Integer == null ? (class$java$lang$Integer = ByteHandler.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
            ob = new Integer(this.dis.readInt());
            this.objects.put(new Integer(position), ob);
            ca = new char[4];
            this.isr.read(ca, 0, 4);
        }
        if (ctype.getName().equals((class$java$lang$Short == null ? (class$java$lang$Short = ByteHandler.class$("java.lang.Short")) : class$java$lang$Short).getName())) {
            ob = new Short(this.dis.readShort());
            this.objects.put(new Integer(position), ob);
            size = 2;
            ca = new char[size];
            this.isr.read(ca, 0, size);
        }
        if (ctype.getName().equals((class$java$lang$Long == null ? (class$java$lang$Long = ByteHandler.class$("java.lang.Long")) : class$java$lang$Long).getName())) {
            ob = new Long(this.dis.readLong());
            this.objects.put(new Integer(position), ob);
            size = 8;
            ca = new char[size];
            this.isr.read(ca, 0, size);
        }
        if (ctype.getName().equals((class$java$lang$Byte == null ? (class$java$lang$Byte = ByteHandler.class$("java.lang.Byte")) : class$java$lang$Byte).getName())) {
            ob = new Byte(this.dis.readByte());
            this.objects.put(new Integer(position), ob);
            size = 1;
            ca = new char[size];
            this.isr.read(ca, 0, size);
        }
        if (ctype.getName().equals((class$java$lang$Double == null ? (class$java$lang$Double = ByteHandler.class$("java.lang.Double")) : class$java$lang$Double).getName())) {
            ob = new Double(this.dis.readDouble());
            this.objects.put(new Integer(position), ob);
            size = 8;
            ca = new char[size];
            this.isr.read(ca, 0, size);
        }
        if (ctype.getName().equals((class$java$lang$Float == null ? (class$java$lang$Float = ByteHandler.class$("java.lang.Float")) : class$java$lang$Float).getName())) {
            ob = new Float(this.dis.readFloat());
            this.objects.put(new Integer(position), ob);
            size = 4;
            ca = new char[size];
            this.isr.read(ca, 0, size);
        }
        if (ctype.getName().equals((class$java$lang$Character == null ? (class$java$lang$Character = ByteHandler.class$("java.lang.Character")) : class$java$lang$Character).getName())) {
            int count = 1;
            ca = new char[count];
            this.isr.read(ca, 0, count);
            this.dis.readByte();
            Character ch = new Character(ca[0]);
            this.objects.put(new Integer(position), ch);
        }
        if (ctype.getName().equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ByteHandler.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
            ob = new Boolean(this.dis.readBoolean());
            this.objects.put(new Integer(position), ob);
            size = 1;
            ca = new char[size];
            this.isr.read(ca, 0, size);
        }
        if (ctype.getName().equals((class$java$lang$String == null ? (class$java$lang$String = ByteHandler.class$("java.lang.String")) : class$java$lang$String).getName())) {
            int len = this.byteformat.getStringLen(position);
            ob = new Byte(this.dis.readByte());
            int size2 = 1;
            ca = new char[size2];
            this.isr.read(ca, 0, size2);
            int count = ((Byte)ob).intValue();
            ca = new char[count];
            ba = new byte[count];
            this.isr.read(ca, 0, count);
            this.dis.read(ba, 0, count);
            String s = new String(ca);
            this.objects.put(new Integer(position), s);
            int needToRead = len - count;
            if (needToRead > 0) {
                ca = new char[needToRead];
                ba = new byte[needToRead];
                this.isr.read(ca, 0, needToRead);
                this.dis.read(ba, 0, needToRead);
            }
        }
        return true;
    }

    public boolean setValue(int position, Object tmp) throws TypeCastException {
        char type;
        Class ctype;
        if ((class$com$isti$util$snwagent$ByteHandler$pad == null ? (class$com$isti$util$snwagent$ByteHandler$pad = ByteHandler.class$("com.isti.util.snwagent.ByteHandler$pad")) : class$com$isti$util$snwagent$ByteHandler$pad).equals(ctype = this.getClassType(type = this.byteformat.charAt(position)))) {
            if (tmp != null) {
                LogFile.getGlobalLogObj().warning("trying to set the value of the padded field.");
            }
            return true;
        }
        if (ctype.isInstance(tmp)) {
            int slen;
            int len;
            if (type == 's' && (len = this.byteformat.getStringLen(position)) < (slen = ((String)tmp).length())) {
                String ts = ((String)tmp).substring(0, len);
                tmp = ts;
            }
        } else {
            throw new TypeCastException("object is not of type " + ctype.getName() + ". object was " + tmp);
        }
        this.objects.put(new Integer(position), tmp);
        return true;
    }

    public boolean initVector() throws TypeCastException {
        for (int i = 0; i < this.byteformat.size(); ++i) {
            this.initValue(i);
        }
        return true;
    }

    public boolean initValue(int position) throws TypeCastException {
        Object obj;
        char type = this.byteformat.charAt(position);
        Class ctype = this.getClassType(type);
        if (!ctype.isInstance(obj = this.getNewClassObject(type))) {
            throw new TypeCastException("object is not of type " + ctype.getName() + ". object was " + obj);
        }
        this.objects.put(new Integer(position), obj);
        return true;
    }

    public Object getValue(int position) throws TypeCastException {
        Object obj = this.objects.get(new Integer(position));
        Class ctype = this.getClassType(this.byteformat.charAt(position));
        if (ctype.isInstance(obj)) {
            return obj;
        }
        throw new TypeCastException("object in position " + position + " is not of type " + ctype.getName());
    }

    private char getType(int position) {
        char type = this.byteformat.charAt(position);
        return type;
    }

    private Class getClass(int position) throws TypeCastException {
        return this.getClassType(this.byteformat.charAt(position));
    }

    public Class getClassType(char type) throws TypeCastException {
        switch (type) {
            case 'i': {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ByteHandler.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 'c': {
                return class$java$lang$Character == null ? (class$java$lang$Character = ByteHandler.class$("java.lang.Character")) : class$java$lang$Character;
            }
            case 'b': {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = ByteHandler.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            case 'h': {
                return class$java$lang$Short == null ? (class$java$lang$Short = ByteHandler.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 'l': {
                return class$java$lang$Long == null ? (class$java$lang$Long = ByteHandler.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 'f': {
                return class$java$lang$Float == null ? (class$java$lang$Float = ByteHandler.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 'd': {
                return class$java$lang$Double == null ? (class$java$lang$Double = ByteHandler.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case 's': {
                return class$java$lang$String == null ? (class$java$lang$String = ByteHandler.class$("java.lang.String")) : class$java$lang$String;
            }
            case 'x': {
                return new pad().getClass();
            }
        }
        throw new TypeCastException("type " + type + " is not a valid classtype");
    }

    private Object getNewClassObject(char type) throws TypeCastException {
        switch (type) {
            case 'i': {
                return new Integer(0);
            }
            case 'c': {
                return new Character(' ');
            }
            case 'b': {
                byte b = 0;
                return new Byte(b);
            }
            case 'h': {
                short s = 0;
                return new Short(s);
            }
            case 'l': {
                return new Long(0L);
            }
            case 'f': {
                return new Float(0.0);
            }
            case 'd': {
                return new Double(0.0);
            }
            case 's': {
                return new String("");
            }
            case 'x': {
                return new pad().getClass();
            }
        }
        throw new TypeCastException("type " + type + " is not a valid classtype");
    }

    public int getSize() throws TypeCastException {
        int total = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            total += this.getObjectSize(i);
        }
        return total;
    }

    private int getObjectSize(int position) throws TypeCastException {
        Object obj = this.objects.get(new Integer(position));
        char type = this.getType(position);
        if (type == 's') {
            String s = (String)obj;
            return s.length();
        }
        return this.getObjectSize(type);
    }

    private int getObjectSize(char type) throws TypeCastException {
        switch (type) {
            case 'i': {
                return 4;
            }
            case 'c': {
                return 1;
            }
            case 'b': {
                return 1;
            }
            case 'h': {
                return 2;
            }
            case 'l': {
                return 8;
            }
            case 'f': {
                return 4;
            }
            case 'd': {
                return 8;
            }
            case 'x': {
                return 1;
            }
        }
        throw new TypeCastException("type " + type + " size is unknown.");
    }

    public void setFormat(String sformat) throws TypeCastException {
        this.byteformat = new ByteArrayFormat(sformat);
        this.initVector();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object ob = null;
        try {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (i != 0) {
                    sb.append("|");
                }
                if ((ob = this.getValue(i)) instanceof Integer) {
                    sb.append((Integer)ob);
                }
                if (ob instanceof Long) {
                    sb.append((Long)ob);
                }
                if (ob instanceof Short) {
                    sb.append(((Short)ob).shortValue());
                }
                if (ob instanceof Double) {
                    sb.append((Double)ob);
                }
                if (ob instanceof Float) {
                    sb.append(((Float)ob).floatValue());
                }
                if (ob instanceof Character) {
                    sb.append(((Character)ob).charValue());
                }
                if (ob instanceof Boolean) {
                    sb.append((Boolean)ob);
                }
                if (ob instanceof Byte) {
                    sb.append(((Byte)ob).byteValue());
                }
                if (!(ob instanceof String)) continue;
                sb.append("(");
                sb.append(((String)ob).length());
                sb.append(")");
                sb.append((String)ob);
            }
        }
        catch (TypeCastException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public byte[] toByteArray() throws Exception {
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        try {
            this.osw = new OutputStreamWriter((OutputStream)this.dos, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        StringBuffer sb = new StringBuffer();
        Object ts = null;
        Object tb = null;
        Object ob = null;
        try {
            for (int i = 0; i < this.objects.size(); ++i) {
                ob = this.getValue(i);
                if (ob instanceof Integer) {
                    this.dos.writeInt((Integer)ob);
                    this.dos.flush();
                }
                if (ob instanceof Long) {
                    this.dos.writeLong((Long)ob);
                    this.dos.flush();
                }
                if (ob instanceof Short) {
                    this.dos.writeShort(((Short)ob).shortValue());
                    this.dos.flush();
                }
                if (ob instanceof Double) {
                    this.dos.writeDouble((Double)ob);
                    this.dos.flush();
                }
                if (ob instanceof Float) {
                    this.dos.writeFloat(((Float)ob).floatValue());
                    this.dos.flush();
                }
                if (ob instanceof Character) {
                    Character ch = (Character)ob;
                    String s = new String(ch.toString());
                    this.osw.write(s, 0, 1);
                    this.osw.flush();
                }
                if (ob instanceof Boolean) {
                    this.dos.writeBoolean((Boolean)ob);
                    this.dos.flush();
                }
                if (ob instanceof Byte) {
                    this.dos.writeByte(((Byte)ob).byteValue());
                    this.dos.flush();
                }
                if (!(ob instanceof String)) continue;
                this.dos.writeByte(((String)ob).length());
                this.dos.flush();
                this.osw.write((String)ob, 0, ((String)ob).length());
                this.osw.flush();
            }
        }
        catch (TypeCastException ex) {
            // empty catch block
        }
        byte[] nb = this.baos.toByteArray();
        return nb;
    }

    public static short byte2short(byte[] bytes) throws TypeCastException {
        short sumInt = 0;
        int shiftCount = bytes.length - 1;
        if (bytes.length > 2) {
            throw new TypeCastException("byte array has " + bytes.length + " bytes, too long for a short");
        }
        int i = bytes.length - 1;
        while (i >= 0) {
            int tmpInt = bytes[i] & 0xFF;
            sumInt = (short)(sumInt + (tmpInt <<= 8 * shiftCount));
            --i;
            --shiftCount;
        }
        return sumInt;
    }

    public int byte2int(byte[] bytes) {
        int sumInt = 0;
        int shiftCount = bytes.length - 1;
        int i = 0;
        while (i < bytes.length) {
            int tmpInt = bytes[i] & 0xFF;
            sumInt += (tmpInt <<= 8 * shiftCount);
            ++i;
            --shiftCount;
        }
        return sumInt;
    }

    public long byte2long(byte[] bytes) {
        long sumInt = 0L;
        int shiftCount = bytes.length - 1;
        int i = 0;
        while (i < bytes.length) {
            long tmpInt = bytes[i] & 0xFF;
            sumInt += (tmpInt <<= 8 * shiftCount);
            ++i;
            --shiftCount;
        }
        return sumInt;
    }

    public byte[] short2byte(short myshort) {
        short tint = myshort;
        return this.int2byte(tint);
    }

    public byte[] int2byte(int myint) {
        String rep = Integer.toBinaryString(myint);
        byte[] tmpByte = null;
        BigInteger bi = new BigInteger(Integer.toString(myint));
        tmpByte = bi.toByteArray();
        if (tmpByte.length != 4) {
            byte[] newByte = new byte[4];
            for (int i = 0; i < 4; ++i) {
                newByte[i] = 0;
            }
            int diff = newByte.length - tmpByte.length;
            for (int i = 0; i < tmpByte.length; ++i) {
                byte tb = tmpByte[i];
                int pos = diff + i;
                newByte[pos] = tb;
            }
            tmpByte = newByte;
        }
        return tmpByte;
    }

    public byte[] long2byte(long mylong) {
        String rep = Long.toBinaryString(mylong);
        byte[] tmpByte = null;
        BigInteger bi = new BigInteger(Long.toString(mylong));
        tmpByte = bi.toByteArray();
        if (tmpByte.length != 8) {
            byte[] newByte = new byte[8];
            for (int i = 0; i < 8; ++i) {
                newByte[i] = 0;
            }
            int diff = newByte.length - tmpByte.length;
            for (int i = 0; i < tmpByte.length; ++i) {
                byte tb = tmpByte[i];
                int pos = diff + i;
                newByte[pos] = tb;
            }
            tmpByte = newByte;
        }
        return tmpByte;
    }

    public byte[] double2byte(double mylong) {
        long l = Double.doubleToLongBits(mylong);
        byte[] b = new byte[8];
        int shift = 56;
        int i = 0;
        while (i < 8) {
            b[i] = (byte)(l >>> shift);
            ++i;
            shift -= 8;
        }
        try {
            this.dos.writeDouble(mylong);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] nb = this.baos.toByteArray();
        this.printBytes(b);
        this.printBytes(nb);
        return nb;
    }

    private void printBytes(byte[] ar) {
        for (int i = 0; i < ar.length; ++i) {
            System.out.println(ar[i] & 0xFF);
        }
    }

    public void printBytes() throws Exception {
        try {
            byte[] ar = this.toByteArray();
            for (int i = 0; i < ar.length; ++i) {
                System.out.println(ar[i] & 0xFF);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void compareBytes(ByteHandler bh2) throws Exception {
        int i;
        byte[] ar = null;
        byte[] ar2 = null;
        try {
            ar = this.toByteArray();
            ar2 = bh2.toByteArray();
        }
        catch (IOException ex) {
            return;
        }
        byte[] maxar = null;
        int s1 = ar.length;
        int s2 = ar2.length;
        int min = 0;
        int max = 0;
        if (s1 > s2) {
            min = s2;
            max = s1;
            maxar = ar;
        } else {
            min = s1;
            max = s2;
            maxar = ar2;
        }
        System.out.println("\n\n\n");
        for (i = 0; i < min; ++i) {
            System.out.print(ar[i] & 0xFF);
            System.out.println("\t" + (ar2[i] & 0xFF));
        }
        while (i < max) {
            if (max == s1) {
                System.out.println(maxar[i] & 0xFF);
            } else {
                System.out.println("\t" + (maxar[i] & 0xFF));
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        byte[] sidba = new byte[]{3, 0};
        short stest = 0;
        try {
            stest = ByteHandler.byte2short(sidba);
        }
        catch (TypeCastException ex3) {
            ex3.printStackTrace();
        }
        System.out.println("stest is " + stest);
        ByteHandler bh = new ByteHandler();
        try {
            bh.setFormat("s100s5hccs3cs10bilfds110hcbilfd");
            int count = 0;
            byte b = 8;
            bh.setValue(count++, new String("ABC"));
            bh.setValue(count++, new String("abc"));
            bh.setValue(count++, new Short(260));
            bh.setValue(count++, new Character('D'));
            bh.setValue(count++, new Character('d'));
            bh.setValue(count++, new String("EFG"));
            bh.setValue(count++, new Character('H'));
            bh.setValue(count++, new String("IJ"));
            bh.setValue(count++, new Byte(b));
            bh.setValue(count++, new Integer(8000));
            bh.setValue(count++, new Long(9999999L));
            bh.setValue(count++, new Float(1.1));
            bh.setValue(count++, new Double(11111.11111));
            b = 9;
            bh.setValue(count++, new String("ABC, again."));
            bh.setValue(count++, new Short(261));
            bh.setValue(count++, new Character('B'));
            bh.setValue(count++, new Byte(b));
            bh.setValue(count++, new Integer(8001));
            bh.setValue(count++, new Long(10000000L));
            bh.setValue(count++, new Float(1.2));
            bh.setValue(count++, new Double(11111.11112));
            System.out.println("bh size is " + bh.getSize());
            byte[] ba = null;
            try {
                ba = bh.toByteArray();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            ByteHandler bhn = new ByteHandler();
            bhn.setFormat("s100s5hccs3cs10bilfds110hcbilfd");
            try {
                bhn.parseByteAr(ba);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
            System.out.println("bhn size is " + bhn.getSize());
            System.out.println(bh.toString());
            System.out.println(bhn.toString() + "\n\n\n");
            bh.compareBytes(bhn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class pad {
        pad() {
        }
    }
}

