/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.updatechecker;

import com.isti.util.IstiVersion;
import com.isti.util.updatechecker.UpdateInformation;
import java.util.Arrays;
import java.util.Vector;

public class BasicUpdateCheckerServer {
    private final String adminEmailAddress;
    private final UpdateInformation[] updates;
    private final Vector updateList = new Vector();
    private final UpdateInformation[] emptyUpdates = new UpdateInformation[0];
    private final int numUpdates;

    public BasicUpdateCheckerServer(String adminEmailAddress, UpdateInformation[] updates) {
        this.numUpdates = updates.length;
        Arrays.sort(updates);
        this.adminEmailAddress = adminEmailAddress;
        this.updates = updates;
        this.updateList.addAll(Arrays.asList(updates));
    }

    public String getAdminEmailAddress() {
        return this.adminEmailAddress;
    }

    public UpdateInformation[] getUpdates(IstiVersion version) {
        int fromIndex = 0;
        if (this.numUpdates > 0) {
            UpdateInformation update;
            while ((update = (UpdateInformation)this.updateList.get(fromIndex)).getVersion().compareTo(version) <= 0 && ++fromIndex < this.numUpdates) {
            }
        }
        return this.updateList.subList(fromIndex, this.numUpdates).toArray(this.emptyUpdates);
    }

    public boolean isUpdateAvailable(IstiVersion version) {
        return this.getUpdates(version).length > 0;
    }

    public String toString() {
        return "admin Email address=" + this.adminEmailAddress + ", " + BasicUpdateCheckerServer.toString(this.updates);
    }

    public static String toString(UpdateInformation[] updates) {
        String str;
        int numUpdates = updates.length;
        if (numUpdates <= 0) {
            str = "No update available.";
        } else {
            int i = 0;
            str = "update[" + i + "]=" + updates[i];
            ++i;
            while (i < numUpdates) {
                str = str + ", update[" + i + "]=" + updates[i];
                ++i;
            }
        }
        return str;
    }
}

