/*
 * Decompiled with CFR 0.152.
 */
package cj.math.nnls;

import cj.math.nnls.Nnls;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class NNLSWrapper {
    private double[] A;
    private double[] A_passed;
    private double[] b_temp;
    private Nnls nnls;
    private int nrows;
    private int ncols;
    private int ndata;
    private double[] w;
    private double[] zz;
    doubleW rnorm;
    int[] index;
    intW mode;
    double[] b;
    double[] x;

    public NNLSWrapper() {
    }

    public NNLSWrapper(double[] dArray, int n, int n2) {
        if (dArray != null && dArray.length != 0) {
            this.A = new double[dArray.length];
            this.A_passed = new double[dArray.length];
            int n3 = 0;
            while (n3 < dArray.length) {
                this.A[n3] = dArray[n3];
                ++n3;
            }
            this.nrows = n;
            this.ncols = n2;
            this.initialize();
        }
    }

    public void update(double[] dArray) {
        if (dArray.length != this.A.length) {
            System.out.println("Must be same number of elements or specify the rows and columns");
            System.exit(-1);
        }
        System.arraycopy(dArray, 0, this.A, 0, dArray.length);
    }

    public void update(double[] dArray, int n, int n2) {
        if (dArray != null && dArray.length != 0) {
            this.A = new double[dArray.length];
            this.A_passed = new double[dArray.length];
            System.arraycopy(dArray, 0, this.A, 0, dArray.length);
            this.nrows = n;
            this.ncols = n2;
            this.initialize();
        }
    }

    private void initialize() {
        this.ndata = this.nrows;
        try {
            this.w = new double[this.ncols];
            this.zz = new double[this.nrows];
            this.index = new int[this.ncols];
            this.b = new double[this.nrows];
            this.b_temp = new double[this.nrows];
            this.x = new double[this.ncols];
        }
        catch (Exception exception) {
            System.err.println("Caught IOException: " + exception.getMessage());
            System.exit(0);
        }
        this.mode = new intW(0);
        this.rnorm = new doubleW(0.0);
    }

    public void solve(double[] dArray, double[] dArray2) {
        if (dArray.length != this.nrows) {
            System.out.println("NNLS: compute: b is the wrong length");
        }
        if (dArray2.length != this.ncols) {
            System.out.println("NNLS: compute: x is the wrong length");
        }
        System.arraycopy(this.A, 0, this.A_passed, 0, this.A.length);
        System.arraycopy(dArray, 0, this.b_temp, 0, dArray.length);
        Nnls.nnls(this.A_passed, 0, this.nrows, this.nrows, this.ncols, this.b_temp, 0, dArray2, 0, this.rnorm, this.w, 0, this.zz, 0, this.index, 0, this.mode);
    }
}

