/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d;

import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.log4j.xml.DOMConfigurator;
import org.scec.geo3d.gui.MainWindow;
import org.scec.geo3d.tools.Prefs;

public class Geo3d {
    private static MainWindow mainWindow;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Geo3d.startApplication();
            }
        });
    }

    public static MainWindow getMainWindow() {
        return mainWindow;
    }

    protected static void startApplication() {
        Prefs.init();
        Geo3d.initializeUI();
        DOMConfigurator.configure((String)"conf/log_config.xml");
        mainWindow = new MainWindow();
        mainWindow.setVisible(true);
        mainWindow.createNewViewer();
    }

    private static void initializeUI() {
        try {
            if (System.getProperty("os.name").equals("Linux")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("sun.awt.noerasebackground", "true");
        if (Prefs.getOS() == 1) {
            FontUIResource f_11 = new FontUIResource("LucidaGrande", 0, 11);
            FontUIResource f_12 = new FontUIResource("LucidaGrande", 0, 12);
            UIManager.put("Button.font", f_11);
            UIManager.put("TabbedPane.font", f_11);
            UIManager.put("Panel.font", f_11);
            UIManager.put("TextField.font", f_11);
            UIManager.put("TextArea.font", f_11);
            UIManager.put("FormattedTextField.font", f_11);
            UIManager.put("Label.font", f_11);
            UIManager.put("TitledBorder.font", f_12);
            UIManager.put("Tree.font", f_11);
            UIManager.put("ComboBox.font", f_11);
        } else {
            UIManager.put("TextArea.font", UIManager.get("TextField.font"));
        }
        UIManager.put("FormattedTextField.selectionForeground", UIManager.get("TextField.selectionForeground"));
        UIManager.put("FormattedTextField.selectionBackground", UIManager.get("TextField.selectionBackground"));
    }
}

