/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import junit.framework.TestCase;
import org.scec.geo3d.Geo3d;
import org.scec.geo3d.gui.SetViewGUI;
import org.scec.geo3d.tools.plugin.Geo3dInfo;

public class Geo3dTest
extends TestCase {
    public static final String JPEG = "jpeg";

    public void testNavigateWithMouseMovement() throws Exception {
        Robot bot = new Robot();
        MyThread t = new MyThread();
        t.start();
        bot.delay(3000);
        Geo3dTest.assertEquals((int)1, (int)Geo3d.getMainWindow().getContentPane().getComponentCount());
        JDesktopPane pane = (JDesktopPane)Geo3d.getMainWindow().getContentPane().getComponent(0);
        Geo3dTest.assertEquals((String)"javax.swing.JDesktopPane", (String)pane.getClass().getName());
        Point p = pane.getLocation();
        Geo3dTest.assertEquals((int)0, (int)p.x);
        Geo3dTest.assertEquals((int)0, (int)p.y);
        Geo3dTest.assertEquals((int)0, (int)pane.getComponentCount());
        SetViewGUI gui = Geo3d.getMainWindow().newViewDialog;
        Geo3dTest.assertEquals((String)"org.scec.geo3d.gui.SetViewGUI", (String)gui.getClass().getName());
        p = gui.getLocation();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension desktopSize = Geo3dInfo.getDesktop().getSize();
        Point desktopLoc = Geo3dInfo.getDesktop().getLocationOnScreen();
        System.out.println(screenSize.height);
        System.out.println(desktopSize.height);
        System.out.println(desktopLoc);
        System.out.println(gui.getHeight());
        Geo3dTest.assertEquals((String)"SetViewGui x", (int)((screenSize.width - gui.getWidth()) / 2), (int)p.x);
        Geo3dTest.assertEquals((String)"SetViewGui y", (int)((screenSize.height - gui.getHeight()) / 2 - 15), (int)p.y);
        Rectangle guiRect = gui.getBounds();
        System.out.println("guiRect: " + guiRect + " gui Point: " + p);
        Point pOnScreen = gui.getLocationOnScreen();
        bot.delay(1000);
        bot.mouseMove(pOnScreen.x, pOnScreen.y);
        bot.delay(1000);
        bot.mouseMove(pOnScreen.x + guiRect.width, pOnScreen.y);
        bot.delay(1000);
        bot.mouseMove(pOnScreen.x, pOnScreen.y + guiRect.height);
        bot.delay(1000);
        bot.mouseMove(pOnScreen.x + guiRect.width, pOnScreen.y + guiRect.height);
        bot.delay(1000);
        Geo3dTest.assertEquals((int)1, (int)gui.getComponentCount());
        Geo3dTest.assertEquals((String)"Welcome to SCEC-VDO", (String)gui.getTitle());
        Geo3dTest.assertEquals((String)"javax.swing.JPanel", (String)gui.getContentPane().getComponent(0).getClass().getName());
        JPanel panel = (JPanel)gui.getContentPane().getComponent(0);
        Geo3dTest.assertEquals((String)"SetViewGui panel x", (int)0, (int)panel.getX());
        Geo3dTest.assertEquals((String)"SetViewGui panel y", (int)0, (int)panel.getY());
        Geo3dTest.assertEquals((int)4, (int)panel.getComponentCount());
        panel = (JPanel)panel.getComponent(3);
        AbstractButton button = null;
        int i = 0;
        while (i < panel.getComponentCount()) {
            try {
                button = (JButton)panel.getComponent(i);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        Geo3dTest.assertEquals((String)"OK", (String)button.getText());
        Rectangle buttonRect = button.getBounds();
        System.out.println("ButtonRectangle " + buttonRect);
        System.out.println("button location " + button.getX() + " " + button.getY() + " " + button.getHeight() + " " + button.getWidth());
        System.out.println("button center " + this.getComponentCenter(button));
        Point okcenter = this.getComponentCenter(button);
        System.out.println("translated " + okcenter);
        bot.mouseMove(okcenter.x, okcenter.y);
        bot.delay(1000);
        bot.mousePress(16);
        bot.delay(500);
        bot.mouseRelease(16);
        bot.mouseMove(100, 100);
        bot.delay(10000);
        Geo3d.getMainWindow().dispose();
    }

    public void testMainWindowWithSetViewGui() throws Exception {
        MyThread t = new MyThread();
        t.start();
        Thread.sleep(2000L);
        Geo3dTest.assertEquals((int)1, (int)Geo3d.getMainWindow().getContentPane().getComponentCount());
        JDesktopPane pane = (JDesktopPane)Geo3d.getMainWindow().getContentPane().getComponent(0);
        Geo3dTest.assertEquals((String)"javax.swing.JDesktopPane", (String)pane.getClass().getName());
        Point p = pane.getLocation();
        Geo3dTest.assertEquals((int)0, (int)p.x);
        Geo3dTest.assertEquals((int)0, (int)p.y);
        Geo3dTest.assertEquals((int)0, (int)pane.getComponentCount());
        SetViewGUI gui = Geo3d.getMainWindow().newViewDialog;
        Geo3dTest.assertEquals((String)"org.scec.geo3d.gui.SetViewGUI", (String)gui.getClass().getName());
        p = gui.getLocation();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Geo3dTest.assertEquals((String)"SetViewGui x", (int)((screenSize.width - gui.getWidth()) / 2), (int)p.x);
        Geo3dTest.assertEquals((String)"SetViewGui y", (int)((screenSize.height - gui.getHeight()) / 2 - 15), (int)p.y);
        Rectangle guiRect = new Rectangle(gui.getLocationOnScreen(), new Dimension(gui.getWidth(), gui.getHeight()));
        this.compareScreenRectangle(guiRect, "SetViewGUI");
    }

    private void compareScreenRectangle(Rectangle rectangle, String filename) throws Exception {
        Robot bot = new Robot();
        bot.waitForIdle();
        BufferedImage saveScreen = bot.createScreenCapture(rectangle);
        File file = new File(String.valueOf(filename) + "." + JPEG);
        String s = file.getAbsolutePath();
        RenderedOp op = JAI.create((String)"filestore", (RenderedImage)saveScreen, (Object)s, (Object)JPEG);
        File control = new File(String.valueOf(filename) + "_control." + JPEG);
        this.compareFiles(control, file);
    }

    public void compareFiles(File control, File test) throws Exception {
        FileInputStream iscontrol = new FileInputStream(control);
        FileInputStream istest = new FileInputStream(test);
        int count = 0;
        int t = 0;
        int c = 0;
        while (c != -1) {
            c = iscontrol.read();
            t = istest.read();
            Geo3dTest.assertEquals((String)("byte mismatch at: " + count), (int)c, (int)t);
            ++count;
        }
        Geo3dTest.assertEquals((String)("Should have EOF for test file at offset " + count + " but found " + t), (int)-1, (int)t);
    }

    public Point getComponentCenter(JComponent component) {
        return new Point((int)(component.getLocationOnScreen().getX() + (double)(component.getWidth() / 2)), (int)(component.getLocationOnScreen().getY() + (double)(component.getHeight() / 2)));
    }

    private class MyThread
    extends Thread {
        MyThread() {
        }

        public void run() {
            Geo3d.startApplication();
        }
    }
}

