/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui;

import com.sun.j3d.utils.universe.MultiTransformGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.HashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;
import org.scec.geo3d.gui.AboutDialog;
import org.scec.geo3d.gui.KeysDialog;
import org.scec.geo3d.gui.NavInternalFrame;
import org.scec.geo3d.gui.PreferencesGUI;
import org.scec.geo3d.gui.SetViewGUI;
import org.scec.geo3d.gui.UISwitchListener;
import org.scec.geo3d.gui.ViewRange;
import org.scec.geo3d.gui.viewer.GlobeView;
import org.scec.geo3d.tools.exceptions.StateVectorException;
import org.scec.geo3d.tools.filters.Geo3DFilter;
import org.scec.geo3d.tools.plugin.Geo3dInfo;
import org.scec.geo3d.tools.stateVector.StateVector;

public class MainWindow
extends JFrame
implements ActionListener {
    private static final int TILE_VERTICALLY = 0;
    private static final int TILE_HORIZONTALLY = 1;
    private static final int CASCADE = 2;
    private static final long serialVersionUID = 1L;
    public static final Integer DOCLAYER = new Integer(5);
    public static final Integer TOOLLAYER = new Integer(6);
    public static final Integer HELPLAYER = new Integer(7);
    private static final int offset = 30;
    private static Logger log;
    private JDesktopPane m_Desktop = new JDesktopPane();
    private JMenuBar m_MainMenu = new JMenuBar();
    private JInternalFrame toolPalette;
    private JCheckBoxMenuItem showToolPalatteMenuitem;
    private JMenu m_FileMenu = new JMenu("File");
    private JMenu m_DisplayMenu = new JMenu("Display");
    private JMenu m_HelpMenu = new JMenu("Help");
    private JMenuItem m_FileOpen = new JMenuItem("Open...");
    private JMenuItem m_AppExit = new JMenuItem("Quit");
    private JMenu m_NewViewMenu = new JMenu("New View");
    private JMenuItem m_NewDefaultView = new JMenuItem("New View");
    private JMenuItem m_CloneCurrentView = new JMenuItem("Clone Current View");
    private JMenu m_ArrangeMenu = new JMenu("Arrange");
    private JMenuItem m_ArrangeTileH = new JMenuItem("Tile Horizontally");
    private JMenuItem m_ArrangeTileV = new JMenuItem("Tile Vertically");
    private JMenuItem m_ArrangeCascade = new JMenuItem("Cascade");
    private JMenuItem m_CloseAll = new JMenuItem("Close All");
    private JMenuItem m_Preferences = new JMenuItem("Preferences...");
    private JMenuItem m_GeoWallView = new JMenuItem("GeoWall");
    private JMenuItem m_LooknFeel = new JMenu("Change GUI");
    private JMenuItem m_Mosaic = new JMenuItem("Motif GUI");
    private JMenuItem m_Metal = new JMenuItem("Metal GUI");
    private JMenuItem m_Native = new JMenuItem("Native GUI");
    private JMenuItem m_GTK = new JMenuItem("GTK GUI");
    private JMenuItem m_Navigator = new JMenuItem("Navigator");
    private JMenuItem m_HelpAbout = new JMenuItem("About...");
    private JMenuItem m_HelpKeys = new JMenuItem("Keyboard / Navigation Reference");
    public SetViewGUI newViewDialog;
    public AboutDialog aboutDialog;
    public KeysDialog keysDialog;
    private static NavInternalFrame navArrow;
    private static boolean isNavMade;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.gui.MainWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        isNavMade = false;
    }

    public MainWindow() {
        super("Geo3D {ALPHA} - Southern California Earthquake Center");
        this.buildContent();
        this.buildMenus();
        this.setUpWindowListener();
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setUpDesktop(screenSize);
        this.updateGeo3dInfo();
    }

    private void setUpDesktop(Dimension screenSize) {
        this.setBounds(100, 100, screenSize.width - 200, screenSize.height - 200);
        log.debug((Object)("setUpDesktop Bounds:  " + this.getBounds().toString()));
        this.setExtendedState(6);
        Color background = new Color(0.1f, 0.0f, 0.6f);
        this.m_Desktop.setBackground(background);
        this.m_Desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
    }

    private void updateGeo3dInfo() {
        Geo3dInfo.setMainWindow(this);
        Geo3dInfo.setDesktop(this.m_Desktop);
    }

    private void setUpWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainWindow.this.quit();
            }
        });
    }

    protected void buildMenus() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.buildFileMenu();
        this.buildDisplayMenu();
        this.buildHelpMenu();
        this.assignKeyboardShortcuts();
        this.m_MainMenu.add(this.m_FileMenu);
        this.m_MainMenu.add(this.m_DisplayMenu);
        this.m_MainMenu.add(this.m_HelpMenu);
        this.m_MainMenu.setOpaque(true);
        this.setJMenuBar(this.m_MainMenu);
    }

    private void assignKeyboardShortcuts() {
        this.m_NewDefaultView.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.m_CloneCurrentView.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.m_FileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.m_CloseAll.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.m_AppExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.m_Preferences.setAccelerator(KeyStroke.getKeyStroke(80, 2));
    }

    protected void buildFileMenu() {
        this.m_NewDefaultView.addActionListener(this);
        this.m_CloneCurrentView.addActionListener(this);
        this.m_FileOpen.addActionListener(this);
        this.m_CloseAll.addActionListener(this);
        this.m_AppExit.addActionListener(this);
        this.m_NewViewMenu.add(this.m_NewDefaultView);
        this.m_NewViewMenu.add(this.m_CloneCurrentView);
        this.m_FileMenu.add(this.m_NewViewMenu);
        this.m_FileMenu.add(this.m_FileOpen);
        this.m_FileMenu.addSeparator();
        this.m_FileMenu.add(this.m_CloseAll);
        this.m_FileMenu.addSeparator();
        this.m_FileMenu.add(this.m_AppExit);
    }

    protected void buildDisplayMenu() {
        this.m_ArrangeTileH.addActionListener(this);
        this.m_ArrangeTileV.addActionListener(this);
        this.m_ArrangeCascade.addActionListener(this);
        this.m_GeoWallView.addActionListener(this);
        this.m_Preferences.addActionListener(this);
        this.m_LooknFeel.addActionListener(this);
        this.m_Mosaic.addActionListener(this);
        this.m_Metal.addActionListener(this);
        this.m_Native.addActionListener(this);
        this.m_GTK.addActionListener(this);
        this.m_Navigator.addActionListener(this);
        this.m_LooknFeel.add(this.m_Mosaic);
        this.m_LooknFeel.add(this.m_Metal);
        this.m_LooknFeel.add(this.m_Native);
        this.m_LooknFeel.add(this.m_GTK);
        this.m_ArrangeMenu.add(this.m_ArrangeTileH);
        this.m_ArrangeMenu.add(this.m_ArrangeTileV);
        this.m_ArrangeMenu.add(this.m_ArrangeCascade);
        this.m_DisplayMenu.add(this.m_ArrangeMenu);
        this.m_DisplayMenu.add(this.m_LooknFeel);
        this.m_DisplayMenu.add(this.m_Navigator);
        this.m_DisplayMenu.addSeparator();
        this.m_DisplayMenu.add(this.m_GeoWallView);
        this.m_DisplayMenu.addSeparator();
        this.m_DisplayMenu.add(this.m_Preferences);
    }

    protected void buildHelpMenu() {
        this.m_HelpAbout.addActionListener(this);
        this.m_HelpKeys.addActionListener(this);
        this.m_HelpMenu.add(this.m_HelpAbout);
        this.m_HelpMenu.add(this.m_HelpKeys);
    }

    protected void buildContent() {
        this.m_Desktop = new JDesktopPane();
        this.m_Desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
        this.getContentPane().add(this.m_Desktop);
        log.debug((Object)("buildContent m_Desktop bounds:  " + this.m_Desktop.getBounds().toString()));
    }

    public void quit() {
        System.exit(0);
    }

    public void createNewViewer() {
        ViewRange newViewRange;
        if (this.newViewDialog == null) {
            this.newViewDialog = new SetViewGUI((Component)this);
        }
        if ((newViewRange = this.newViewDialog.getNewViewRange()) == null) {
            return;
        }
        GlobeView newGlobe = new GlobeView(newViewRange);
        Geo3dInfo.getDesktop().add((Component)newGlobe, DOCLAYER);
        this.setupNewViewer(newGlobe);
    }

    public void createNewViewer(ViewRange range, MultiTransformGroup mtg, Color3f backgroundColor, Color3f gridColor, HashMap plugins) {
        GlobeView newGlobe = new GlobeView(range);
        newGlobe.changeBackgroundColorForStateRestoration(backgroundColor);
        newGlobe.changeGridColorForStateRestoration(gridColor);
        newGlobe.setupRestore(mtg, plugins);
        this.m_Desktop.add((Component)newGlobe, DOCLAYER);
        this.setupNewViewer(newGlobe);
    }

    private void setupNewViewer(GlobeView newGlobe) {
        try {
            newGlobe.setVisible(true);
            newGlobe.setSelected(true);
        }
        catch (PropertyVetoException e2) {
            System.err.println("Exception: " + e2.getMessage());
            e2.printStackTrace(System.err);
        }
    }

    public void showAboutBox() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog((Component)this);
        }
        this.aboutDialog.showDialog();
    }

    public void showKeysBox() {
        if (this.keysDialog == null) {
            this.keysDialog = new KeysDialog((Component)this);
        }
        this.keysDialog.showDialog();
    }

    public void actionPerformed(ActionEvent e) {
        Object eventSource = e.getSource();
        if (eventSource == this.m_AppExit) {
            this.quit();
        } else if (eventSource == this.m_CloseAll) {
            this.closeAllOpenViewers();
        } else if (eventSource == this.m_Native) {
            this.setNativeLookAndFeel();
        } else if (eventSource == this.m_Metal) {
            this.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (eventSource == this.m_GTK) {
            this.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        } else if (eventSource == this.m_Mosaic) {
            this.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        } else if (eventSource == this.m_ArrangeCascade) {
            this.cascadeViewers();
        } else if (eventSource == this.m_ArrangeTileH) {
            this.tileHorizontally();
        } else if (eventSource == this.m_ArrangeTileV) {
            this.tileVertically();
        } else if (eventSource == this.m_CloneCurrentView) {
            this.cloneCurrentView();
        } else if (eventSource != this.m_GeoWallView) {
            if (eventSource == this.m_FileOpen) {
                this.openFile();
            } else if (eventSource == this.m_NewDefaultView) {
                this.createNewViewer();
            } else if (eventSource == this.m_HelpAbout) {
                this.showAboutBox();
            } else if (eventSource == this.m_HelpKeys) {
                this.showKeysBox();
            } else if (eventSource == this.m_Preferences) {
                PreferencesGUI pg = new PreferencesGUI();
            } else if (eventSource == this.m_Navigator) {
                if (!isNavMade) {
                    this.setUpNavigator();
                    isNavMade = true;
                } else if (isNavMade) {
                    navArrow.dispose();
                    isNavMade = false;
                }
            }
        }
    }

    private void setUpNavigator() {
        navArrow = new NavInternalFrame();
        Geo3dInfo.getDesktop().add((Component)navArrow, DOCLAYER);
        try {
            navArrow.setVisible(true);
            navArrow.setSelected(false);
        }
        catch (PropertyVetoException e2) {
            System.err.println("Exception: " + e2.getMessage());
            e2.printStackTrace(System.err);
        }
        navArrow.startAnim();
    }

    private void openFile() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.addChoosableFileFilter(new Geo3DFilter());
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.loadState(file);
        }
    }

    private void loadState(File f) {
        StateVector sv = new StateVector();
        try {
            sv.loadState(this, f);
        }
        catch (StateVectorException e) {
            log.error((Object)("StateVectorException when opening state vector: " + e.getMessage()));
        }
    }

    private void cloneCurrentView() {
        if (Geo3dInfo.getActiveViewer() != null) {
            File file = new File("temp.xml");
            Geo3dInfo.getActiveViewer().saveState(file);
            this.loadState(file);
            file.delete();
        } else {
            this.createNewViewer();
        }
    }

    protected void tileVertically() {
        this.tile(0);
    }

    protected void tileHorizontally() {
        this.tile(1);
    }

    protected void cascadeViewers() {
        this.tile(2);
    }

    private void tile(int orientation) {
        JInternalFrame[] allFrames = this.m_Desktop.getAllFrames();
        int length = allFrames.length;
        Dimension desk = new Dimension(this.m_Desktop.getSize());
        Dimension newSize = new Dimension(desk.width / length, desk.height / length);
        int i = 0;
        while (i < length) {
            try {
                if (orientation == 1) {
                    allFrames[i].reshape(newSize.width * i, 0, newSize.width, newSize.height * length);
                } else if (orientation == 0) {
                    allFrames[i].reshape(0, newSize.height * i, newSize.width * length, newSize.height);
                } else if (orientation == 2) {
                    allFrames[i].setLocation(30 * i, 30 * i);
                    allFrames[i].setSelected(true);
                    allFrames[i].setSize(542, 612);
                }
                allFrames[i].show();
                allFrames[i].toFront();
                allFrames[i].moveToFront();
                allFrames[i].requestFocus();
                Geo3dInfo.getActiveViewer().removeCanvases();
                Geo3dInfo.getActiveViewer().restoreCanvases();
            }
            catch (PropertyVetoException e2) {
                log.error((Object)("PropertyVetoException in MainWindow.tile(): " + e2.getMessage()));
            }
            ++i;
        }
    }

    private void setLookAndFeel(String lAndF) {
        try {
            UIManager.setLookAndFeel(lAndF);
        }
        catch (Exception eb) {
            JOptionPane.showMessageDialog(null, String.valueOf(lAndF) + " could not be loaded.", "Error", 0);
        }
    }

    private void closeAllOpenViewers() {
        JInternalFrame[] allFrames = this.m_Desktop.getAllFrames();
        int i = 0;
        while (i < allFrames.length) {
            allFrames[i].doDefaultCloseAction();
            allFrames[i] = null;
            ++i;
        }
        System.gc();
    }

    private void setNativeLookAndFeel() {
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception ea) {
            JOptionPane.showMessageDialog(null, "Native Look & Feel could not be loaded.", "Error", 0);
        }
    }

    public static NavInternalFrame getNavArrow() {
        return navArrow;
    }

    public static boolean isNavMade() {
        return isNavMade;
    }
}

