/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui;

import java.awt.Dimension;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import junit.framework.TestCase;
import org.apache.log4j.xml.DOMConfigurator;
import org.scec.geo3d.gui.MainWindow;
import org.scec.geo3d.gui.viewer.GlobeView;
import org.scec.geo3d.tools.plugin.Geo3dInfo;
import org.scec.geo3d.tools.plugin.TestingPluginHandler;

public class MainWindowTest
extends TestCase {
    private MainWindow window;

    public void setUp() {
        DOMConfigurator.configure((String)"conf/log_config.xml");
        this.window = new MainWindow();
        int i = 0;
        while (i < 4) {
            Geo3dInfo.getDesktop().add(new GlobeView(TestingPluginHandler.getInstance()));
            ++i;
        }
    }

    public void testTileVertically() throws Exception {
        this.window.tileVertically();
        Dimension desktopArea = Geo3dInfo.getDesktop().getSize();
        double height = desktopArea.getHeight() / 4.0;
        double width = desktopArea.getWidth();
        JInternalFrame[] viewers = Geo3dInfo.getDesktop().getAllFrames();
        MainWindowTest.assertEquals((int)viewers.length, (int)4);
        int i = 0;
        while (i < 4) {
            MainWindowTest.assertEquals((int)viewers[i].getLocation().x, (int)0);
            MainWindowTest.assertEquals((double)viewers[i].getLocation().y, (double)((double)i * height), (double)0.1);
            MainWindowTest.assertEquals((double)viewers[i].getSize().height, (double)height, (double)0.1);
            MainWindowTest.assertEquals((double)viewers[i].getSize().width, (double)width, (double)0.1);
            MainWindowTest.assertTrue((boolean)viewers[i].isVisible());
            ++i;
        }
    }

    public void testKeyboardShortcuts() throws Exception {
        JMenuBar menu = this.window.getJMenuBar();
        JMenu fileMenu = (JMenu)menu.getComponent(0);
        JMenu newMenu = (JMenu)fileMenu.getMenuComponent(0);
        JMenuItem newView = (JMenuItem)newMenu.getMenuComponent(0);
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(78, 2).getKeyCode(), (int)newView.getAccelerator().getKeyCode());
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(78, 2).getModifiers(), (int)newView.getAccelerator().getModifiers());
        JMenuItem cloneView = (JMenuItem)newMenu.getMenuComponent(1);
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(67, 2).getKeyCode(), (int)cloneView.getAccelerator().getKeyCode());
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(67, 2).getModifiers(), (int)cloneView.getAccelerator().getModifiers());
        JMenuItem open = (JMenuItem)fileMenu.getMenuComponent(1);
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(79, 2).getKeyCode(), (int)open.getAccelerator().getKeyCode());
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(79, 2).getModifiers(), (int)open.getAccelerator().getModifiers());
        JMenuItem closeAll = (JMenuItem)fileMenu.getMenuComponent(3);
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(88, 2).getKeyCode(), (int)closeAll.getAccelerator().getKeyCode());
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(88, 2).getModifiers(), (int)closeAll.getAccelerator().getModifiers());
        JMenuItem close = (JMenuItem)fileMenu.getMenuComponent(5);
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(81, 2).getKeyCode(), (int)close.getAccelerator().getKeyCode());
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(81, 2).getModifiers(), (int)close.getAccelerator().getModifiers());
        JMenu displayMenu = (JMenu)menu.getComponent(1);
        JMenuItem preferences = (JMenuItem)displayMenu.getMenuComponent(6);
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(80, 2).getKeyCode(), (int)preferences.getAccelerator().getKeyCode());
        MainWindowTest.assertEquals((int)KeyStroke.getKeyStroke(80, 2).getModifiers(), (int)preferences.getAccelerator().getModifiers());
    }
}

