/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.geom.Line2D;
import javax.media.j3d.Transform3D;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.vecmath.Matrix3f;
import org.scec.geo3d.tools.plugin.Geo3dInfo;

public class NavInternalFrame
extends JInternalFrame
implements InternalFrameListener {
    private JPanel canvasPanel;
    private JPanel keyPanel;
    private JPanel all;
    private MyCanvas canvas;
    private static final long serialVersionUID = 1L;

    NavInternalFrame() {
        super("Navigator", false, true, false, true);
        this.init();
    }

    private void init() {
        this.addInternalFrameListener(this);
        this.setDefaultCloseOperation(2);
        this.canvasPanel = new JPanel();
        this.canvasPanel.setLayout(new BorderLayout());
        this.canvasPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.canvasPanel.add(this.setUpCanvas());
        this.keyPanel = new JPanel();
        this.keyPanel.setLayout(new GridLayout(4, 1));
        this.setUpKey();
        this.all = new JPanel();
        this.all.setLayout(new BorderLayout());
        this.all.add((Component)this.canvasPanel, "Center");
        this.all.add((Component)this.keyPanel, "East");
        this.setContentPane(this.all);
        this.setSize(100, 100);
        this.pack();
        this.setLocation(Geo3dInfo.getActiveViewer().getX() + Geo3dInfo.getActiveViewer().getWidth(), Geo3dInfo.getActiveViewer().getY());
    }

    private void setUpKey() {
        JLabel dirKey = new JLabel("Directional Color Key");
        dirKey.setForeground(Color.BLACK);
        this.keyPanel.add(dirKey);
        JLabel north = new JLabel("North = blue");
        north.setForeground(Color.BLUE);
        this.keyPanel.add(north);
        JLabel center = new JLabel("Center of Earth = Yellow");
        center.setForeground(Color.YELLOW);
        this.keyPanel.add(center);
        JLabel east = new JLabel("East = red");
        east.setForeground(Color.RED);
        this.keyPanel.add(east);
    }

    private MyCanvas setUpCanvas() {
        this.canvas = new MyCanvas();
        return this.canvas;
    }

    public void startAnim() {
        this.canvas.run();
    }

    public void internalFrameOpened(InternalFrameEvent arg0) {
    }

    public void internalFrameClosing(InternalFrameEvent arg0) {
    }

    public void internalFrameClosed(InternalFrameEvent arg0) {
    }

    public void internalFrameIconified(InternalFrameEvent arg0) {
    }

    public void internalFrameDeiconified(InternalFrameEvent arg0) {
    }

    public void internalFrameActivated(InternalFrameEvent arg0) {
    }

    public void internalFrameDeactivated(InternalFrameEvent arg0) {
    }

    private class MyCanvas
    extends Canvas
    implements Runnable {
        double sum = 0.0;
        private Transform3D transCam = new Transform3D();
        private Matrix3f mat_cam = new Matrix3f();
        private static final long serialVersionUID = 1L;

        public MyCanvas() {
            this.setSize(50, 50);
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            Color fg3D = Color.BLACK;
            BasicStroke stroke = new BasicStroke(1.0f);
            this.setBackground(fg3D);
            g2.setPaint(Color.WHITE);
            g2.setStroke(stroke);
            this.setBackground(fg3D);
            Geo3dInfo.getActiveViewer().getMultiTransform().getTransformGroup(1).getTransform(this.transCam);
            this.transCam.get(this.mat_cam);
            g2.setPaint(Color.YELLOW);
            g2.draw(new Line2D.Double(25.0, 25.0, 25.0f + 15.0f * this.mat_cam.getElement(0, 2), 25.0f + 15.0f * this.mat_cam.getElement(1, 2)));
            g2.setPaint(Color.BLUE);
            g2.draw(new Line2D.Double(25.0, 25.0, 25.0f + 15.0f * -this.mat_cam.m01, 25.0f + 15.0f * -this.mat_cam.m11));
            g2.setPaint(Color.RED);
            g2.draw(new Line2D.Double(25.0, 25.0, 25.0f + 15.0f * this.mat_cam.m00, 25.0f + 15.0f * this.mat_cam.m10));
            this.sum += 1.0;
        }

        public void run() {
            this.repaint();
        }
    }
}

