/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.scec.geo3d.plugins.Plugin;
import org.scec.geo3d.tools.plugin.PluginHandlerImpl;

public class PreferencesGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public JCheckBox[] pluginBoxes;
    public JScrollPane boxScrollPane;
    public JButton selectAllButton = new JButton("Select All");
    public JButton unselectAllButton = new JButton("Unselect All");
    public JButton okButton = new JButton("OK");
    public JButton cancelButton = new JButton("Cancel");
    public JPanel buttonsPanel = new JPanel();
    public JPanel boxesPanel = new JPanel();
    public JPanel allPanel = new JPanel();
    public int numAllPlugins;
    private PluginHandlerImpl handler = PluginHandlerImpl.getLastInstance();

    public PreferencesGUI() {
        Plugin[] allPlugins = this.handler.getAllPlugins();
        this.numAllPlugins = this.handler.getNumAllPlugins();
        this.pluginBoxes = new JCheckBox[this.numAllPlugins];
        Plugin[] plugins = this.handler.getPlugins();
        int numPlugins = this.handler.getNumPlugins();
        int i = 0;
        while (i < this.numAllPlugins) {
            String name = allPlugins[i].getMetadata().getName();
            this.pluginBoxes[i] = new JCheckBox(name);
            System.out.println(allPlugins[i].getMetadata().getName());
            int j = 0;
            while (j < numPlugins) {
                if (name.equals(plugins[j].getMetadata().getName())) {
                    this.pluginBoxes[i].setSelected(true);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.boxesPanel.setLayout(new GridLayout(this.numAllPlugins, 1, 0, 0));
        i = 0;
        while (i < this.numAllPlugins) {
            this.boxesPanel.add(this.pluginBoxes[i]);
            ++i;
        }
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.unselectAllButton.addActionListener(this);
        this.selectAllButton.addActionListener(this);
        this.boxScrollPane = new JScrollPane(this.boxesPanel);
        this.boxScrollPane.setVerticalScrollBarPolicy(20);
        this.buttonsPanel.setLayout(new GridLayout(2, 2, 10, 10));
        this.buttonsPanel.add(this.selectAllButton);
        this.buttonsPanel.add(this.unselectAllButton);
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.okButton.setEnabled(true);
        this.allPanel.setLayout(new BoxLayout(this.allPanel, 3));
        this.allPanel.add(new JLabel("Select plugins for loading on startup:"));
        this.allPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.allPanel.add(this.boxScrollPane);
        this.allPanel.add(Box.createVerticalGlue());
        this.allPanel.add(this.buttonsPanel);
        this.allPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pack();
        this.setContentPane(this.allPanel);
        this.setTitle("Preferences");
        this.setSize(300, 15 * this.numAllPlugins + 250);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object eventObject = e.getSource();
        if (eventObject == this.cancelButton) {
            this.dispose();
        } else if (eventObject == this.selectAllButton) {
            int i = 0;
            while (i < this.numAllPlugins) {
                this.pluginBoxes[i].setSelected(true);
                ++i;
            }
        } else if (eventObject == this.unselectAllButton) {
            int i = 0;
            while (i < this.numAllPlugins) {
                this.pluginBoxes[i].setSelected(false);
                ++i;
            }
        } else if (eventObject == this.okButton) {
            this.savePrefs();
            this.dispose();
        }
    }

    private void savePrefs() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter("conf/preferences.pref"));
            int i = 0;
            while (i < this.numAllPlugins) {
                writer.write(String.valueOf(this.pluginBoxes[i].getText()) + " " + this.pluginBoxes[i].isSelected() + "\n");
                ++i;
            }
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("Exception " + ex);
        }
    }
}

