/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.scec.geo3d.gui.ViewRange;
import org.scec.geo3d.plugins.utils.components.IntegerTextField;

public class SetViewGUI
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##0.0");
    private static int a_l = 21;
    private static int a_c = 10;
    private static int a_r = 22;
    private static int f = 0;
    private JComboBox rangeChooser;
    private IntegerTextField lat_N_value;
    private IntegerTextField lon_W_value;
    private IntegerTextField lon_E_value;
    private IntegerTextField lat_S_value;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel invalidInput;
    private ImageIcon helloImage;
    private JLabel imageLabel;
    private ViewRange rangeValues;
    private Hashtable presetValues;
    private String[] presetChoices;
    private static Logger log;
    private Component dialogOwner;
    protected boolean cancelled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.gui.SetViewGUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public SetViewGUI(Component owner) {
        super(JOptionPane.getFrameForComponent(owner), "Welcome to SCEC-VDO", true);
        this.dialogOwner = owner;
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                SetViewGUI.this.cancelled = true;
            }
        });
        Container content = this.getContentPane();
        content.add(this.getContentPanel());
        this.pack();
        this.setResizable(false);
        this.rangeChooser.setSelectedIndex(0);
        this.setLocationRelativeTo(this.dialogOwner);
    }

    public ViewRange getNewViewRange() {
        this.cancelled = false;
        this.invalidInput.setVisible(false);
        this.setLocationRelativeTo(this.dialogOwner);
        this.setVisible(true);
        if (this.cancelled) {
            return null;
        }
        return this.rangeValues;
    }

    private JPanel getContentPanel() {
        this.rangeValues = new ViewRange();
        this.initChooser();
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, 2));
        rangePanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        rangePanel.add(new JLabel("Set initial grid range:"));
        rangePanel.add(Box.createHorizontalStrut(4));
        rangePanel.add(this.rangeChooser);
        this.lat_N_value = new IntegerTextField(2, false, 3);
        this.lon_W_value = new IntegerTextField(3, false, 3);
        this.lon_E_value = new IntegerTextField(3, false, 3);
        this.lat_S_value = new IntegerTextField(2, false, 3);
        JLabel lat_N_label = new JLabel("Lat:");
        JLabel deg_N_label = new JLabel("(max)");
        deg_N_label.setForeground(Color.GRAY);
        JLabel lon_W_label = new JLabel("Lon:");
        JLabel deg_W_label = new JLabel("(min)");
        deg_W_label.setForeground(Color.GRAY);
        JLabel lon_E_label = new JLabel("Lon:");
        JLabel deg_E_label = new JLabel("(max)");
        deg_E_label.setForeground(Color.GRAY);
        JLabel lat_S_label = new JLabel("Lat:");
        JLabel deg_S_label = new JLabel("(min)");
        deg_S_label.setForeground(Color.GRAY);
        JLabel lat_to_lon = new JLabel("to");
        int innerSpacer = 4;
        JPanel lat_N_panel = new JPanel();
        lat_N_panel.setLayout(new BoxLayout(lat_N_panel, 2));
        lat_N_panel.add(lat_N_label);
        lat_N_panel.add(Box.createHorizontalStrut(innerSpacer));
        lat_N_panel.add(this.lat_N_value);
        lat_N_panel.add(Box.createHorizontalStrut(innerSpacer));
        lat_N_panel.add(deg_N_label);
        JPanel lon_EW_panel = new JPanel();
        lon_EW_panel.setLayout(new BoxLayout(lon_EW_panel, 2));
        lon_EW_panel.add(lon_W_label);
        lon_EW_panel.add(Box.createHorizontalStrut(innerSpacer));
        lon_EW_panel.add(this.lon_W_value);
        lon_EW_panel.add(Box.createHorizontalStrut(innerSpacer));
        lon_EW_panel.add(deg_W_label);
        lon_EW_panel.add(Box.createHorizontalStrut(40));
        lon_EW_panel.add(lat_to_lon);
        lon_EW_panel.add(Box.createHorizontalStrut(40));
        lon_EW_panel.add(lon_E_label);
        lon_EW_panel.add(Box.createHorizontalStrut(innerSpacer));
        lon_EW_panel.add(this.lon_E_value);
        lon_EW_panel.add(Box.createHorizontalStrut(innerSpacer));
        lon_EW_panel.add(deg_E_label);
        JPanel lat_S_panel = new JPanel();
        lat_S_panel.setLayout(new BoxLayout(lat_S_panel, 2));
        lat_S_panel.add(lat_S_label);
        lat_S_panel.add(Box.createHorizontalStrut(innerSpacer));
        lat_S_panel.add(this.lat_S_value);
        lat_S_panel.add(Box.createHorizontalStrut(innerSpacer));
        lat_S_panel.add(deg_S_label);
        JPanel rangeDataPanel = new JPanel(new GridBagLayout());
        rangeDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        rangeDataPanel.add((Component)lat_N_panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, a_c, f, new Insets(0, 0, 0, 0), 0, 0));
        rangeDataPanel.add((Component)lon_EW_panel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, a_c, f, new Insets(10, 20, 0, 20), 0, 0));
        rangeDataPanel.add((Component)lat_S_panel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, a_c, f, new Insets(10, 0, 10, 0), 0, 0));
        this.invalidInput = new JLabel("Invalid range data");
        this.invalidInput.setVisible(false);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setRequestFocusEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(7, 20, 10, 20));
        buttonPanel.add(this.invalidInput);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.okButton);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 3));
        contentPanel.add(rangePanel);
        contentPanel.add(rangeDataPanel);
        contentPanel.add(new JSeparator());
        contentPanel.add(buttonPanel);
        return contentPanel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initChooser() {
        this.presetValues = new Hashtable();
        File rangeValsFile = new File("conf/setView_config.xml");
        SAXBuilder parser = new SAXBuilder();
        Document doc = new Document();
        Vector<String> rangeNames = new Vector<String>();
        try {
            try {
                doc = parser.build(rangeValsFile);
                Element ranges = doc.getRootElement().getChild("grid_ranges");
                List rangeList = ranges.getChildren("range");
                ListIterator it = rangeList.listIterator();
                while (it.hasNext()) {
                    Element elem = (Element)it.next();
                    String rangeName = elem.getChild("name").getText();
                    rangeNames.add(rangeName);
                    ViewRange rangeData = null;
                    Element data = elem.getChild("data");
                    try {
                        rangeData = new ViewRange(data.getAttribute("minLat").getIntValue(), data.getAttribute("maxLat").getIntValue(), data.getAttribute("minLon").getIntValue(), data.getAttribute("maxLon").getIntValue());
                    }
                    catch (DataConversionException e) {
                        log.error((Object)"Problem reading SetView_config file");
                    }
                    this.presetValues.put(rangeName, rangeData);
                }
            }
            catch (Exception e) {
                log.warn((Object)"No SetView config file.");
                rangeNames.add("Southern California");
                int[] rangeData = new int[]{32, 36, -122, -114};
                this.presetValues.put("Southern California", rangeData);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.rangeChooser = new JComboBox(rangeNames);
            this.rangeChooser.addActionListener(this);
            throw throwable;
        }
        {
            Object var13_17 = null;
            this.rangeChooser = new JComboBox(rangeNames);
            this.rangeChooser.addActionListener(this);
            return;
        }
    }

    protected boolean validateInput() {
        this.getViewRangeFromFields();
        return this.rangeValues.getLowerLatitude() >= -90 && this.rangeValues.getUpperLatitude() <= 90 && this.rangeValues.getLeftLongitude() >= -180 && this.rangeValues.getRightLongitude() <= 180 && this.rangeValues.getLowerLatitude() < this.rangeValues.getUpperLatitude() && this.rangeValues.getLeftLongitude() < this.rangeValues.getRightLongitude();
    }

    protected void getViewRangeFromFields() {
        this.rangeValues.setLowerLatitude(Integer.parseInt(this.lat_S_value.getText()));
        this.rangeValues.setUpperLatitude(Integer.parseInt(this.lat_N_value.getText()));
        this.rangeValues.setLeftLongitude(Integer.parseInt(this.lon_W_value.getText()));
        this.rangeValues.setRightLongitude(Integer.parseInt(this.lon_E_value.getText()));
    }

    private void processChoice() {
        ViewRange selectedVals = (ViewRange)this.presetValues.get(this.rangeChooser.getSelectedItem());
        this.populateFields(selectedVals);
    }

    protected void populateFields(ViewRange range) {
        this.lat_S_value.setText(range.getLowerLatitudeAsString());
        this.lat_N_value.setText(range.getUpperLatitudeAsString());
        this.lon_W_value.setText(range.getLeftLongitudeAsString());
        this.lon_E_value.setText(range.getRightLongitudeAsString());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.rangeChooser) {
            this.processChoice();
        } else if (source == this.cancelButton) {
            this.cancelled = true;
            this.setVisible(false);
        } else if (source == this.okButton) {
            if (this.validateInput()) {
                this.setVisible(false);
            } else {
                this.invalidInput.setVisible(true);
            }
        }
    }

    public Hashtable getPresetTable() {
        return this.presetValues;
    }

    public ViewRange getCurrentViewRangeForTest() {
        return this.rangeValues;
    }
}

