/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui;

import java.util.Hashtable;
import junit.framework.TestCase;
import org.scec.geo3d.gui.SetViewGUI;
import org.scec.geo3d.gui.ViewRange;

public class SetViewGUITest
extends TestCase {
    SetViewGUI svg;

    protected void setUp() {
        this.svg = new SetViewGUI(null);
    }

    public void testDefaultViewRangeConstructor() throws Exception {
        ViewRange vr = new ViewRange();
        SetViewGUITest.assertEquals((int)32, (int)vr.getLowerLatitude());
        SetViewGUITest.assertEquals((String)"32", (String)vr.getLowerLatitudeAsString());
        SetViewGUITest.assertEquals((int)36, (int)vr.getUpperLatitude());
        SetViewGUITest.assertEquals((String)"36", (String)vr.getUpperLatitudeAsString());
        SetViewGUITest.assertEquals((int)-122, (int)vr.getLeftLongitude());
        SetViewGUITest.assertEquals((String)"-122", (String)vr.getLeftLongitudeAsString());
        SetViewGUITest.assertEquals((int)-114, (int)vr.getRightLongitude());
        SetViewGUITest.assertEquals((String)"-114", (String)vr.getRightLongitudeAsString());
    }

    public void testPresetViewRangesFromConfig() throws Exception {
        this.svg.initChooser();
        Hashtable presets = this.svg.getPresetTable();
        ViewRange vr = (ViewRange)presets.get("Eastern Hemisphere");
        SetViewGUITest.assertEquals((int)-90, (int)vr.getLowerLatitude());
        SetViewGUITest.assertEquals((int)90, (int)vr.getUpperLatitude());
        SetViewGUITest.assertEquals((int)0, (int)vr.getLeftLongitude());
        SetViewGUITest.assertEquals((int)180, (int)vr.getRightLongitude());
    }

    public void testSetViewGuiViewRange() {
        this.svg.populateFields(new ViewRange(-80, 80, 10, 170));
        this.svg.getViewRangeFromFields();
        ViewRange vr = this.svg.getCurrentViewRangeForTest();
        SetViewGUITest.assertEquals((int)-80, (int)vr.getLowerLatitude());
        SetViewGUITest.assertEquals((int)80, (int)vr.getUpperLatitude());
        SetViewGUITest.assertEquals((int)10, (int)vr.getLeftLongitude());
        SetViewGUITest.assertEquals((int)170, (int)vr.getRightLongitude());
    }

    public void testValidInput() throws Exception {
        this.svg.populateFields(new ViewRange(-80, 80, 10, 170));
        SetViewGUITest.assertEquals((boolean)true, (boolean)this.svg.validateInput());
    }

    public void testInvalidInput() throws Exception {
        this.svg.populateFields(new ViewRange(32, -336, -122, -114));
        SetViewGUITest.assertEquals((boolean)false, (boolean)this.svg.validateInput());
        this.svg.populateFields(new ViewRange(36, 32, -122, -114));
        SetViewGUITest.assertEquals((boolean)false, (boolean)this.svg.validateInput());
        this.svg.populateFields(new ViewRange(32, 36, -114, -122));
        SetViewGUITest.assertEquals((boolean)false, (boolean)this.svg.validateInput());
    }
}

