/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui.viewer;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewerAvatar;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DistanceLOD;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.scec.geo3d.gui.ViewRange;
import org.scec.geo3d.gui.viewer.RenderEnabledCanvas3D;
import org.scec.geo3d.mod.behavior.viewer.GeoNav;
import org.scec.geo3d.mod.behavior.viewer.picking.PickBehavior;
import org.scec.geo3d.mod.behavior.viewer.picking.PickGlobe;
import org.scec.geo3d.mod.visuals.grid.GlobeBox;
import org.scec.geo3d.mod.visuals.grid.GlobeLayout;
import org.scec.geo3d.plugins.Plugin;
import org.scec.geo3d.plugins.utils.components.SingleColorChooser;
import org.scec.geo3d.tools.exceptions.StateVectorException;
import org.scec.geo3d.tools.filters.ExampleFileFilter;
import org.scec.geo3d.tools.filters.Geo3DFilter;
import org.scec.geo3d.tools.plugin.Geo3dInfo;
import org.scec.geo3d.tools.plugin.PluginHandler;
import org.scec.geo3d.tools.plugin.PluginHandlerImpl;
import org.scec.geo3d.tools.stateVector.StateVector;

public class GlobeView
extends JInternalFrame
implements ActionListener,
InternalFrameListener,
ComponentListener {
    private static final Color3f BLUE_LIGHT = new Color3f(0.02734f, 0.35547f, 0.66016f);
    private static final Color3f YELLOW_LIGHT = new Color3f(0.99609f, 0.92188f, 0.69141f);
    private static final Color3f PURPLE_LIGHT = new Color3f(0.11328f, 0.082031f, 0.140625f);
    private static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private final int BOUNDING_LIMIT = 40000000;
    private static final long serialVersionUID = 1L;
    static int openFrameCount = 0;
    static int frames = 0;
    static final int offset = 40;
    private static Logger log;
    private boolean showMultViews = false;
    private boolean multviewsShown = false;
    private SimpleUniverse u = null;
    private GraphicsConfiguration config = null;
    private RenderEnabledCanvas3D c = null;
    private RenderEnabledCanvas3D topView = null;
    private RenderEnabledCanvas3D oppView = null;
    private Viewer view = null;
    private TransformGroup allTransGrp = null;
    private TransformGroup globeTransGrp = null;
    private Transform3D t3dOriginal = null;
    private ViewingPlatform vp = null;
    private BranchGroup scene = new BranchGroup();
    private BranchGroup objroot;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(), 30000.0);
    private Vector3d cameraStartingPos = new Vector3d();
    private boolean lightsOn = true;
    private BranchGroup lightScene = new BranchGroup();
    private TransformGroup purpleLightPos = new TransformGroup();
    private TransformGroup yellowLightPos = new TransformGroup();
    private TransformGroup blueLightPos = new TransformGroup();
    private PointLight purpleLight;
    private PointLight yellowLight;
    private PointLight blueLight;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenu viewerMenu = new JMenu("Viewer");
    private JCheckBoxMenuItem splitScreen = new JCheckBoxMenuItem("Multiple Views");
    private JMenuItem snapshotItem = new JMenuItem("Take Snapshot");
    private JMenuItem changeGrid = new JMenuItem("Turn Grid On/Off");
    private JMenuItem resetView = new JMenuItem("Reset View");
    private JMenuItem saveItem = new JMenuItem("Save...");
    private JMenuItem closeItem = new JMenuItem("Close");
    private JMenuItem bkgdColor = new JMenuItem("Background Color...");
    private JMenuItem gridColor = new JMenuItem("Grid Color...");
    private JMenuItem navByClick = new JMenuItem("Turn Nav-by-Pick Off");
    private JMenuItem drawMode = new JMenuItem("Turn Draw Mode On");
    private JMenu navSubMenu = new JMenu("Navigation Toggle");
    private ButtonGroup navToggleGroup = new ButtonGroup();
    private JRadioButtonMenuItem firstOn = new JRadioButtonMenuItem("First Person Nav");
    private JRadioButtonMenuItem thirdOn = new JRadioButtonMenuItem("Third Person Nav");
    private JPanel canvases = null;
    private JPanel innerCan = null;
    private JPanel innerLeft = null;
    private BranchGroup pluginBranchGrp = null;
    private BranchGroup[] bgs = null;
    private Plugin[] plugins = null;
    private int numPlugins = 0;
    private PluginHandler pluginHandler = null;
    private JMenu objectMenu = null;
    private JMenu settingsMenu = null;
    private JMenu extensionsMenu = null;
    private JMenu analysisMenu = null;
    private JMenuItem tempMenuItem;
    private JPanel pluginGUIPanel = null;
    private JSplitPane pluginSplitPane = null;
    protected JTabbedPane pluginTabPane = new JTabbedPane();
    private JScrollPane pluginGUIScrollPane;
    private boolean alreadyResized = false;
    private BufferedImage snapshot = null;
    private boolean deactivated = false;
    private boolean closed = false;
    private JPanel top = null;
    private Rectangle size = null;
    private JPanel all = null;
    private JLabel pict = null;
    private Point oldCanvasLoc = null;
    private Point oldTopLoc = null;
    private Point oldOppLoc = null;
    private Point oldCLoc = null;
    private Dimension oldCSize = new Dimension();
    private Dimension oldoppSize = new Dimension();
    private Dimension oldtopSize = new Dimension();
    private Dimension oldSize = new Dimension();
    private static double equatorial_radius;
    private static double polar_radius;
    int m_lowerLatitude;
    int m_upperLatitude;
    int m_leftLongitude;
    int m_rightLongitude;
    private int latlocation;
    private int lonlocation;
    private JLabel m_StatusMessage = new JLabel();
    private Transform3D viewTrans;
    private HashMap pluginTurnedOnList = null;
    private ArrayList pluginsToLoad = new ArrayList();
    private boolean gridDisplay = true;
    private Switch switchNode;
    private DistanceLOD dLOD;
    private GeoNav keyBehv;
    private Background geo3DBackground;
    private SingleColorChooser colorChooser;
    private GlobeBox gb1;
    private GlobeBox gb2;
    private GlobeBox gb3;
    private GlobeBox gb4;
    private PickBehavior pickBehavior;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.gui.viewer.GlobeView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        equatorial_radius = 6378.14;
        polar_radius = 6356.755;
    }

    public GlobeView(PluginHandler handler, ViewRange viewRange) {
        super("Geo3D Viewer", true, true, true, true);
        log.debug((Object)"constructor handler & viewRange");
        this.setBoundaries(viewRange);
        this.setPluginHandler(handler);
        this.commonSetup();
    }

    public GlobeView() {
        this(null, null);
    }

    public GlobeView(PluginHandler handler) {
        this(handler, null);
    }

    public GlobeView(ViewRange viewRange) {
        this(null, viewRange);
    }

    private void setPluginHandler(PluginHandler handler) {
        this.pluginHandler = handler == null ? PluginHandlerImpl.getInstance() : handler;
    }

    private void setBoundaries(ViewRange viewRange) {
        if (viewRange == null) {
            this.setSoCalBounds();
        } else {
            this.setBoundsGeneral(viewRange);
        }
    }

    private void setBoundsGeneral(ViewRange viewRange) {
        this.m_upperLatitude = viewRange.getUpperLatitude();
        this.m_lowerLatitude = viewRange.getLowerLatitude();
        this.m_leftLongitude = viewRange.getLeftLongitude();
        this.m_rightLongitude = viewRange.getRightLongitude();
    }

    private void setSoCalBounds() {
        ViewRange soCalBounds = new ViewRange();
        this.setBoundsGeneral(soCalBounds);
    }

    public void setupRestore(MultiTransformGroup mtg, HashMap plugins) {
        int i = 0;
        while (i < mtg.getNumTransforms()) {
            Transform3D temp = new Transform3D();
            mtg.getTransformGroup(i).getTransform(temp);
            this.vp.getMultiTransformGroup().getTransformGroup(i).setTransform(temp);
            ++i;
        }
        if (plugins.size() > 0) {
            this.pluginTurnedOnList = plugins;
            i = 0;
            while (i < this.menuBar.getComponentCount()) {
                this.reactivatePlugins((JMenu)this.menuBar.getComponent(i));
                ++i;
            }
        }
    }

    public void commonSetup() {
        this.addInternalFrameListener(this);
        this.setDefaultCloseOperation(2);
        ++openFrameCount;
        ++frames;
        this.top = new JPanel();
        this.top.setLayout(new BorderLayout());
        this.top.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.latlocation = (this.m_upperLatitude + this.m_lowerLatitude) / 2;
        this.lonlocation = (this.m_leftLongitude + this.m_rightLongitude) / 2;
        this.config = SimpleUniverse.getPreferredConfiguration();
        this.setUpMainScene(this.lonlocation, this.latlocation, this.config);
        this.keyBehv = new GeoNav();
        this.keyBehv.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 4.0E7));
        this.vp.setViewPlatformBehavior((ViewPlatformBehavior)this.keyBehv);
        if (this.showMultViews) {
            this.setUpTopMultView();
            this.setUpBottomMultView();
            this.view.setAvatar(this.createViewerAvatar(new Color3f(1.0f, 1.1f, 0.1f)));
        }
        View appView = this.u.getViewer().getView();
        appView.setBackClipDistance(20000.0);
        appView.setTransparencySortingPolicy(1);
        appView.setVisibilityPolicy(0);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.setUpMenus();
        this.setupKeyboardShortcuts();
        this.pluginBranchGrp = new BranchGroup();
        this.setGeo3dInfoParams();
        this.loadInPlugins();
        this.all = new JPanel();
        this.all.setLayout(new BorderLayout());
        System.out.print("setting menubar::" + this.menuBar);
        this.setJMenuBar(this.menuBar);
        this.all.add((Component)this.top, "Center");
        this.canvases = new JPanel();
        this.innerLeft = new JPanel();
        this.innerLeft.setLayout(new GridLayout(1, 1));
        this.c.setBackground(TRANSPARENT);
        this.innerLeft.add((Component)((Object)this.c));
        this.c.addMouseListener(this.keyBehv);
        this.c.addMouseMotionListener(this.keyBehv);
        this.c.addComponentListener(this);
        this.keyBehv.updateCanvasSize();
        this.setPreferredSize(new Dimension(542, 612));
        if (this.showMultViews) {
            this.setUpMultiViewGui();
        } else {
            this.setUpSingleViewGui();
        }
        this.top.add(this.canvases);
        this.top.add((Component)this.m_StatusMessage, "Last");
        this.setContentPane(this.all);
        if (openFrameCount % 10 == 0 && openFrameCount != 0) {
            frames = 1;
        }
        this.setLocation(40 * frames, 40 * frames);
        this.setStatusMessage("Ready.");
        BranchGroup pgGroup = new BranchGroup();
        PickGlobe globe = new PickGlobe();
        pgGroup.addChild((Node)globe);
        pgGroup.setCapability(1);
        this.pickBehavior = new PickBehavior(this.c, pgGroup, (Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 130000.0), this.keyBehv);
        pgGroup.addChild((Node)this.pickBehavior);
        this.pluginBranchGrp.addChild((Node)pgGroup);
    }

    private void setUpSingleViewGui() {
        this.canvases.setLayout(new GridLayout(1, 1));
        this.canvases.add(this.innerLeft);
        this.setSize(542, 612);
        this.keyBehv.updateCanvasSize();
    }

    private void setUpMultiViewGui() {
        this.canvases.setLayout(new GridLayout(1, 2, 4, 0));
        this.canvases.add(this.innerLeft);
        this.innerCan = new JPanel();
        this.innerCan.setLayout(new GridLayout(2, 1, 0, 4));
        this.innerCan.add((Component)((Object)this.topView));
        this.innerCan.add((Component)((Object)this.oppView));
        this.canvases.add(this.innerCan);
        this.setSize(802, 612);
        this.keyBehv.updateCanvasSize();
    }

    private void setUpTopMultView() {
        Point3d eye2 = new Point3d(15000.0 * Math.cos(this.deg2rad(this.lonlocation)) * Math.cos(this.deg2rad(this.latlocation)), 15000.0 * Math.sin(this.deg2rad(this.latlocation)), -15000.0 * Math.cos(this.deg2rad(this.latlocation)) * Math.sin(this.deg2rad(this.lonlocation)));
        Point3d center2 = new Point3d(0.0, 0.0, 0.0);
        this.topView = new RenderEnabledCanvas3D(this.config);
        this.commmonMultSetup(this.topView, eye2, center2);
    }

    private void commmonMultSetup(RenderEnabledCanvas3D canvas, Point3d eyeMult, Point3d centerMult) {
        canvas.setSize(256, 256);
        Viewer viewMult = new Viewer((Canvas3D)canvas);
        ViewingPlatform vpMult = new ViewingPlatform();
        Transform3D t3dMult = new Transform3D();
        Vector3d upMult = new Vector3d(0.0, 1.0, 0.0);
        t3dMult.lookAt(eyeMult, centerMult, upMult);
        t3dMult.invert();
        MultiTransformGroup mtgMult = vpMult.getMultiTransformGroup();
        mtgMult.getTransformGroup(0).setTransform(t3dMult);
        vpMult.getViewPlatformTransform().setCapability(18);
        vpMult.getViewPlatformTransform().setCapability(17);
        viewMult.setViewingPlatform(vpMult);
        this.u.getLocale().addBranchGraph((BranchGroup)vpMult);
        viewMult.getView().setBackClipDistance(20000.0);
    }

    private void setUpBottomMultView() {
        Point3d eye3 = new Point3d(5000.0 * Math.cos(this.deg2rad(this.lonlocation)) * Math.cos(this.deg2rad(this.latlocation)), 5000.0 * Math.sin(this.deg2rad(this.latlocation)), -5000.0 * Math.cos(this.deg2rad(this.latlocation)) * Math.sin(this.deg2rad(this.lonlocation)));
        Point3d center3 = new Point3d(12000.0 * Math.cos(this.deg2rad(this.lonlocation)) * Math.cos(this.deg2rad(this.latlocation)), 12000.0 * Math.sin(this.deg2rad(this.latlocation)), -12000.0 * Math.cos(this.deg2rad(this.latlocation)) * Math.sin(this.deg2rad(this.lonlocation)));
        this.oppView = new RenderEnabledCanvas3D(this.config);
        this.commmonMultSetup(this.oppView, eye3, center3);
    }

    private void setUpMainScene(int lonlocation, int latlocation, GraphicsConfiguration config) {
        this.c = new RenderEnabledCanvas3D(config);
        this.c.setSize(512, 512);
        this.view = new Viewer((Canvas3D)this.c);
        this.vp = new ViewingPlatform(2);
        this.setCapabilities((SceneGraphObject)this.vp);
        BranchGroup scene = new BranchGroup();
        this.t3dOriginal = new Transform3D();
        Point3d eye = new Point3d(10000.0 * Math.cos(this.deg2rad(lonlocation)) * Math.cos(this.deg2rad(latlocation)), 10000.0 * Math.sin(this.deg2rad(latlocation)), -10000.0 * Math.cos(this.deg2rad(latlocation)) * Math.sin(this.deg2rad(lonlocation)));
        this.cameraStartingPos = new Vector3d((Tuple3d)eye);
        Point3d center = new Point3d(0.0, 0.0, 0.0);
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        this.t3dOriginal.lookAt(eye, center, up);
        this.t3dOriginal.invert();
        MultiTransformGroup mtg = this.vp.getMultiTransformGroup();
        mtg.getTransformGroup(0).setTransform(this.t3dOriginal);
        this.setCapabilities((SceneGraphObject)scene);
        scene.addChild((Node)this.createSceneGraph(eye));
        this.u = new SimpleUniverse(this.vp, this.view);
        this.u.addBranchGraph(scene);
    }

    private void setCapabilities(SceneGraphObject object) {
        if (!object.isCompiled() && !object.isLive()) {
            object.setCapability(12);
            object.setCapability(13);
            object.setCapability(14);
            object.setCapability(17);
            object.setCapability(3);
        }
    }

    private void setGeo3dInfoParams() {
        Geo3dInfo.setActiveViewer(this);
        ViewingPlatform vp = this.u.getViewingPlatform();
        Geo3dInfo.setViewingPlatform(vp);
        Geo3dInfo.setPluginBranchGroup(this.pluginBranchGrp);
    }

    private void loadInPlugins() {
        this.pluginHandler.loadPlugins();
        this.numPlugins = this.pluginHandler.getNumPlugins();
        this.plugins = this.pluginHandler.getPlugins();
        this.bgs = new BranchGroup[this.numPlugins];
        this.setCapabilities((SceneGraphObject)this.pluginBranchGrp);
        this.allTransGrp.addChild((Node)this.pluginBranchGrp);
        this.objectMenu = new JMenu("Objects");
        this.menuBar.add(this.objectMenu);
        this.settingsMenu = new JMenu("Settings");
        this.menuBar.add(this.settingsMenu);
        this.extensionsMenu = new JMenu("Extensions");
        this.menuBar.add(this.extensionsMenu);
        this.analysisMenu = new JMenu("Analysis");
        this.menuBar.add(this.analysisMenu);
        long[] pTime = new long[this.numPlugins];
        int i = 0;
        while (i < this.numPlugins) {
            pTime[i] = System.currentTimeMillis();
            BranchGroup temp = this.plugins[i].init();
            if (temp != null) {
                this.bgs[i] = (BranchGroup)temp.cloneTree();
                this.bgs[i].setCapability(17);
            }
            JPanel p = this.plugins[i].getGUI();
            JCheckBoxMenuItem pluginMenuItem = new JCheckBoxMenuItem();
            if (this.plugins[i].getType() == 2) {
                pluginMenuItem = new JCheckBoxMenuItem(this.plugins[i].getMetadata().getShortName());
                pluginMenuItem.setName(this.plugins[i].getMetadata().getShortName());
                this.objectMenu.add(pluginMenuItem);
                pluginMenuItem.addActionListener(this);
                if (p != null) {
                    this.tempMenuItem = new JCheckBoxMenuItem(this.plugins[i].getMetadata().getShortName());
                    this.settingsMenu.add(this.tempMenuItem);
                    this.tempMenuItem.addActionListener(this);
                }
            } else if (this.plugins[i].getType() == 0 || this.plugins[i].getType() == 4) {
                this.tempMenuItem = new JCheckBoxMenuItem(this.plugins[i].getMetadata().getShortName());
                this.extensionsMenu.add(this.tempMenuItem);
                this.tempMenuItem.addActionListener(this);
            } else if (this.plugins[i].getType() == 6) {
                this.tempMenuItem = new JCheckBoxMenuItem(this.plugins[i].getMetadata().getShortName());
                this.analysisMenu.add(this.tempMenuItem);
                this.tempMenuItem.addActionListener(this);
            }
            this.setUpPluginTabs();
            if (this.pluginTurnedOnList != null) {
                int k = 0;
                while (k < this.pluginTurnedOnList.size()) {
                    if (this.pluginTurnedOnList.containsKey(pluginMenuItem.getName())) {
                        pluginMenuItem.setState(true);
                    }
                    ++k;
                }
            }
            pTime[i] = System.currentTimeMillis() - pTime[i];
            System.out.println("Took " + (double)pTime[i] / 1000.0 + " seconds to load " + this.plugins[i].getMetadata().getShortName() + ".");
            ++i;
        }
        int totTime = 0;
        int i2 = 0;
        while (i2 < this.numPlugins) {
            totTime = (int)((long)totTime + pTime[i2]);
            ++i2;
        }
        System.out.println("Total time spent loading plugins: " + (double)totTime / 1000.0 + " seconds.");
        if (this.settingsMenu.getItemCount() == 0) {
            this.menuBar.remove(this.settingsMenu);
        }
        if (this.objectMenu.getItemCount() == 0) {
            this.menuBar.remove(this.objectMenu);
        }
    }

    private boolean pluginInList(String name) {
        int i = 0;
        while (i < this.pluginsToLoad.size()) {
            String test = (String)this.pluginsToLoad.get(i);
            if (name.equals(test)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ViewerAvatar createViewerAvatar(Color3f objColor) {
        ViewerAvatar viewerAvatar = new ViewerAvatar();
        TransformGroup tg = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setEuler(new Vector3d(1.5707963267948966, Math.PI, 0.0));
        tg.setTransform(t3d);
        Appearance app = new Appearance();
        Color3f color = new Color3f(0.4f, 0.2f, 0.1f);
        app.setMaterial(new Material(objColor, color, objColor, color, 90.0f));
        tg.addChild((Node)new Cone(50.0f, 150.0f, 1, app));
        viewerAvatar.addChild((Node)tg);
        return viewerAvatar;
    }

    private void setUpPluginTabs() {
        this.pluginGUIPanel = new JPanel();
        this.pluginGUIPanel.add(this.pluginTabPane);
        this.pluginTabPane.setBorder(BorderFactory.createEtchedBorder());
        this.pluginGUIScrollPane = new JScrollPane(this.pluginGUIPanel);
    }

    public BranchGroup createSceneGraph(Point3d eye) {
        BranchGroup tempGrp = new BranchGroup();
        this.setCapabilities((SceneGraphObject)tempGrp);
        this.allTransGrp = new TransformGroup();
        this.setCapabilities((SceneGraphObject)this.allTransGrp);
        this.allTransGrp.setCapability(18);
        this.allTransGrp.setCapability(17);
        this.globeTransGrp = new TransformGroup();
        this.setCapabilities((SceneGraphObject)this.globeTransGrp);
        this.globeTransGrp.setCapability(18);
        this.globeTransGrp.setCapability(17);
        this.allTransGrp.addChild((Node)this.globeTransGrp);
        this.setUpLevelOfDetail();
        this.addLights();
        tempGrp.addChild((Node)this.lightScene);
        this.changeLightDisplay(true);
        tempGrp.addChild((Node)this.allTransGrp);
        Color3f pukeyGreen = new Color3f(0.5f, 0.9f, 0.5f);
        this.geo3DBackground = new Background(0.0f, 0.0f, 0.0f);
        this.geo3DBackground.setCapability(16);
        this.geo3DBackground.setCapability(17);
        this.geo3DBackground.setApplicationBounds((Bounds)this.bounds);
        tempGrp.addChild((Node)this.geo3DBackground);
        return tempGrp;
    }

    private void addLights() {
        Color3f ambientColor = new Color3f(0.4f, 0.4f, 0.4f);
        AmbientLight ambLight = new AmbientLight(ambientColor);
        ambLight.setInfluencingBounds((Bounds)this.bounds);
        this.lightScene.addChild((Node)ambLight);
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 4.0E7);
        Color3f dirColor = new Color3f(0.5f, 0.5f, 0.5f);
        Transform3D yPos = new Transform3D();
        yPos.setTranslation(new Vector3d(0.0, 0.0, 0.0));
        this.purpleLightPos.setTransform(yPos);
        yPos = new Transform3D();
        yPos.setTranslation(new Vector3d(10000.0 * Math.cos(this.deg2rad(this.lonlocation - 3)) * Math.cos(this.deg2rad(this.latlocation - 3)), 10000.0 * Math.sin(this.deg2rad(this.latlocation - 3)), -16600.0 * Math.cos(this.deg2rad(this.latlocation - 3)) * Math.sin(this.deg2rad(this.lonlocation - 3))));
        this.yellowLightPos.setTransform(yPos);
        this.blueLightPos = new TransformGroup();
        yPos = new Transform3D();
        yPos.setTranslation(new Vector3d(10000.0 * Math.cos(this.deg2rad(-this.lonlocation - 3)) * Math.cos(this.deg2rad(-this.latlocation - 3)), 10000.0 * Math.sin(this.deg2rad(-this.latlocation - 3)), -16600.0 * Math.cos(this.deg2rad(-this.latlocation - 3)) * Math.sin(this.deg2rad(-this.lonlocation - 3))));
        this.blueLightPos.setTransform(yPos);
        Point3f lightatt = new Point3f(0.55f, 1.5E-4f, 0.0f);
        dirColor = PURPLE_LIGHT;
        Point3f lightpos = new Point3f(0.0f, 0.0f, 0.0f);
        this.purpleLight = new PointLight(true, dirColor, lightpos, lightatt);
        this.purpleLight.setInfluencingBounds((Bounds)this.bounds);
        this.purpleLight.setEnable(true);
        this.purpleLightPos.addChild((Node)this.purpleLight);
        lightatt = new Point3f(0.57f, 0.0f, 0.0f);
        dirColor = YELLOW_LIGHT;
        lightpos = new Point3f(0.0f, 0.0f, 0.0f);
        this.yellowLight = new PointLight(false, dirColor, lightpos, lightatt);
        this.yellowLight.setInfluencingBounds((Bounds)this.bounds);
        this.yellowLight.setEnable(true);
        this.yellowLightPos.addChild((Node)this.yellowLight);
        lightatt = new Point3f(0.58f, 3.5E-5f, 4.0E-8f);
        dirColor = BLUE_LIGHT;
        lightpos = new Point3f(0.0f, 0.0f, 0.0f);
        this.blueLight = new PointLight(false, dirColor, lightpos, lightatt);
        this.blueLight.setInfluencingBounds((Bounds)this.bounds);
        this.blueLight.setEnable(true);
        this.blueLightPos.addChild((Node)this.blueLight);
        this.lightScene.addChild((Node)this.purpleLightPos);
        this.lightScene.addChild((Node)this.yellowLightPos);
        this.lightScene.addChild((Node)this.blueLightPos);
    }

    private void setUpLevelOfDetail() {
        this.switchNode = new Switch();
        this.switchNode.setCapability(17);
        this.switchNode.setCapability(18);
        double latSpread = this.m_upperLatitude - this.m_lowerLatitude;
        double lonSpread = this.m_rightLongitude - this.m_leftLongitude;
        float[] distanceArray = new float[]{30000.0f};
        if (latSpread >= 6.0 && lonSpread >= 6.0) {
            distanceArray = new float[3];
        } else if (latSpread >= 4.0 && lonSpread >= 4.0) {
            distanceArray = new float[2];
        }
        GlobeLayout gl = new GlobeLayout(this.m_upperLatitude, this.m_lowerLatitude, this.m_leftLongitude, this.m_rightLongitude, 1);
        GlobeBox gb1 = new GlobeBox(this.allTransGrp, gl);
        gb1 = new GlobeBox(this.allTransGrp, gl);
        this.switchNode.addChild((Node)gb1.drawGlobe());
        if (latSpread >= 2.0 && lonSpread >= 2.0) {
            GlobeLayout g2 = new GlobeLayout(this.m_upperLatitude, this.m_lowerLatitude, this.m_leftLongitude, this.m_rightLongitude, 2);
            this.gb2 = new GlobeBox(this.allTransGrp, g2);
            this.switchNode.addChild((Node)this.gb2.drawGlobe());
            distanceArray[0] = 10000.0f;
        }
        if (latSpread >= 4.0 && lonSpread >= 4.0) {
            GlobeLayout g3 = new GlobeLayout(this.m_upperLatitude, this.m_lowerLatitude, this.m_leftLongitude, this.m_rightLongitude, 4);
            this.gb3 = new GlobeBox(this.allTransGrp, g3);
            this.switchNode.addChild((Node)this.gb3.drawGlobe());
            distanceArray[1] = 14000.0f;
        }
        if (latSpread >= 6.0 && lonSpread >= 6.0) {
            GlobeLayout g4 = new GlobeLayout(this.m_upperLatitude, this.m_lowerLatitude, this.m_leftLongitude, this.m_rightLongitude, 6);
            this.gb4 = new GlobeBox(this.allTransGrp, g4);
            this.switchNode.addChild((Node)this.gb4.drawGlobe());
            distanceArray[2] = 18000.0f;
        }
        this.dLOD = new DistanceLOD(distanceArray);
        this.dLOD.setSchedulingBounds((Bounds)this.bounds);
        this.dLOD.addSwitch(this.switchNode);
        this.globeTransGrp.addChild((Node)this.dLOD);
        this.globeTransGrp.addChild((Node)this.switchNode);
        this.globeTransGrp.setPickable(true);
    }

    public void setUpMenus() {
        this.setupFileMenu();
        this.setupViewMenu();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewerMenu);
    }

    private void setupFileMenu() {
        this.saveItem.addActionListener(this);
        this.closeItem.addActionListener(this);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeItem);
    }

    private void setupViewMenu() {
        this.resetView.addActionListener(this);
        this.changeGrid.addActionListener(this);
        this.splitScreen.addActionListener(this);
        this.snapshotItem.addActionListener(this);
        this.bkgdColor.addActionListener(this);
        this.gridColor.addActionListener(this);
        this.drawMode.addActionListener(this);
        this.navByClick.addActionListener(this);
        this.viewerMenu.add(this.resetView);
        this.viewerMenu.add(this.changeGrid);
        this.viewerMenu.add(this.splitScreen);
        this.viewerMenu.add(this.snapshotItem);
        this.viewerMenu.add(this.bkgdColor);
        this.viewerMenu.add(this.gridColor);
        this.viewerMenu.add(this.navByClick);
        this.viewerMenu.add(this.drawMode);
        this.snapshotItem.addActionListener(this);
        this.menuBar.add(this.viewerMenu);
        this.thirdOn.setSelected(true);
        this.navToggleGroup.add(this.firstOn);
        this.navToggleGroup.add(this.thirdOn);
        this.navSubMenu.add(this.thirdOn);
        this.navSubMenu.add(this.firstOn);
        this.firstOn.addActionListener(this);
        this.thirdOn.addActionListener(this);
        this.viewerMenu.add(this.navSubMenu);
    }

    private void setupKeyboardShortcuts() {
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.closeItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.changeGrid.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        this.drawMode.setAccelerator(KeyStroke.getKeyStroke(16, 0));
        this.navByClick.setAccelerator(KeyStroke.getKeyStroke(78, 3));
    }

    public void setUpSave() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.addChoosableFileFilter(new Geo3DFilter());
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            String s = f.getAbsolutePath();
            if (s.lastIndexOf(".xml") != s.length() - 4) {
                s = String.valueOf(s) + ".xml";
            }
            File file = new File(s);
            this.saveState(file);
        }
    }

    public void saveState(File file) {
        StateVector sv = new StateVector();
        try {
            sv.saveState(this, file);
        }
        catch (StateVectorException e) {
            log.error((Object)("StateVectorException in GlobeView.setUpSave(): " + e.getMessage()));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object eventSource = e.getSource();
        if (eventSource == this.closeItem) {
            this.closeGlobeView();
        } else if (eventSource == this.saveItem) {
            this.setUpSave();
        } else if (eventSource == this.snapshotItem) {
            this.takeSnapshot();
        } else if (eventSource == this.splitScreen) {
            this.toggleViews();
        } else if (eventSource == this.changeGrid) {
            this.changeGridDisplay();
        } else if (eventSource == this.resetView) {
            this.resetView();
        } else if (eventSource == this.drawMode) {
            this.keyBehv.toggleDrawMode();
        } else if (eventSource == this.navByClick) {
            this.pickBehavior.toggleAllowNav();
        } else if (eventSource == this.bkgdColor) {
            this.changeBackgroundColor();
        } else if (eventSource == this.gridColor) {
            this.changeGridColor();
        } else if (eventSource == this.firstOn) {
            this.keyBehv.setFirstPersonPerspective(true);
        } else if (eventSource == this.thirdOn) {
            this.keyBehv.setFirstPersonPerspective(false);
        } else {
            this.checkPluginMenus(eventSource);
        }
    }

    private void changeBackgroundColor() {
        Color newColor;
        if (this.colorChooser == null) {
            this.colorChooser = new SingleColorChooser(this);
        }
        if ((newColor = this.colorChooser.getColor()) != null) {
            this.geo3DBackground.setColor(new Color3f(newColor));
        }
    }

    private void changeGridColor() {
        Color newColor;
        if (this.colorChooser == null) {
            this.colorChooser = new SingleColorChooser(this);
        }
        if ((newColor = this.colorChooser.getColor()) != null) {
            if (this.gb1 != null) {
                this.gb1.setColor(new Color3f(newColor));
            }
            if (this.gb2 != null) {
                this.gb2.setColor(new Color3f(newColor));
            }
            if (this.gb3 != null) {
                this.gb3.setColor(new Color3f(newColor));
            }
            if (this.gb4 != null) {
                this.gb4.setColor(new Color3f(newColor));
            }
        }
    }

    public void changeBackgroundColorForStateRestoration(Color3f color) {
        this.geo3DBackground.setColor(color);
    }

    public void changeGridColorForStateRestoration(Color3f color) {
        if (this.gb1 != null) {
            this.gb1.setColor(color);
        }
        if (this.gb2 != null) {
            this.gb2.setColor(color);
        }
        if (this.gb3 != null) {
            this.gb3.setColor(color);
        }
        if (this.gb4 != null) {
            this.gb4.setColor(color);
        }
    }

    public Color3f getBackgroundColor() {
        Color3f background = new Color3f();
        this.geo3DBackground.getColor(background);
        return background;
    }

    public Color3f getGridColor() {
        if (this.gb1 != null) {
            return this.gb1.getColor();
        }
        if (this.gb2 != null) {
            return this.gb2.getColor();
        }
        if (this.gb3 != null) {
            return this.gb3.getColor();
        }
        if (this.gb4 != null) {
            return this.gb4.getColor();
        }
        return null;
    }

    protected void closeGlobeView() {
        this.u = null;
        this.doDefaultCloseAction();
    }

    private void checkPluginMenus(Object eventSource) {
        if (this.checkObjectMenu(eventSource)) {
            return;
        }
        if (this.checkSettingsMenu(eventSource)) {
            return;
        }
        if (this.checkExtensionsMenu(eventSource)) {
            return;
        }
        this.checkanalysisMenu(eventSource);
    }

    private boolean checkExtensionsMenu(Object eventSource) {
        int i = 0;
        while (i < this.extensionsMenu.getMenuComponentCount()) {
            if (eventSource == this.extensionsMenu.getItem(i)) {
                String pluginShortName = this.extensionsMenu.getItem(i).getText();
                if (((JCheckBoxMenuItem)this.extensionsMenu.getItem(i)).getState()) {
                    this.addGuiToSplitPane(pluginShortName);
                } else {
                    this.removeGuiFromSplitPane(pluginShortName);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkSettingsMenu(Object eventSource) {
        int i = 0;
        while (i < this.settingsMenu.getMenuComponentCount()) {
            if (eventSource == this.settingsMenu.getItem(i)) {
                String pluginShortName = this.settingsMenu.getItem(i).getText();
                if (((JCheckBoxMenuItem)this.settingsMenu.getItem(i)).getState()) {
                    this.addGuiToSplitPane(pluginShortName);
                } else {
                    this.removeGuiFromSplitPane(pluginShortName);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkObjectMenu(Object eventSource) {
        int i = 0;
        while (i < this.objectMenu.getMenuComponentCount()) {
            if (eventSource == this.objectMenu.getItem(i)) {
                if (((JCheckBoxMenuItem)this.objectMenu.getItem(i)).getState()) {
                    this.addObjectPlugin(i);
                } else {
                    this.removeObjectPlugin(i);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkanalysisMenu(Object eventSource) {
        int i = 0;
        while (i < this.analysisMenu.getMenuComponentCount()) {
            if (eventSource == this.analysisMenu.getItem(i)) {
                String pluginShortName = this.analysisMenu.getItem(i).getText();
                if (((JCheckBoxMenuItem)this.analysisMenu.getItem(i)).getState()) {
                    this.addGuiToSplitPane(pluginShortName);
                } else {
                    this.removeGuiFromSplitPane(pluginShortName);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeObjectPlugin(int i) {
        int j = 0;
        while (j < this.pluginHandler.getNumPlugins()) {
            if (this.plugins[j].getType() == 2 && this.plugins[j].getMetadata().getShortName() == this.objectMenu.getItem(i).getText()) {
                this.bgs[j].detach();
                break;
            }
            ++j;
        }
    }

    public void addObjectPlugin(int i) {
        int j = 0;
        while (j < this.pluginHandler.getNumPlugins()) {
            if (this.plugins[j].getType() == 2 && this.plugins[j].getMetadata().getShortName() == this.objectMenu.getItem(i).getText()) {
                this.pluginBranchGrp.addChild((Node)this.bgs[j]);
                break;
            }
            ++j;
        }
    }

    private void removeGuiFromSplitPane(String pluginShortName) {
        int j = 0;
        while (j < this.pluginTabPane.getTabCount()) {
            if (this.pluginTabPane.getTitleAt(j).equals(pluginShortName)) {
                this.pluginTabPane.removeTabAt(j);
                if (this.pluginTabPane.getTabCount() == 0) {
                    this.remove(this.pluginSplitPane);
                    this.setSize(this.getSize().width - 400, this.getSize().height);
                    this.alreadyResized = false;
                    this.pluginSplitPane = null;
                    this.setContentPane(this.all);
                    this.keyBehv.updateCanvasSize();
                }
            }
            ++j;
        }
    }

    private void addGuiToSplitPane(String pluginShortName) {
        Dimension d = new Dimension(350, 350);
        this.all.setMinimumSize(d);
        this.pluginGUIScrollPane.setMinimumSize(d);
        this.pluginGUIScrollPane.setPreferredSize(new Dimension(400, 400));
        JPanel pluginPanel = null;
        int j = 0;
        while (j < this.pluginHandler.getNumPlugins()) {
            if (this.plugins[j].getMetadata().getShortName().equals(pluginShortName)) {
                pluginPanel = this.plugins[j].restoreGUI();
                JPanel allPanel = new JPanel();
                allPanel.setLayout(new BoxLayout(allPanel, 3));
                allPanel.add(pluginPanel);
                allPanel.add(Box.createVerticalGlue());
                allPanel.add(new JPanel());
                this.pluginTabPane.addTab(pluginShortName, new JScrollPane(allPanel));
                if (this.pluginSplitPane == null) {
                    this.pluginSplitPane = new JSplitPane(1, false, this.all, this.pluginGUIScrollPane);
                    this.pluginSplitPane.setOneTouchExpandable(true);
                    this.pluginSplitPane.setDividerSize(7);
                    this.pluginSplitPane.setResizeWeight(1.0);
                    this.pluginSplitPane.setDividerLocation(0.5);
                    this.remove(this.all);
                    this.setContentPane(this.pluginSplitPane);
                }
                if (!this.alreadyResized) {
                    this.setSize(this.getPreferredSize().width + this.pluginTabPane.getPreferredSize().width + 60, this.getPreferredSize().height + 105);
                    this.pluginSplitPane.setDividerLocation(this.getWidth() - this.pluginTabPane.getPreferredSize().width - 60);
                    this.alreadyResized = true;
                }
                return;
            }
            ++j;
        }
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        --openFrameCount;
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void toggleViews() {
        this.top.removeAll();
        this.canvases.removeAll();
        this.c.setSize(512, 512);
        this.innerLeft = new JPanel();
        this.innerLeft.setLayout(new GridLayout(1, 1));
        this.innerLeft.add((Component)((Object)this.c));
        if (this.showMultViews) {
            this.showMultViews = false;
            this.setUpSingleViewGui();
            this.top.add(this.canvases);
            this.top.add((Component)this.m_StatusMessage, "Last");
            if (this.alreadyResized) {
                this.setSize(842, this.getSize().height);
                this.setContentPane(this.pluginSplitPane);
                this.keyBehv.updateCanvasSize();
            } else {
                this.setSize(542, 612);
                this.setContentPane(this.all);
                this.keyBehv.updateCanvasSize();
            }
        } else {
            this.showMultViews = true;
            this.topView = new RenderEnabledCanvas3D(SimpleUniverse.getPreferredConfiguration());
            this.topView.setSize(256, 256);
            this.oppView = new RenderEnabledCanvas3D(SimpleUniverse.getPreferredConfiguration());
            this.oppView.setSize(256, 256);
            this.setUpTopMultView();
            this.setUpBottomMultView();
            this.view.setAvatar(this.createViewerAvatar(new Color3f(1.0f, 1.1f, 0.1f)));
            this.setUpMultiViewGui();
            this.top.add(this.canvases);
            this.top.add((Component)this.m_StatusMessage, "Last");
            if (this.alreadyResized) {
                this.setContentPane(this.pluginSplitPane);
            } else {
                this.setContentPane(this.all);
            }
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        this.setGeo3dInfoParams();
        if (this.deactivated) {
            this.top.remove(this.pict);
            this.top.add(this.canvases);
        }
        this.deactivated = false;
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
        Point q = this.canvases.getLocationOnScreen();
        Rectangle size = new Rectangle(q.x, q.y, this.canvases.getWidth(), this.canvases.getHeight());
        try {
            this.deactivated = true;
            Robot bot = new Robot();
            this.snapshot = bot.createScreenCapture(size);
            ImageIcon ic = new ImageIcon(this.snapshot);
            this.pict = new JLabel(ic);
            this.top.remove(this.canvases);
            this.top.add(this.pict);
        }
        catch (Exception ex) {
            System.err.println("Exception " + ex + " in screen capture.");
        }
    }

    public void resizeCanvas(Dimension screenSize, int direction) {
        log.debug((Object)("resizeCanvas  Dimension: " + screenSize + " direction: " + direction));
        Point canvasLoc = new Point(this.canvases.getLocationOnScreen());
        this.oldCanvasLoc = new Point();
        this.oldTopLoc = new Point();
        this.oldOppLoc = new Point();
        this.oldCLoc = new Point();
        if (direction == 1 && this.multviewsShown) {
            this.c.setBounds(this.oldCLoc.x, this.oldCLoc.y, this.oldCSize.width, this.oldCSize.height);
            this.topView.setBounds(this.oldTopLoc.x, this.oldTopLoc.y, this.oldtopSize.width, this.oldtopSize.height);
            this.oppView.setBounds(this.oldTopLoc.x, this.oldTopLoc.y + this.oldtopSize.height + 4, this.oldoppSize.width, this.oldoppSize.height);
        } else if (direction == 1 && !this.multviewsShown) {
            this.c.setBounds(this.oldCanvasLoc.x, this.oldCanvasLoc.y, this.oldSize.width, this.oldSize.height);
        } else if (this.showMultViews) {
            Point topLoc = new Point(this.topView.getLocationOnScreen());
            Point oppLoc = new Point(this.oppView.getLocationOnScreen());
            this.multviewsShown = true;
            int deskwidth = Geo3dInfo.getDesktop().getWidth();
            this.oldCSize.width = this.c.getWidth();
            this.oldCSize.height = this.c.getHeight();
            this.oldoppSize.width = this.oppView.getWidth();
            this.oldoppSize.height = this.oppView.getHeight();
            this.oldtopSize.width = this.topView.getWidth();
            this.oldtopSize.height = this.topView.getHeight();
            this.oldCLoc.x = canvasLoc.x;
            this.oldCLoc.y = canvasLoc.y;
            this.oldTopLoc.x = topLoc.x;
            this.oldTopLoc.y = topLoc.y;
            this.oldOppLoc.x = topLoc.x;
            this.oldOppLoc.y = topLoc.y + this.topView.getHeight() + 4;
            this.c.setBounds(-canvasLoc.x, -canvasLoc.y, screenSize.width, screenSize.height);
            this.topView.setBounds(-topLoc.x + screenSize.width - 250, -canvasLoc.y, 200, (int)screenSize.getHeight() / 2);
            this.oppView.setBounds(-oppLoc.x + screenSize.width - 250, (int)((double)(-canvasLoc.y) + screenSize.getHeight() / 2.0), 200, (int)screenSize.getHeight() / 2);
        } else {
            this.oldCanvasLoc.x = canvasLoc.x;
            this.oldCanvasLoc.y = canvasLoc.y;
            this.oldSize.height = this.c.getHeight();
            this.oldSize.width = this.c.getWidth();
            this.c.setBounds(-canvasLoc.x, -(canvasLoc.y + 20), screenSize.width, screenSize.height);
        }
        this.keyBehv.updateCanvasSize();
    }

    public RenderEnabledCanvas3D getCanvasMain() {
        return this.c;
    }

    public void removeCanvases() {
        this.top.remove(this.canvases);
    }

    public void restoreCanvases() {
        this.top.add(this.canvases);
    }

    public BranchGroup getMainScene() {
        return this.scene;
    }

    public void removeSurface() {
        int i = 0;
        while (i < this.pluginHandler.getNumPlugins()) {
            if (this.plugins[i].getType() == 4 && this.bgs[i] != null) {
                this.bgs[i].detach();
            }
            ++i;
        }
    }

    public void update(Plugin p) {
        int i = 0;
        while (i < this.pluginHandler.getNumPlugins()) {
            if (p == this.plugins[i]) {
                this.bgs[i].detach();
                this.bgs[i] = this.plugins[i].init();
                this.pluginBranchGrp.addChild((Node)this.bgs[i]);
                break;
            }
            ++i;
        }
    }

    private void takeSnapshot() {
        log.debug((Object)"takeSnapshot");
        Point ulCorner = this.canvases.getLocationOnScreen();
        Rectangle size2 = new Rectangle(ulCorner.x, ulCorner.y, this.canvases.getWidth(), this.canvases.getHeight());
        try {
            this.c.printAll(this.c.getGraphics());
            int i = 0;
            while (i < 200000000) {
                ++i;
            }
            JFileChooser fc = new JFileChooser();
            ExampleFileFilter jpgFilter = new ExampleFileFilter();
            ExampleFileFilter bmpFilter = new ExampleFileFilter();
            ExampleFileFilter tiffFilter = new ExampleFileFilter();
            ExampleFileFilter pngFilter = new ExampleFileFilter();
            jpgFilter.addExtension("jpeg");
            bmpFilter.addExtension("bmp");
            tiffFilter.addExtension("tiff");
            pngFilter.addExtension("png");
            jpgFilter.setDescription("JPEG Images");
            bmpFilter.setDescription("BMP Images");
            tiffFilter.setDescription("TIFF Images");
            pngFilter.setDescription("PNG Images");
            fc.setFileFilter(jpgFilter);
            fc.setFileFilter(bmpFilter);
            fc.setFileFilter(tiffFilter);
            fc.setFileFilter(pngFilter);
            fc.setFileSelectionMode(0);
            fc.setAcceptAllFileFilterUsed(false);
            Robot bot = new Robot();
            BufferedImage saveScreen = bot.createScreenCapture(size2);
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String s = file.getAbsolutePath();
                if (fc.getFileFilter() == bmpFilter) {
                    if (!s.endsWith(".bmp")) {
                        s = String.valueOf(s) + ".bmp";
                    }
                    RenderedOp op = JAI.create((String)"filestore", (RenderedImage)saveScreen, (Object)s, (Object)"bmp");
                } else if (fc.getFileFilter() == jpgFilter) {
                    if (!s.endsWith(".jpeg")) {
                        s = String.valueOf(s) + ".jpeg";
                    }
                    RenderedOp op = JAI.create((String)"filestore", (RenderedImage)saveScreen, (Object)s, (Object)"jpeg");
                } else if (fc.getFileFilter() == tiffFilter) {
                    if (!s.endsWith(".tiff")) {
                        s = String.valueOf(s) + ".tiff";
                    }
                    RenderedOp op = JAI.create((String)"filestore", (RenderedImage)saveScreen, (Object)s, (Object)"tiff");
                } else if (fc.getFileFilter() == pngFilter) {
                    if (!s.endsWith(".png")) {
                        s = String.valueOf(s) + ".png";
                    }
                    RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)saveScreen, (Object)s, (Object)"png");
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Exception " + ex + " in screen capture.");
        }
    }

    public double deg2rad(double degree) {
        return degree * Math.PI / 180.0;
    }

    public void setStatusMessage(String message) {
        this.m_StatusMessage.setText("Status: " + message);
    }

    public void setMessage(String message) {
        if (!this.getFullScreen()) {
            this.m_StatusMessage.setText(message);
        }
    }

    public MultiTransformGroup getMultiTransform() {
        MultiTransformGroup mtg = this.vp.getMultiTransformGroup();
        return mtg;
    }

    public ArrayList getMenuStates() {
        ArrayList<String> menuStates = new ArrayList<String>();
        int i = 0;
        while (i < this.menuBar.getComponentCount()) {
            JMenu jm = this.menuBar.getMenu(i);
            int j = 0;
            while (j < jm.getMenuComponentCount()) {
                JCheckBoxMenuItem jcb;
                if (jm.getMenuComponent(j) instanceof JCheckBoxMenuItem && (jcb = (JCheckBoxMenuItem)jm.getMenuComponent(j)).getState()) {
                    menuStates.add(jcb.getText());
                }
                if (jm.getMenuComponent(j) instanceof JMenuItem && ((JMenuItem)jm.getMenuComponent(j)).getSubElements().length > 0) {
                    MenuElement[] menuElements = ((JMenuItem)jm.getMenuComponent(j)).getSubElements();
                    System.out.println(menuElements.length);
                    JPopupMenu temp = (JPopupMenu)menuElements[0];
                    int k = 0;
                    while (k < temp.getComponentCount()) {
                        JCheckBoxMenuItem orange;
                        if (temp.getComponent(k) instanceof JCheckBoxMenuItem && (orange = (JCheckBoxMenuItem)temp.getComponent(k)).getState()) {
                            menuStates.add(orange.getText());
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return menuStates;
    }

    public HashMap getPluginStates() {
        HashMap<String, Element> pluginStates = new HashMap<String, Element>();
        int i = 0;
        while (i < this.numPlugins) {
            String s = this.plugins[i].getMetadata().getShortName();
            pluginStates.put(s, this.plugins[i].getState());
            ++i;
        }
        return pluginStates;
    }

    public void reactivatePlugins(JMenu mB) {
        JMenu jm = mB;
        int j = 0;
        while (j < jm.getMenuComponentCount()) {
            String name = "";
            JMenuItem jmi = null;
            if (!(jm.getMenuComponent(j) instanceof JMenuItem)) {
                name = "invalidcomponent";
            } else if (jm.getMenuComponent(j) instanceof JMenu) {
                this.reactivatePlugins((JMenu)jm.getMenuComponent(j));
            } else {
                jmi = (JMenuItem)jm.getMenuComponent(j);
                name = jmi.getText();
            }
            int k = 0;
            while (k < this.pluginTurnedOnList.size()) {
                if (jm.getMenuComponent(j) instanceof JCheckBoxMenuItem && this.pluginTurnedOnList.containsKey(name)) {
                    JCheckBoxMenuItem jcbm = (JCheckBoxMenuItem)jm.getMenuComponent(j);
                    jcbm.setSelected(true);
                    int i = 0;
                    while (i < this.plugins.length) {
                        if (this.plugins[i].getMetadata().getShortName().compareTo(name) == 0) {
                            this.plugins[i].setState((Element)this.pluginTurnedOnList.get(name));
                        }
                        ++i;
                    }
                }
                if (this.pluginTurnedOnList.containsKey(name)) {
                    this.pluginTurnedOnList.remove(name);
                    ActionEvent orange = new ActionEvent(jmi, 0, "command");
                    this.actionPerformed(orange);
                }
                ++k;
            }
            ++j;
        }
    }

    public Appearance setAppearance() {
        Appearance app = new Appearance();
        TransparencyAttributes eqTran = new TransparencyAttributes();
        eqTran.setTransparency(0.4f);
        eqTran.setTransparencyMode(1);
        app.setTransparencyAttributes(eqTran);
        Material eqMat = new Material();
        Color3f specularColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        float shininess = 100.0f;
        Color3f diffuseColor = new Color3f(0.0f, 0.0f, 0.0f);
        eqMat.setDiffuseColor(diffuseColor);
        eqMat.setSpecularColor(specularColour);
        eqMat.setEmissiveColor(emissiveColour);
        eqMat.setShininess(shininess);
        app.setMaterial(eqMat);
        return app;
    }

    private BranchGroup drawInnerSphere() {
        Sphere innerGlobe = new Sphere(5400.0f, this.setAppearance());
        BranchGroup sphereGp = new BranchGroup();
        sphereGp.addChild((Node)innerGlobe);
        System.out.println("SPHERE ADDED");
        return sphereGp;
    }

    public double getEqRad() {
        return equatorial_radius;
    }

    public double getPolRad() {
        return polar_radius;
    }

    public SimpleUniverse getUniverse() {
        return this.u;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GlobeView)) {
            return false;
        }
        GlobeView toCompare = (GlobeView)other;
        if (this.getMultiTransform().getNumTransforms() != toCompare.getMultiTransform().getNumTransforms()) {
            return false;
        }
        int i = 0;
        while (i < this.getMultiTransform().getNumTransforms()) {
            TransformGroup myGroup = this.getMultiTransform().getTransformGroup(i);
            Transform3D myTransform = new Transform3D();
            myGroup.getTransform(myTransform);
            double[] myDouble = new double[16];
            myTransform.get(myDouble);
            TransformGroup otherGroup = toCompare.getMultiTransform().getTransformGroup(i);
            Transform3D otherTransform = new Transform3D();
            otherGroup.getTransform(otherTransform);
            double[] otherDouble = new double[16];
            otherTransform.get(otherDouble);
            int j = 0;
            while (j < 16) {
                if (Math.abs(myDouble[j] - otherDouble[j]) > 1.0E-7) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        HashMap myPlugins = this.getPluginStates();
        HashMap otherPlugins = toCompare.getPluginStates();
        if (myPlugins.size() != otherPlugins.size()) {
            return false;
        }
        int i2 = 0;
        while (i2 < myPlugins.size()) {
            Set mySet = myPlugins.keySet();
            Iterator it = mySet.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!otherPlugins.containsKey(key)) {
                    return false;
                }
                Element value = (Element)myPlugins.get(key);
                if (value.getName().equals(((Element)otherPlugins.get(key)).getName())) continue;
                return false;
            }
            ++i2;
        }
        return true;
    }

    public PluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void changeGridDisplay() {
        if (!this.gridDisplay) {
            this.switchNode.setWhichChild(-2);
            this.dLOD.addSwitch(this.switchNode);
            this.gridDisplay = true;
        } else {
            this.switchNode.setWhichChild(-1);
            this.dLOD.removeAllSwitches();
            this.gridDisplay = false;
        }
    }

    public Switch getSwitchNode() {
        return this.switchNode;
    }

    public DistanceLOD getDLod() {
        return this.dLOD;
    }

    public void changeLightDisplay(boolean lights) {
        this.lightsOn = lights;
    }

    public boolean isLightsOn() {
        return this.lightsOn;
    }

    public void setLightsOn(boolean lightsOn) {
        this.lightsOn = lightsOn;
    }

    public Vector3d getCameraStartingPos() {
        return this.cameraStartingPos;
    }

    public void setCameraStartingPos(Vector3d cameraStartingPos) {
        this.cameraStartingPos = cameraStartingPos;
    }

    public Transform3D getT3dOriginal() {
        return this.t3dOriginal;
    }

    public void setT3dOriginal(Transform3D original) {
        this.t3dOriginal = original;
    }

    public boolean getGridDisplayBool() {
        return this.gridDisplay;
    }

    public ViewRange getViewRange() {
        return new ViewRange(this.m_lowerLatitude, this.m_upperLatitude, this.m_leftLongitude, this.m_rightLongitude);
    }

    public GeoNav getGeoNavObject() {
        return this.keyBehv;
    }

    public void resetView() {
        this.keyBehv.resetView();
    }

    public boolean getFullScreen() {
        return this.keyBehv.getFullScreen();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.keyBehv.updateCanvasSize();
    }

    public void componentShown(ComponentEvent e) {
    }

    public PickBehavior getPickBehavior() {
        return this.pickBehavior;
    }

    public void turnNavByPickOn() {
        this.navByClick.setText("Turn Nav-by-Pick On");
    }

    public void turnNavByPickOff() {
        this.navByClick.setText("Turn Nav-by-Pick Off");
    }

    public void turnDrawModeOff() {
        this.drawMode.setText("Turn Draw Mode Off");
    }

    public void turnDrawModeOn() {
        this.drawMode.setText("Turn Draw Mode On");
    }
}

