/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui.viewer;

import com.sun.j3d.utils.universe.MultiTransformGroup;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.log4j.xml.DOMConfigurator;
import org.scec.geo3d.gui.ViewRange;
import org.scec.geo3d.gui.viewer.GlobeView;
import org.scec.geo3d.tools.plugin.PluginHandlerImpl;
import org.scec.geo3d.tools.plugin.TestingPluginHandler;

public class GlobeViewConstructorTest
extends TestCase {
    private GlobeView view;

    public void setUp() throws Exception {
        DOMConfigurator.configure((String)"conf/log_config.xml");
        this.view = new GlobeView(TestingPluginHandler.getInstance());
    }

    public void testConstructor() throws Exception {
        this.view = new GlobeView();
        this.checkSoCalLatLon();
        this.view = new GlobeView(PluginHandlerImpl.getInstance());
        this.checkSoCalLatLon();
        this.view = new GlobeView();
        this.view.setupRestore(new MultiTransformGroup(), new HashMap());
        this.checkSoCalLatLon();
        ViewRange viewRange = new ViewRange();
        this.view = new GlobeView(viewRange);
        this.checkSoCalLatLon();
        ViewRange nonSoCalViewRange = new ViewRange(30, 38, -120, -112);
        this.view = new GlobeView(TestingPluginHandler.getInstance(), nonSoCalViewRange);
        this.checkNonSoCalLatLon();
        GlobeViewConstructorTest.assertEquals((String)TestingPluginHandler.getInstance().getClass().getName(), (String)this.view.getPluginHandler().getClass().getName());
        this.view = new GlobeView(null, nonSoCalViewRange);
        this.checkNonSoCalLatLon();
        GlobeViewConstructorTest.assertEquals((String)PluginHandlerImpl.getInstance().getClass().getName(), (String)this.view.getPluginHandler().getClass().getName());
        this.view = new GlobeView(TestingPluginHandler.getInstance(), null);
        this.checkSoCalLatLon();
        GlobeViewConstructorTest.assertEquals((String)TestingPluginHandler.getInstance().getClass().getName(), (String)this.view.getPluginHandler().getClass().getName());
        this.view = new GlobeView(null, null);
        this.checkSoCalLatLon();
        GlobeViewConstructorTest.assertEquals((String)PluginHandlerImpl.getInstance().getClass().getName(), (String)this.view.getPluginHandler().getClass().getName());
    }

    private void checkNonSoCalLatLon() {
        GlobeViewConstructorTest.assertEquals((int)38, (int)this.view.m_upperLatitude);
        GlobeViewConstructorTest.assertEquals((int)30, (int)this.view.m_lowerLatitude);
        GlobeViewConstructorTest.assertEquals((int)-120, (int)this.view.m_leftLongitude);
        GlobeViewConstructorTest.assertEquals((int)-112, (int)this.view.m_rightLongitude);
    }

    private void checkSoCalLatLon() {
        GlobeViewConstructorTest.assertEquals((int)36, (int)this.view.m_upperLatitude);
        GlobeViewConstructorTest.assertEquals((int)32, (int)this.view.m_lowerLatitude);
        GlobeViewConstructorTest.assertEquals((int)-122, (int)this.view.m_leftLongitude);
        GlobeViewConstructorTest.assertEquals((int)-114, (int)this.view.m_rightLongitude);
    }
}

