/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui.viewer;

import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.media.j3d.Transform3D;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;
import org.apache.log4j.xml.DOMConfigurator;
import org.scec.geo3d.gui.ViewRange;
import org.scec.geo3d.gui.viewer.GlobeView;
import org.scec.geo3d.tools.plugin.TestingPluginHandler;

public class GlobeViewTest
extends TestCase {
    private GlobeView view;

    public void setUp() throws Exception {
        DOMConfigurator.configure((String)"conf/log_config.xml");
        this.view = new GlobeView(TestingPluginHandler.getInstance());
    }

    public void testCommonSetup() throws Exception {
        this.checkSoCalLatLon();
        GlobeViewTest.assertEquals((String)"Should have the 'all' JPanel", (int)1, (int)this.view.getContentPane().getComponentCount());
        JPanel panel = (JPanel)this.view.getContentPane().getComponent(0);
        GlobeViewTest.assertEquals((int)2, (int)panel.getComponentCount());
        JPanel toppanel = (JPanel)panel.getComponent(0);
        GlobeViewTest.assertEquals((String)"javax.swing.JPanel", (String)toppanel.getClass().getName());
        JLabel label = (JLabel)panel.getComponent(1);
        GlobeViewTest.assertEquals((String)"Status: Ready.", (String)label.getText());
        GlobeViewTest.assertEquals((Object)this.view.getUniverse().getCanvas(), (Object)((Object)this.view.getCanvasMain()));
        ViewingPlatform vp = this.view.getUniverse().getViewingPlatform();
        Transform3D t3doriginal = new Transform3D();
        vp.getMultiTransformGroup().getTransformGroup(0).getTransform(t3doriginal);
        Transform3D ourOriginal = new Transform3D();
        GlobeViewTest.assertFalse((boolean)ourOriginal.equals(t3doriginal));
        int lonlocation = (this.view.m_leftLongitude + this.view.m_rightLongitude) / 2;
        int latlocation = (this.view.m_upperLatitude + this.view.m_lowerLatitude) / 2;
        Point3d eye = new Point3d(10000.0 * Math.cos(this.view.deg2rad(lonlocation)) * Math.cos(this.view.deg2rad(latlocation)), 10000.0 * Math.sin(this.view.deg2rad(latlocation)), -10000.0 * Math.cos(this.view.deg2rad(latlocation)) * Math.sin(this.view.deg2rad(lonlocation)));
        Point3d center = new Point3d(0.0, 0.0, 0.0);
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        ourOriginal.lookAt(eye, center, up);
        ourOriginal.invert();
        GlobeViewTest.assertEquals((Object)ourOriginal, (Object)t3doriginal);
    }

    public void testPluginMenus() throws Exception {
        GlobeViewTest.assertEquals((int)4, (int)this.view.getJMenuBar().getComponentCount());
        GlobeViewTest.assertEquals((String)"Viewer", (String)this.view.getJMenuBar().getMenu(1).getText());
        JMenu objectsMenu = this.view.getJMenuBar().getMenu(2);
        GlobeViewTest.assertEquals((String)"Objects", (String)objectsMenu.getText());
        GlobeViewTest.assertEquals((int)1, (int)objectsMenu.getMenuComponentCount());
        GlobeViewTest.assertEquals((String)"TOP", (String)((JMenuItem)objectsMenu.getMenuComponent(0)).getText());
        JMenu extensionsMenu = this.view.getJMenuBar().getMenu(3);
        GlobeViewTest.assertEquals((String)"Extensions", (String)extensionsMenu.getText());
        GlobeViewTest.assertEquals((int)1, (int)extensionsMenu.getMenuComponentCount());
        GlobeViewTest.assertEquals((String)"TAP", (String)((JMenuItem)extensionsMenu.getMenuComponent(0)).getText());
    }

    public void testViewerMenuMultipleViews() throws Exception {
        this.view = new GlobeView();
        GlobeViewTest.assertEquals((int)3, (int)this.view.getJMenuBar().getComponentCount());
        JMenu menu = this.view.getJMenuBar().getMenu(1);
        GlobeViewTest.assertEquals((String)"Viewer", (String)menu.getText());
        GlobeViewTest.assertEquals((int)7, (int)menu.getMenuComponentCount());
        GlobeViewTest.assertTrue((boolean)menu.isTopLevelMenu());
        Component c = menu.getMenuComponent(2);
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)c;
        GlobeViewTest.assertEquals((String)"Multiple Views", (String)item.getText());
    }

    public void testPluginGUIs() throws Exception {
        GlobeViewTest.assertEquals((int)4, (int)this.view.getJMenuBar().getMenuCount());
        JMenu menu = this.view.getJMenuBar().getMenu(3);
        GlobeViewTest.assertEquals((String)"Extensions", (String)menu.getText());
        JMenuItem menuItem = (JMenuItem)menu.getMenuComponent(0);
        menuItem.setSelected(true);
        GlobeViewTest.assertEquals((String)"TAP", (String)menuItem.getText());
        ActionEvent e = new ActionEvent(menuItem, 0, menuItem.getText());
        this.view.actionPerformed(e);
        JTabbedPane tabPane = this.view.pluginTabPane;
        GlobeViewTest.assertEquals((String)"TAP", (String)tabPane.getTitleAt(0));
    }

    public void testConstructor() throws Exception {
        ViewRange nonSoCalViewRange = new ViewRange(30, 38, -120, -112);
        this.view = new GlobeView(TestingPluginHandler.getInstance(), nonSoCalViewRange);
        this.checkNonSoCalLatLon();
        GlobeViewTest.assertEquals((String)TestingPluginHandler.getInstance().getClass().getName(), (String)this.view.getPluginHandler().getClass().getName());
        this.view = new GlobeView(TestingPluginHandler.getInstance(), null);
        this.checkSoCalLatLon();
        GlobeViewTest.assertEquals((String)TestingPluginHandler.getInstance().getClass().getName(), (String)this.view.getPluginHandler().getClass().getName());
        this.checkSoCalLatLon();
    }

    private void checkNonSoCalLatLon() {
        GlobeViewTest.assertEquals((int)38, (int)this.view.m_upperLatitude);
        GlobeViewTest.assertEquals((int)30, (int)this.view.m_lowerLatitude);
        GlobeViewTest.assertEquals((int)-120, (int)this.view.m_leftLongitude);
        GlobeViewTest.assertEquals((int)-112, (int)this.view.m_rightLongitude);
    }

    private void checkSoCalLatLon() {
        GlobeViewTest.assertEquals((int)36, (int)this.view.m_upperLatitude);
        GlobeViewTest.assertEquals((int)32, (int)this.view.m_lowerLatitude);
        GlobeViewTest.assertEquals((int)-122, (int)this.view.m_leftLongitude);
        GlobeViewTest.assertEquals((int)-114, (int)this.view.m_rightLongitude);
    }

    public void testChangeGridDisplay() throws Exception {
        this.view.changeGridDisplay();
        GlobeViewTest.assertEquals((boolean)false, (boolean)this.view.getGridDisplayBool());
        GlobeViewTest.assertEquals((int)0, (int)this.view.getDLod().numSwitches());
        GlobeViewTest.assertEquals((int)-1, (int)this.view.getSwitchNode().getWhichChild());
    }

    public void testResetView() throws Exception {
        this.view.resetView();
        GlobeViewTest.assertEquals((double)new Transform3D().determinant(), (double)this.view.getGeoNavObject().getViewPlatformHomeTransform().determinant(), (double)0.0);
    }

    public void testKeyboardShortcuts() throws Exception {
        JMenu file = this.view.getJMenuBar().getMenu(0);
        GlobeViewTest.assertEquals((String)"File", (String)file.getText());
        JMenuItem save = (JMenuItem)file.getMenuComponent(0);
        GlobeViewTest.assertEquals((int)KeyStroke.getKeyStroke(83, 3).getKeyCode(), (int)save.getAccelerator().getKeyCode());
        GlobeViewTest.assertEquals((int)KeyStroke.getKeyStroke(83, 3).getModifiers(), (int)save.getAccelerator().getModifiers());
        JMenuItem close = (JMenuItem)file.getMenuComponent(2);
        GlobeViewTest.assertEquals((int)KeyStroke.getKeyStroke(67, 3).getKeyCode(), (int)close.getAccelerator().getKeyCode());
        GlobeViewTest.assertEquals((int)KeyStroke.getKeyStroke(67, 3).getModifiers(), (int)close.getAccelerator().getModifiers());
        JMenu viewer = this.view.getJMenuBar().getMenu(1);
        JMenuItem grid = (JMenuItem)viewer.getMenuComponent(1);
        GlobeViewTest.assertEquals((int)KeyStroke.getKeyStroke(71, 3).getKeyCode(), (int)grid.getAccelerator().getKeyCode());
        GlobeViewTest.assertEquals((int)KeyStroke.getKeyStroke(71, 3).getModifiers(), (int)grid.getAccelerator().getModifiers());
    }

    public void testCloseAction() throws Exception {
        this.view.closeGlobeView();
        GlobeViewTest.assertNull((Object)this.view.getUniverse());
    }

    public void testGetBackgroundGridColor() throws Exception {
        Color3f newColor = new Color3f(65.0f, 125.0f, 160.0f);
        this.view.changeBackgroundColorForStateRestoration(newColor);
        GlobeViewTest.assertEquals((String)newColor.toString(), (String)this.view.getBackgroundColor().toString());
        this.view.changeGridColorForStateRestoration(newColor);
        GlobeViewTest.assertEquals((String)newColor.toString(), (String)this.view.getGridColor().toString());
    }
}

