/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.gui.viewer;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;

public class RenderEnabledCanvas3D
extends Canvas3D {
    private static final long serialVersionUID = 1L;
    public boolean writeJPEG_ = false;
    public boolean DONE_WITH_FRAME = true;
    private boolean sync;
    private int postSwapCount_ = 0;
    private BufferedImage[] frameBuffer;
    private Vector imageBufVector;

    public RenderEnabledCanvas3D(GraphicsConfiguration gc) {
        super(gc);
    }

    public void preRender() {
        if (this.writeJPEG_) {
            this.DONE_WITH_FRAME = false;
        }
    }

    public synchronized void postSwap() {
        if (this.writeJPEG_) {
            System.out.println("Writing Capture" + this.postSwapCount_ + ".jpg");
            GraphicsContext3D ctx = this.getGraphicsContext3D();
            Dimension SCREEN_SIZE = this.getSize();
            Raster ras = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, new Point(0, 0), SCREEN_SIZE, new ImageComponent2D(1, new BufferedImage((int)SCREEN_SIZE.getWidth(), (int)SCREEN_SIZE.getHeight(), 1)), null);
            ctx.readRaster(ras);
            BufferedImage img = ras.getImage().getImage();
            try {
                FileOutputStream out = new FileOutputStream("Capture" + this.postSwapCount_ + ".jpg");
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(img);
                param.setQuality(1.0f, false);
                encoder.setJPEGEncodeParam(param);
                encoder.encode(img);
                out.close();
            }
            catch (IOException e) {
                System.out.println("I/O exception!");
            }
            ++this.postSwapCount_;
            this.DONE_WITH_FRAME = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void forceRender() throws InterruptedException {
        while (!this.DONE_WITH_FRAME) {
            ((Object)((Object)this)).wait();
        }
    }

    public int getPostSwapCount() {
        return this.postSwapCount_;
    }

    public Vector getVector() {
        return this.imageBufVector;
    }
}

