/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.mod.behavior.viewer;

import java.awt.event.MouseEvent;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.scec.geo3d.mod.behavior.viewer.G3DRotationChangeListener;
import org.scec.geo3d.mod.behavior.viewer.Geo3DMouseBehavior;
import org.scec.geo3d.mod.behavior.viewer.util.Euler;

public class G3DMouseRotate
extends Geo3DMouseBehavior {
    protected double m_FactorX = 0.001;
    protected double m_FactorY = 0.001;
    protected Transform3D m_TransformX = null;
    protected Transform3D m_TransformY = null;
    protected boolean m_bInvert = false;

    public G3DMouseRotate(double xf, double yf) {
        this.m_FactorX = xf;
        this.m_FactorY = yf;
        this.m_TransformX = new Transform3D();
        this.m_TransformY = new Transform3D();
        this.m_bInvert = false;
    }

    protected boolean isStartBehaviorEvent(MouseEvent evt) {
        int nId = evt.getID();
        return nId == 506 && !evt.isAltDown() && !evt.isMetaDown();
    }

    public void setInvert(boolean bInvert) {
        this.m_bInvert = bInvert;
    }

    protected boolean isRelativeToObjectCoordinates() {
        return false;
    }

    protected void applyVectorToObject(Vector3f vector) {
        TransformGroup tg = this.getTransformGroup();
        double x_angle = (double)vector.y * this.m_FactorX;
        double y_angle = (double)vector.x * this.m_FactorY;
        if (this.m_rotateX && this.m_rotateY && !this.m_firstPass) {
            if (Math.abs(x_angle) >= Math.abs(y_angle)) {
                this.m_rotateY = false;
            } else {
                this.m_rotateX = false;
            }
        }
        this.m_firstPass = false;
        Transform3D m_Transform3D = new Transform3D();
        Vector3f originalVector = new Vector3f(0.0f, 0.0f, 0.0f);
        tg.getTransform(m_Transform3D);
        m_Transform3D.get(originalVector);
        Vector3f rotateVector = new Vector3f(vector);
        if (this.m_rotateX) {
            rotateVector = new Vector3f(1.0f * vector.y, 0.0f * vector.x, 0.0f * vector.z);
        }
        if (this.m_rotateY) {
            rotateVector = new Vector3f(0.0f * vector.y, 1.0f * vector.x, 0.0f * vector.z);
        }
        tg.getTransform(m_Transform3D);
        if (rotateVector.x != 0.0f) {
            Transform3D m_TransformX = new Transform3D();
            m_TransformX.rotX((double)rotateVector.x);
            m_Transform3D.mul(m_TransformX, m_Transform3D);
        }
        if (rotateVector.y != 0.0f) {
            Transform3D m_TransformY = new Transform3D();
            Transform3D temp = new Transform3D();
            Vector3d yAxis = new Vector3d(0.0, 1.0, 0.0);
            Vector3d newYAxis = new Vector3d();
            m_Transform3D.transform(yAxis, newYAxis);
            AxisAngle4d axis = new AxisAngle4d(newYAxis, y_angle);
            temp.setRotation(axis);
            m_Transform3D.mul(temp, m_Transform3D);
        }
        tg.setTransform(m_Transform3D);
        if (this.m_Listener != null) {
            Point3d rotate = Euler.getEulerRotation(m_Transform3D);
            ((G3DRotationChangeListener)this.m_Listener).onRotate(this.m_Object, rotate);
        }
    }
}

