/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.mod.behavior.viewer;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Sphere;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;
import org.scec.geo3d.gui.MainWindow;
import org.scec.geo3d.mod.behavior.viewer.picking.PickBehavior;
import org.scec.geo3d.tools.plugin.Geo3dInfo;

public class GeoNav
extends ViewPlatformBehavior
implements MouseListener,
MouseMotionListener {
    private final Vector3d ORIG_FOCALPOINT = new Vector3d(0.0, 0.0, -3611.0);
    private int sum = 0;
    private final int TIMER_DELAY = 50;
    private final int BORDER_SIZE = 10;
    private double ROT_AMT;
    private double MOVE_STEP;
    private double KEY_ROT = 0.08726646259971647;
    private double KEY_STEP = 20.0;
    private double AVG_RADIUS = 6367.4475;
    private boolean movRot = false;
    private float MOUSE_STEP = 4.0f;
    private float rootDivisible = 100.0f;
    private Vector3d FWD = new Vector3d(0.0, 0.0, -this.MOVE_STEP);
    private Vector3d BACK = new Vector3d(0.0, 0.0, this.MOVE_STEP);
    private Vector3d LEFT = new Vector3d(-this.MOVE_STEP, 0.0, 0.0);
    private Vector3d RIGHT = new Vector3d(this.MOVE_STEP, 0.0, 0.0);
    private Vector3d UP = new Vector3d(0.0, this.MOVE_STEP, 0.0);
    private Vector3d DOWN = new Vector3d(0.0, -this.MOVE_STEP, 0.0);
    private Vector3d kFWD = new Vector3d(0.0, 0.0, -this.KEY_STEP);
    private Vector3d kBACK = new Vector3d(0.0, 0.0, this.KEY_STEP);
    private Vector3d kLEFT = new Vector3d(-this.KEY_STEP, 0.0, 0.0);
    private Vector3d kRIGHT = new Vector3d(this.KEY_STEP, 0.0, 0.0);
    private Vector3d kUP = new Vector3d(0.0, this.KEY_STEP, 0.0);
    private Vector3d kDOWN = new Vector3d(0.0, -this.KEY_STEP, 0.0);
    private Matrix4d kElev = new Matrix4d();
    protected Object m_Object = null;
    protected float xTemp = 0.0f;
    protected float yTemp = 0.0f;
    protected double zoom_Restrict = 5.0;
    protected Vector3d camPos = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d focalPoint = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d fp_cp_distance = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d fp_ce_distance = new Vector3d(0.0, 0.0, 0.0);
    protected boolean m_bDragging = false;
    protected boolean m_zrot = false;
    protected boolean rootAboot = false;
    protected boolean firstPersonPerspective = false;
    protected WakeupOr m_MouseCriterion = null;
    protected int m_nLastY = 0;
    protected int m_nLastX = 0;
    private double distX = 0.0;
    private double distY = 0.0;
    protected boolean xMove = false;
    protected boolean yMove = false;
    protected boolean xPrimaryMove = false;
    protected boolean yPrimaryMove = false;
    protected boolean m_firstPass = true;
    private boolean fullscreen = false;
    private boolean gridDisplay = true;
    private Dimension canvasSize = new Dimension();
    private int xwBorder = 10;
    private int xeBorder = 0;
    private int ynBorder = 10;
    private int ysBorder = 0;
    private int xCenter = 5;
    private int yCenter = 5;
    private int larger = 0;
    private int smaller = 1;
    private int forwardKey = 38;
    private int backKey = 40;
    private int leftKey = 37;
    private int rightKey = 39;
    private int esc = 27;
    private int space = 32;
    private int elevate = 82;
    private int delevate = 70;
    private int z_rot = 90;
    private int strafeL = 65;
    private int strafeR = 68;
    private int forMove = 87;
    private int backMove = 83;
    private int rootAbootToggle = 79;
    private int fpSphereToggle = 80;
    private int zUp = 85;
    private int zDown = 74;
    private Transform3D t3d = new Transform3D();
    private Transform3D toElev = new Transform3D();
    private Transform3D toMove = new Transform3D();
    private Transform3D toRot = new Transform3D();
    private Transform3D rot3d = new Transform3D();
    private Transform3D rotz3d = new Transform3D();
    private Transform3D trans = new Transform3D();
    private Transform3D original = new Transform3D();
    private boolean isPressed = false;
    private boolean inBounds = true;
    private MouseEvent prev_ME = null;
    public GNThread t;
    private Graphics drawGraphix;
    private boolean isDrawMode = false;
    private int start_x;
    private int end_x;
    private int start_y;
    private int end_y;
    private boolean mouseDown = true;
    private boolean boxDrawn = false;
    private static final Color TRANSPARENT = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private Image screenshot;
    private static Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.mod.behavior.viewer.GeoNav");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public GeoNav() {
        this.focalPoint.set((Tuple3d)this.ORIG_FOCALPOINT);
        this.m_bDragging = false;
    }

    public void initialize() {
        Transform3D temp = new Transform3D();
        this.getViewingPlatform().getViewPlatformTransform().getTransform(temp);
        this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0).getTransform(this.original);
        this.setHomeTransform(temp);
        WakeupCriterion[] mouseEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(502), new WakeupOnAWTEvent(401)};
        this.t = new GNThread();
        this.t.setGeoNav(this);
        this.t.start();
        this.m_MouseCriterion = new WakeupOr(mouseEvents);
        this.wakeupOn((WakeupCondition)this.m_MouseCriterion);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            int i = 0;
            while (i < event.length) {
                if (event[i].getID() == 506) {
                    MouseEvent evt = (MouseEvent)event[i];
                    this.processMouse(evt, evt.getX(), evt.getY());
                }
                if (event[i].getID() == 502) {
                    this.onEndDrag();
                }
                if (event[i].getID() == 401) {
                    this.processKeyEvent((KeyEvent)event[i]);
                }
                ++i;
            }
        }
        this.wakeupOn((WakeupCondition)this.m_MouseCriterion);
    }

    private void processKeyEvent(KeyEvent eventKey) {
        int keyCode = eventKey.getKeyCode();
        if (keyCode == 16) {
            if (!this.isDrawMode) {
                this.isDrawMode = true;
                Geo3dInfo.getActiveViewer().turnDrawModeOff();
                Geo3dInfo.getActiveViewer().setMessage("Draw mode on: Mouse to select, ENTER to zoom");
            } else {
                this.isDrawMode = false;
                Geo3dInfo.getActiveViewer().setMessage("Status: Ready.");
                Geo3dInfo.getActiveViewer().turnDrawModeOn();
                Geo3dInfo.getCanvas().repaint();
                this.screenshot = null;
            }
        } else if (keyCode == 10) {
            if (this.boxDrawn) {
                PickBehavior pickery = Geo3dInfo.getActiveViewer().getPickBehavior();
                pickery.boxZoom(this.start_x, this.start_y, this.end_x, this.end_y);
                this.boxDrawn = false;
            }
        } else if (eventKey.isAltDown()) {
            this.altMove(keyCode);
        } else if (keyCode == this.esc) {
            this.resetView();
        } else if (keyCode == this.space) {
            this.fullScreen();
        } else {
            this.standardMove(keyCode);
        }
        if (MainWindow.isNavMade()) {
            MainWindow.getNavArrow().startAnim();
        }
    }

    public void testKeyEvent(KeyEvent eventKey) {
        this.processKeyEvent(eventKey);
    }

    protected boolean isStartBehaviorEvent(MouseEvent evt) {
        boolean inBounds = this.isInBounds(evt);
        return evt.getID() == 506;
    }

    private boolean isInBounds(MouseEvent evt) {
        int xpos = evt.getX();
        int ypos = evt.getY();
        return xpos <= this.xwBorder || xpos >= this.xeBorder || ypos <= this.ynBorder || ypos >= this.ysBorder;
    }

    private boolean isInYBounds(int ypos) {
        return ypos > this.ynBorder && ypos < this.ysBorder;
    }

    private boolean isInXBounds(int xpos) {
        return xpos > this.xwBorder && xpos < this.xeBorder;
    }

    protected boolean isStopBehaviorEvent(MouseEvent evt) {
        int mask1 = 16;
        System.out.println("iSB" + ((evt.getModifiersEx() & mask1) != mask1));
        return (evt.getModifiersEx() & mask1) != mask1;
    }

    public void processMouse(MouseEvent eventMouse, int xpos, int ypos) {
        if (!this.isDrawMode) {
            int mask1 = 1024;
            int mask2 = 2048;
            int mask3 = 4096;
            this.stopThread();
            int keyCode = (eventMouse.getModifiersEx() & mask1) == mask1 ? 1 : ((eventMouse.getModifiersEx() & mask2) == mask2 ? 2 : ((eventMouse.getModifiersEx() & mask3) == mask3 ? 3 : 0));
            int temp = eventMouse.getModifiersEx();
            if (!this.firstPersonPerspective) {
                if (keyCode == 3) {
                    this.transMove(xpos, ypos);
                } else if (keyCode == 2) {
                    this.zoomMove(xpos, ypos);
                } else if (keyCode == 1 && !eventMouse.isAltDown()) {
                    if (!this.movRot) {
                        this.rootAbootFoocalPoont(xpos, ypos);
                    } else {
                        this.moveRot(xpos, ypos);
                    }
                }
            } else if (keyCode == 1 && !eventMouse.isAltDown()) {
                this.moveRot(xpos, ypos);
            }
            if (keyCode == 1 && eventMouse.isAltDown()) {
                this.roll(xpos, ypos);
            }
            this.prev_ME = eventMouse;
            if (!this.inBounds && keyCode == 1) {
                this.t.setMouseEvent(this.prev_ME);
                this.wakeMeUp();
            }
            if (MainWindow.isNavMade()) {
                MainWindow.getNavArrow().startAnim();
            }
        }
    }

    protected void onEndDrag() {
        this.m_bDragging = false;
        this.stopThread();
    }

    private void initializeMovement(int xpos, int ypos) {
        this.m_nLastY = ypos;
        this.m_nLastX = xpos;
        this.m_bDragging = true;
    }

    private void moveRot(int xpos, int ypos) {
        this.updateMouseCoordDeltas(xpos, ypos);
        float movedivisibleX = 0.005f * ((float)Math.abs(xpos - this.xCenter) / (float)this.xCenter);
        float movedivisibleY = 0.005f * ((float)Math.abs(ypos - this.yCenter) / (float)this.yCenter);
        float radiansX = -this.xTemp * movedivisibleX;
        float radiansY = -this.yTemp * movedivisibleY;
        System.out.println("mov:" + movedivisibleX + "," + movedivisibleY);
        System.out.println("rad:" + radiansX + "," + radiansY);
        this.m_nLastX = xpos;
        this.m_nLastY = ypos;
        this.targetTG.getTransform(this.t3d);
        this.toRot.rotY((double)radiansX);
        this.rot3d.rotX((double)radiansY);
        this.t3d.mul(this.rot3d);
        this.t3d.mul(this.toRot);
        this.targetTG.setTransform(this.t3d);
        this.setFocalPointinFront();
    }

    private void setFocalPointinFront() {
        this.updateFP_CPdistance();
        this.targetTG.getTransform(this.t3d);
        Matrix4f m4 = new Matrix4f();
        this.t3d.get(m4);
        double length = this.fp_cp_distance.length();
        this.setFocalPoint(new Vector3d(length * (double)(-m4.m02) + this.camPos.x, length * (double)(-m4.m12) + this.camPos.y, length * (double)(-m4.m22) + this.camPos.z));
    }

    private void roll(int xpos, int ypos) {
        this.updateMouseCoordDeltas(xpos, ypos);
        float radiansY = -this.yTemp / 1000.0f;
        this.m_nLastX = xpos;
        this.m_nLastY = ypos;
        this.targetTG.getTransform(this.t3d);
        this.rotz3d.rotZ((double)radiansY);
        this.t3d.mul(this.rotz3d);
        this.targetTG.setTransform(this.t3d);
    }

    private void rootAbootFoocalPoont(int xpos, int ypos) {
        if (!this.m_bDragging) {
            this.initializeMovement(xpos, ypos);
        }
        this.updateFP_CPdistance();
        this.yTemp = ypos - this.m_nLastY;
        this.xTemp = xpos - this.m_nLastX;
        this.rootDivisible = 100.0f;
        float radiansX = -this.xTemp / this.rootDivisible;
        float radiansY = -this.yTemp / this.rootDivisible;
        this.m_nLastX = xpos;
        this.m_nLastY = ypos;
        this.targetTG.getTransform(this.t3d);
        Matrix4d mat = new Matrix4d();
        this.t3d.get(mat);
        Vector3d v_up = new Vector3d(mat.m01, mat.m11, mat.m21);
        this.MOVE_STEP = this.fp_cp_distance.length();
        this.setMove();
        this.trans.setTranslation(this.FWD);
        this.t3d.mul(this.trans);
        this.toRot.rotY((double)radiansX);
        this.rot3d.rotX((double)radiansY);
        this.t3d.mul(this.rot3d);
        this.t3d.mul(this.toRot);
        this.setMove();
        this.trans.setTranslation(this.BACK);
        this.t3d.mul(this.trans);
        this.t3d.get(this.camPos);
        this.t3d.lookAt(new Point3d((Tuple3d)this.camPos), new Point3d((Tuple3d)this.focalPoint), v_up);
        this.t3d.invert();
        this.targetTG.setTransform(this.t3d);
    }

    private void updateFP_CPdistance() {
        this.fp_cp_distance.sub((Tuple3d)this.focalPoint, (Tuple3d)this.camPos);
    }

    private void transMove(int xpos, int ypos) {
        this.updateMouseCoordDeltas(xpos, ypos);
        this.updateFP_CPdistance();
        if (this.isInYBounds(ypos)) {
            this.MOVE_STEP = Math.abs(this.calcScaleFactor(ypos, this.m_nLastY, 0.2));
        }
        this.setMove();
        this.targetTG.getTransform(this.t3d);
        Matrix4d mat = new Matrix4d();
        this.t3d.get(mat);
        Vector3d v_up = new Vector3d(mat.m01, mat.m11, mat.m21);
        if (this.yTemp < 0.0f) {
            this.toMove.setTranslation(this.DOWN);
        } else {
            this.toMove.setTranslation(this.UP);
        }
        this.t3d.mul(this.toMove);
        this.targetTG.setTransform(this.t3d);
        this.targetTG.getTransform(this.t3d);
        if (this.isInXBounds(xpos)) {
            this.MOVE_STEP = Math.abs(this.calcScaleFactor(xpos, this.m_nLastX, 0.2));
        }
        this.setMove();
        if (this.xTemp < 0.0f) {
            this.toMove.setTranslation(this.RIGHT);
        } else {
            this.toMove.setTranslation(this.LEFT);
        }
        this.t3d.mul(this.toMove);
        this.targetTG.setTransform(this.t3d);
        this.t3d.get(this.camPos);
        this.focalPoint.add((Tuple3d)this.camPos, (Tuple3d)this.fp_cp_distance);
        this.t3d.lookAt(new Point3d((Tuple3d)this.camPos), new Point3d((Tuple3d)this.focalPoint), v_up);
        this.t3d.invert();
        this.targetTG.setTransform(this.t3d);
        this.m_nLastX = xpos;
        this.m_nLastY = ypos;
    }

    private void updateMouseCoordDeltas(int xpos, int ypos) {
        boolean yChange = true;
        boolean xChange = true;
        this.inBounds = false;
        if (xpos <= this.xwBorder) {
            xChange = false;
        } else if (xpos >= this.xeBorder) {
            xChange = false;
        } else {
            this.stopThread();
            this.inBounds = true;
        }
        if (ypos <= this.ynBorder) {
            yChange = false;
            this.inBounds = false;
        } else if (ypos >= this.ysBorder) {
            yChange = false;
            this.inBounds = false;
        } else {
            this.stopThread();
            if (xChange) {
                this.inBounds = true;
            }
        }
        if (!this.m_bDragging) {
            this.initializeMovement(xpos, ypos);
        }
        if (yChange) {
            this.yTemp = ypos - this.m_nLastY;
        }
        if (xChange) {
            this.xTemp = xpos - this.m_nLastX;
        }
    }

    private void zoomMove(int xpos, int ypos) {
        if (!this.m_bDragging) {
            this.initializeMovement(xpos, ypos);
        }
        this.updateFP_CPdistance();
        double tempMove = this.calcScaleFactor(ypos, this.m_nLastY, 1.0);
        this.m_nLastX = xpos;
        this.m_nLastY = ypos;
        this.MOVE_STEP = Math.abs(tempMove);
        this.setMove();
        if (tempMove >= 0.0) {
            this.movRot = false;
            this.doMove(this.BACK);
            this.setFocalPointinFront();
        } else if (!this.isCameraPastFocalPoint()) {
            this.doMove(this.FWD);
            this.targetTG.getTransform(this.t3d);
        } else {
            this.movRot = true;
            this.targetTG.getTransform(this.t3d);
            Matrix4d mat = new Matrix4d();
            this.t3d.get(mat);
            Vector3d v_up = new Vector3d(mat.m01, mat.m11, mat.m21);
            this.toMove.setTranslation(this.FWD);
            this.t3d.mul(this.toMove);
            this.t3d.get(this.camPos);
            this.focalPoint.add((Tuple3d)this.camPos, (Tuple3d)this.fp_cp_distance);
            this.t3d.lookAt(new Point3d((Tuple3d)this.camPos), new Point3d((Tuple3d)this.focalPoint), v_up);
            this.t3d.invert();
            this.targetTG.setTransform(this.t3d);
        }
        this.t3d.get(this.camPos);
    }

    private double calcScaleFactor(int pos, int m_nLast, double scale) {
        double distance = this.calcDistance();
        double tempMove = (Math.abs(distance) + 1000.0) / 1000.0 * (double)(pos - m_nLast) * scale;
        return tempMove;
    }

    private double calcDistance() {
        double radius = Geo3dInfo.getActiveViewer().getEqRad();
        Transform3D starting = new Transform3D();
        Geo3dInfo.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0).getTransform(starting);
        Vector3d startingLoc = new Vector3d();
        starting.get(startingLoc);
        Matrix3d startingMatrix = new Matrix3d();
        starting.get(startingMatrix);
        Transform3D movement = new Transform3D();
        Geo3dInfo.getViewingPlatform().getViewPlatformTransform().getTransform(movement);
        Vector3d movementLoc = new Vector3d();
        movement.get(movementLoc);
        movementLoc.set(movementLoc.x * startingMatrix.m00 + movementLoc.y * startingMatrix.m01 + movementLoc.z * startingMatrix.m02, movementLoc.x * startingMatrix.m10 + movementLoc.y * startingMatrix.m11 + movementLoc.z * startingMatrix.m12, movementLoc.x * startingMatrix.m20 + movementLoc.y * startingMatrix.m21 + movementLoc.z * startingMatrix.m22);
        movementLoc.set(startingLoc.x + movementLoc.x, startingLoc.y + movementLoc.y, startingLoc.z + movementLoc.z);
        double distance = movementLoc.length() - radius;
        return distance;
    }

    public void setFocusOnMe(Point3d newFocus) {
        Transform3D matx = new Transform3D();
        Transform3D mat0 = new Transform3D();
        Vector3d oldFocalPoint = new Vector3d(this.focalPoint);
        Geo3dInfo.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0).getTransform(matx);
        mat0.set(matx);
        matx.setTranslation(new Vector3d((Tuple3d)newFocus));
        mat0.invert();
        mat0.mul(matx);
        mat0.get(this.focalPoint);
        oldFocalPoint.sub((Tuple3d)this.focalPoint);
        oldFocalPoint.negate();
        this.targetTG.getTransform(this.t3d);
        Matrix4d mat = new Matrix4d();
        this.t3d.get(mat);
        Vector3d v_up = new Vector3d(mat.m01, mat.m11, mat.m21);
        this.t3d.get(this.camPos);
        this.camPos.add((Tuple3d)this.camPos, (Tuple3d)oldFocalPoint);
        this.t3d.lookAt(new Point3d((Tuple3d)this.camPos), new Point3d((Tuple3d)this.focalPoint), v_up);
        this.t3d.invert();
        this.targetTG.setTransform(this.t3d);
    }

    private void rotateY(double radians) {
        this.targetTG.getTransform(this.t3d);
        this.toRot.rotY(radians);
        this.t3d.mul(this.toRot);
        this.targetTG.setTransform(this.t3d);
    }

    private void rotateX(double radians) {
        this.targetTG.getTransform(this.t3d);
        this.toRot.rotX(radians);
        this.t3d.mul(this.toRot);
        this.targetTG.setTransform(this.t3d);
    }

    private void doMove(Vector3d theMove) {
        this.targetTG.getTransform(this.t3d);
        this.toMove.setTranslation(theMove);
        this.t3d.mul(this.toMove);
        this.t3d.get(this.camPos);
        this.targetTG.setTransform(this.t3d);
    }

    private void updatecamPos() {
        this.targetTG.getTransform(this.t3d);
        this.t3d.get(this.camPos);
    }

    private void setMove() {
        this.FWD.set(0.0, 0.0, -this.MOVE_STEP);
        this.BACK.set(0.0, 0.0, this.MOVE_STEP);
        this.LEFT.set(-this.MOVE_STEP, 0.0, 0.0);
        this.RIGHT.set(this.MOVE_STEP, 0.0, 0.0);
        this.UP.set(0.0, this.MOVE_STEP, 0.0);
        this.DOWN.set(0.0, -this.MOVE_STEP, 0.0);
    }

    private void standardMove(int keycode) {
        if (keycode == this.forwardKey || keycode == this.forMove) {
            this.doMove(this.kFWD);
        } else if (keycode == this.backKey || keycode == this.backMove) {
            this.doMove(this.kBACK);
        } else if (keycode == this.leftKey) {
            this.rotateY(this.KEY_ROT);
        } else if (keycode == this.rightKey) {
            this.rotateY(-this.KEY_ROT);
        } else if (keycode == this.elevate && this.firstPersonPerspective) {
            this.targetTG.getTransform(this.t3d);
            this.t3d.get(this.kElev);
            double elem = this.kElev.getElement(2, 3) + this.KEY_STEP;
            this.kElev.setElement(2, 3, elem);
            this.t3d.set(this.kElev);
            this.targetTG.setTransform(this.t3d);
        } else if (keycode == this.delevate && this.firstPersonPerspective) {
            this.targetTG.getTransform(this.t3d);
            this.t3d.get(this.kElev);
            double elem = this.kElev.getElement(2, 3) - this.KEY_STEP;
            this.kElev.setElement(2, 3, elem);
            this.t3d.set(this.kElev);
            this.targetTG.setTransform(this.t3d);
        } else if (keycode == this.strafeL && this.firstPersonPerspective) {
            this.MOVE_STEP = this.KEY_STEP;
            this.setMove();
            this.toMove.setTranslation(this.LEFT);
            this.t3d.mul(this.toMove);
            this.targetTG.setTransform(this.t3d);
        } else if (keycode == this.strafeR && this.firstPersonPerspective) {
            this.MOVE_STEP = this.KEY_STEP;
            this.setMove();
            this.toMove.setTranslation(this.RIGHT);
            this.t3d.mul(this.toMove);
            this.targetTG.setTransform(this.t3d);
        } else if (keycode == this.fpSphereToggle) {
            Transform3D t3d = this.getFPinWC();
            TransformGroup txg = new TransformGroup();
            txg.setTransform(t3d);
            Appearance app = new Appearance();
            Material mat = new Material();
            app.setMaterial(mat);
            txg.addChild((Node)new Sphere(5.0f, 1, app));
            BranchGroup bg = new BranchGroup();
            bg.addChild((Node)txg);
            Geo3dInfo.getPluginBranchGroup().addChild((Node)bg);
        } else if (keycode == this.zUp) {
            this.rootDivisible += 15.0f;
            System.out.println("rootDivisible=" + this.rootDivisible);
        } else if (keycode == this.zDown) {
            this.rootDivisible -= 15.0f;
            System.out.println("rootDivisible=" + this.rootDivisible);
        }
    }

    private boolean isCameraPastFocalPoint() {
        if (this.fp_cp_distance.length() <= this.zoom_Restrict) {
            this.setFocalPointinFront();
            return true;
        }
        return false;
    }

    private Transform3D getFPinWC() {
        Transform3D t3d_ccm = new Transform3D();
        Transform3D t3d_fp = new Transform3D();
        Geo3dInfo.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0).getTransform(t3d_fp);
        this.targetTG.getTransform(t3d_ccm);
        t3d_ccm.setTranslation(this.focalPoint);
        t3d_fp.mul(t3d_ccm);
        return t3d_fp;
    }

    private void altMove(int keycode) {
        if (keycode == this.forwardKey) {
            this.doMove(this.kUP);
        } else if (keycode == this.backKey) {
            this.doMove(this.kDOWN);
        } else if (keycode == this.leftKey) {
            this.doMove(this.kLEFT);
        } else if (keycode == this.rightKey) {
            this.doMove(this.kRIGHT);
        }
    }

    private void fullScreen() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        if (this.fullscreen) {
            Geo3dInfo.getActiveViewer().resizeCanvas(screenSize, this.smaller);
            this.fullscreen = false;
        } else {
            Geo3dInfo.getActiveViewer().resizeCanvas(screenSize, this.larger);
            this.fullscreen = true;
        }
    }

    public boolean getFullScreen() {
        return this.fullscreen;
    }

    public void resetView() {
        Geo3dInfo.getActiveViewer().getMultiTransform().getTransformGroup(0).setTransform(this.original);
        this.goHome();
        this.updatecamPos();
        this.focalPoint.set((Tuple3d)this.ORIG_FOCALPOINT);
        this.updateFP_CPdistance();
        this.updateFPCEdistance();
        this.t3d.setIdentity();
        this.toElev.setIdentity();
        this.toMove.setIdentity();
        this.toRot.setIdentity();
        this.rot3d.setIdentity();
        this.rotz3d.setIdentity();
        this.trans.setIdentity();
    }

    public boolean getGridStatus() {
        return this.gridDisplay;
    }

    private void updateFPCEdistance() {
        Vector3d focalPoint_wc = new Vector3d();
        this.getFPinWC().get(focalPoint_wc);
        this.fp_ce_distance.sub((Tuple3d)focalPoint_wc, (Tuple3d)new Vector3d(0.0, 0.0, 0.0));
    }

    private boolean FPunderSurface() {
        return this.fp_ce_distance.length() < this.AVG_RADIUS;
    }

    public void updateCanvasSize() {
        this.canvasSize = Geo3dInfo.getActiveViewer().getCanvasMain().getSize();
        this.xCenter = (int)this.canvasSize.getWidth() / 2;
        this.yCenter = (int)this.canvasSize.getHeight() / 2;
        this.xeBorder = (int)this.canvasSize.getWidth() - 10;
        this.ysBorder = (int)this.canvasSize.getHeight() - 10;
    }

    public void mousePressed(MouseEvent e) {
        if (this.isDrawMode) {
            if (this.screenshot != null) {
                this.drawGraphix.drawImage(this.screenshot, 0, 0, null);
            }
            this.screenshot = this.grabScreenshot();
            this.drawGraphix = Geo3dInfo.getCanvas().getGraphics();
            this.start_x = e.getX();
            this.start_y = e.getY();
            this.mouseDown = true;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isDrawMode && this.mouseDown) {
            this.end_x = e.getX();
            this.end_y = e.getY();
            this.paint(this.drawGraphix);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isDrawMode) {
            boolean tmp = false;
            double midx = 0.0;
            double midy = 0.0;
            double dx = 0.0;
            this.mouseDown = false;
            this.end_x = e.getX();
            this.end_y = e.getY();
            this.boxDrawn = true;
        }
    }

    public void paint(Graphics g) {
        this.drawGraphix.drawImage(this.screenshot, 0, 0, null);
        if (this.mouseDown) {
            int rect_ey;
            int rect_sy;
            int rect_ex;
            int rect_sx;
            if (this.start_x < this.end_x) {
                rect_sx = this.start_x;
                rect_ex = this.end_x;
            } else {
                rect_sx = this.end_x;
                rect_ex = this.start_x;
            }
            if (this.start_y < this.end_y) {
                rect_sy = this.start_y;
                rect_ey = this.end_y;
            } else {
                rect_sy = this.end_y;
                rect_ey = this.start_y;
            }
            this.drawGraphix.setColor(Color.yellow);
            this.drawGraphix.drawRect(rect_sx, rect_sy, rect_ex - rect_sx, rect_ey - rect_sy);
        }
    }

    public Image grabScreenshot() {
        try {
            Canvas3D c = Geo3dInfo.getCanvas();
            Point ulCorner = Geo3dInfo.getCanvas().getLocationOnScreen();
            Rectangle size2 = new Rectangle(ulCorner.x, ulCorner.y, Geo3dInfo.getCanvas().getWidth(), Geo3dInfo.getCanvas().getHeight());
            Robot bot = new Robot();
            BufferedImage saveScreen = bot.createScreenCapture(size2);
            return saveScreen;
        }
        catch (AWTException e) {
            System.out.println("Exception in bot creation");
            return null;
        }
    }

    public void setScreenshot(Image s) {
        this.screenshot = s;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public synchronized void makeMeWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void wakeMeUp() {
        this.t.setWaiting(false);
        this.notifyAll();
    }

    public void stopThread() {
        this.t.setWaiting(true);
    }

    public Transform3D getViewPlatformHomeTransform() {
        Transform3D homeTransform = new Transform3D();
        this.getHomeTransform(homeTransform);
        return homeTransform;
    }

    public boolean isFirstPersonPerspective() {
        return this.firstPersonPerspective;
    }

    public void setFirstPersonPerspective(boolean firstPersonPerspective) {
        this.firstPersonPerspective = firstPersonPerspective;
        if (firstPersonPerspective) {
            this.movRot = false;
        }
    }

    public Vector3d getFocalPoint() {
        return this.focalPoint;
    }

    public void setFocalPoint(Vector3d focalPoint) {
        this.focalPoint = focalPoint;
    }

    private void drawMode() {
        this.drawGraphix = Geo3dInfo.getCanvas().getGraphics();
    }

    public void toggleDrawMode() {
        if (!this.isDrawMode) {
            this.isDrawMode = true;
            Geo3dInfo.getActiveViewer().turnDrawModeOff();
            Geo3dInfo.getActiveViewer().setMessage("Draw mode on: Mouse to select, ENTER to zoom");
        } else {
            this.isDrawMode = false;
            Geo3dInfo.getActiveViewer().turnDrawModeOn();
            Geo3dInfo.getActiveViewer().setMessage("Status: Ready.");
            Geo3dInfo.getCanvas().repaint();
            this.screenshot = null;
        }
    }

    class GNThread
    extends Thread {
        private GeoNav gn = null;
        private MouseEvent me = null;
        private int firstSleep = 100;
        private int continuousSleep = 10;
        private boolean isWaiting = true;
        private boolean firstStart = true;

        GNThread() {
        }

        public void setGeoNav(GeoNav gn) {
            this.gn = gn;
        }

        public void setMouseEvent(MouseEvent e) {
            this.me = e;
        }

        public boolean isWaiting() {
            return this.isWaiting;
        }

        public void setWaiting(boolean isWaiting) {
            this.isWaiting = isWaiting;
        }

        public void run() {
            while (true) {
                if (this.firstStart) {
                    try {
                        Thread.sleep(this.firstSleep);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    try {
                        Thread.sleep(this.continuousSleep);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                while (this.isWaiting) {
                    this.gn.makeMeWait();
                    this.firstStart = true;
                }
                if (this.me == null) continue;
                this.gn.processMouse(this.me, this.me.getX(), this.me.getY());
                this.firstStart = false;
            }
        }
    }
}

