/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.mod.behavior.viewer.picking;

import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class KeyFrame {
    private TCBKeyFrame frame;
    private Vector3d focalPoint;
    public int linearFlag = 0;
    public int splineFlag = 1;
    public Point3f scale = new Point3f(1.0f, 1.0f, 1.0f);
    public float tension = -0.5f;
    public float continuity = 0.0f;
    public float bias = 0.0f;

    public KeyFrame() {
        this.frame = null;
        this.focalPoint = null;
    }

    public KeyFrame(TCBKeyFrame frame, Vector3d focalPoint) {
        this.frame = frame;
        this.focalPoint = focalPoint;
    }

    public KeyFrame(Transform3D cam, Vector3d focalPoint) {
        this.setFrame(cam);
        this.focalPoint = focalPoint;
    }

    public boolean setAlpha(float knot) {
        if (knot < 0.0f || knot > 1.0f) {
            return false;
        }
        this.frame.knot = knot;
        return true;
    }

    public TCBKeyFrame getFrame() {
        return this.frame;
    }

    public void setFrame(TCBKeyFrame frame) {
        this.frame = frame;
    }

    public void setFrame(Transform3D cam) {
        Quat4f rot = new Quat4f();
        Vector3f pos = new Vector3f();
        float tempScale = cam.get(rot, pos);
        this.frame = new TCBKeyFrame(1.0f, this.linearFlag, new Point3f((Tuple3f)pos), rot, this.scale, this.tension, this.continuity, this.bias);
    }

    public Vector3d getFocalPoint() {
        return this.focalPoint;
    }

    public void setFocalPoint(Vector3d focalPoint) {
        this.focalPoint = focalPoint;
    }

    public String printString() {
        String newline = System.getProperty("line.separator");
        float[] tempArray = new float[3];
        float[] tempRotArray = new float[4];
        String str = "";
        if (this.frame == null || this.focalPoint == null) {
            return null;
        }
        str = String.valueOf(str) + this.frame.knot + newline;
        this.frame.position.get(tempArray);
        str = String.valueOf(str) + " " + tempArray[0] + " " + tempArray[1] + " " + tempArray[2] + newline;
        this.frame.quat.get(tempRotArray);
        str = String.valueOf(str) + " " + tempRotArray[0] + " " + tempRotArray[1] + " " + tempRotArray[2] + " " + tempRotArray[3] + newline;
        str = String.valueOf(str) + " " + this.frame.tension + " " + this.frame.continuity + " " + this.frame.bias + newline;
        str = String.valueOf(str) + " " + this.focalPoint.x + " " + this.focalPoint.y + " " + this.focalPoint.z;
        return str;
    }
}

