/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.mod.behavior.viewer.picking;

import com.sun.j3d.utils.behaviors.interpolators.RotPosScaleTCBSplinePathInterpolator;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.media.j3d.Alpha;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.Timer;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.scec.geo3d.mod.behavior.viewer.picking.KeyFrame;
import org.scec.geo3d.mod.behavior.viewer.picking.PickBehavior;
import org.scec.geo3d.tools.plugin.Geo3dInfo;

public class NavByPickScriptor
implements ActionListener {
    public static final int MULTI = 0;
    public static final int VIEW = 1;
    public BoundingSphere bounds;
    public File file;
    private boolean isNewFileType;
    protected File movieFile;
    private Transform3D Axis;
    private BranchGroup splineBG = new BranchGroup();
    private int duration = 20000;
    private Alpha animAlpha;
    private int isAlphaSet = 0;
    private int newAlphaSet = 0;
    private Transform3D temp3D;
    private Point3f tempP3f;
    private Vector3f tempV3f;
    private boolean isStopped;
    private int triggerTime = 0;
    private int phaseDelay = 0;
    private int rampDuration = 1000;
    private int flyTime = 3500;
    public static final int FORWARD = -1;
    public static final int FOWARD_REWIND = 1;
    protected RotPosScaleTCBSplinePathInterpolator splineInterpolator;
    private ArrayList keyframeList = new ArrayList();
    private Timer timer;
    private PickBehavior pickBehavior;
    private int type_tag;

    public NavByPickScriptor(PickBehavior pb, int tag) {
        this.type_tag = tag;
        this.pickBehavior = pb;
        this.bounds = new BoundingSphere(new Point3d(), 50000.0);
        this.Axis = new Transform3D();
        this.timer = new Timer(this.flyTime, this);
        this.timer.setRepeats(false);
        this.setupAnimationData();
    }

    private void setupAnimationData() {
        this.isStopped = true;
        this.isAlphaSet = 1;
        this.animAlpha = new Alpha(1, 3, (long)this.triggerTime, (long)this.phaseDelay, (long)this.flyTime, (long)this.rampDuration, 5000L, 0L, (long)this.rampDuration, 1000L);
    }

    public void flyTo() {
        this.resetInterpolator();
        this.splineInterpolator.setEnable(true);
        this.timer.start();
    }

    public void addKeyFrame(int i, Transform3D cam, Vector3d focalPoint) {
        KeyFrame nuFrame = new KeyFrame(cam, focalPoint);
        this.keyframeList.add(i, nuFrame);
    }

    private void resetInterpolator() {
        Date tempDate = new Date();
        this.animAlpha.setStartTime(tempDate.getTime());
        this.Axis = new Transform3D();
        this.timer = new Timer(this.flyTime, this);
        ViewingPlatform myPlatform = Geo3dInfo.getViewingPlatform();
        int size = this.keyframeList.size();
        float alphaval = 0.0f;
        int i = 0;
        while (i < size) {
            if (i == 0) {
                alphaval = 0.0f;
            } else if ((alphaval += 1.0f / (float)(size - 1)) > 0.9999f) {
                alphaval = 1.0f;
            }
            ((KeyFrame)this.keyframeList.get(i)).setAlpha(alphaval);
            ++i;
        }
        int index = myPlatform.indexOfChild((Node)this.splineBG);
        if (index != -1) {
            myPlatform.removeChild(index);
        }
        BranchGroup tempBG = this.type_tag == 0 ? this.createInterpolators(myPlatform.getMultiTransformGroup().getTransformGroup(0)) : this.createInterpolators(myPlatform.getViewPlatformTransform());
        myPlatform.addChild((Node)tempBG);
    }

    public BranchGroup createInterpolators(TransformGroup targetTG) {
        this.newAlphaSet = 0;
        if (this.isAlphaSet == 0) {
            this.setupAnimationData();
        }
        BranchGroup behaviorBranch = new BranchGroup();
        TCBKeyFrame frame0 = ((KeyFrame)this.keyframeList.get(0)).getFrame();
        this.tempP3f = new Point3f(frame0.position);
        this.tempV3f = new Vector3f(this.tempP3f.x, this.tempP3f.y, this.tempP3f.z);
        this.temp3D = new Transform3D(frame0.quat, this.tempV3f, 1.0f);
        targetTG.setTransform(this.temp3D);
        TCBKeyFrame[] keys = this.keyFramesToArray();
        this.animAlpha.setLoopCount(1);
        this.splineInterpolator = new RotPosScaleTCBSplinePathInterpolator(this.animAlpha, targetTG, this.Axis, keys);
        this.splineInterpolator.setSchedulingBounds((Bounds)this.bounds);
        behaviorBranch.addChild((Node)this.splineInterpolator);
        this.splineInterpolator.setEnable(false);
        behaviorBranch.setCapability(17);
        this.splineBG = behaviorBranch;
        return behaviorBranch;
    }

    private TCBKeyFrame[] keyFramesToArray() {
        TCBKeyFrame[] keys = new TCBKeyFrame[this.keyframeList.size()];
        int i = 0;
        while (i < keys.length) {
            keys[i] = ((KeyFrame)this.keyframeList.get(i)).getFrame();
            ++i;
        }
        return keys;
    }

    public float getAlphaValue() {
        return this.animAlpha.value();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.timer)) {
            this.splineInterpolator.setEnable(false);
            this.splineInterpolator.setAlpha(null);
            this.pickBehavior.resetTransforms();
            this.timer.stop();
            Geo3dInfo.getActiveViewer().getGeoNavObject().setScreenshot(Geo3dInfo.getActiveViewer().getGeoNavObject().grabScreenshot());
        }
    }
}

