/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.mod.behavior.viewer.picking;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.scec.geo3d.mod.behavior.viewer.GeoNav;
import org.scec.geo3d.mod.behavior.viewer.picking.NavByPickScriptor;
import org.scec.geo3d.tools.PointToLatLong;
import org.scec.geo3d.tools.plugin.Geo3dInfo;

public class PickBehavior
extends PickMouseBehavior {
    WakeupOnAWTEvent buttonPressed = new WakeupOnAWTEvent(16L);
    GeoNav navigator;
    private boolean allowNav = true;
    private Shape3D pickedShape = null;
    private PickResult pickResult = null;
    private double latitude;
    private double longitude;
    private double depth;
    private boolean isBoxMode = false;
    private Point3d intersectPoint;
    public static final int MULTI = 0;
    public static final int VIEW = 1;
    private NavByPickScriptor multi_scriptor = new NavByPickScriptor(this, 1);
    private NavByPickScriptor view_scriptor = new NavByPickScriptor(this, 0);
    private Transform3D t3d = new Transform3D();
    private Transform3D view_start = new Transform3D();
    private boolean isDrawMode = false;

    public PickBehavior(Canvas3D pickCanvas, BranchGroup pickRoot, Bounds pickBounds, GeoNav navigation) {
        super(pickCanvas, pickRoot, pickBounds);
        this.setSchedulingBounds(pickBounds);
        this.navigator = navigation;
        this.pickCanvas.setMode(256);
        this.setTolerance(0.0f);
    }

    public void processStimulus(Enumeration criteria) {
        MouseEvent theMouseEvent;
        WakeupOnAWTEvent theCriterion = (WakeupOnAWTEvent)criteria.nextElement();
        AWTEvent[] theEvents = theCriterion.getAWTEvent();
        if (theEvents[0].getID() == 502 && this.allowNav && (theMouseEvent = (MouseEvent)theEvents[0]).getModifiers() != 0 && theMouseEvent.getClickCount() > 1) {
            int xpos = theMouseEvent.getX();
            int ypos = theMouseEvent.getY();
            this.pickCanvas.setShapeLocation(xpos, ypos);
            try {
                this.pickResult = this.pickCanvas.pickClosest();
            }
            catch (NullPointerException e) {
                this.pickResult = null;
            }
            if (this.pickResult != null) {
                try {
                    this.pickedShape = (Shape3D)this.pickResult.getNode(1);
                }
                catch (ClassCastException e) {
                    System.out.println("Class cast exception");
                    this.pickedShape = null;
                }
            }
            if (this.pickedShape != null) {
                this.prepareScriptors();
                this.grabLocation();
                this.relocate(this.latitude, this.longitude, this.grabDistance(), false);
            }
        }
        this.wakeupOn((WakeupCondition)this.buttonPressed);
    }

    private void prepareScriptors() {
        this.view_start = new Transform3D();
        Vector3d focalPoint = new Vector3d(this.navigator.getFocalPoint());
        this.view_scriptor = new NavByPickScriptor(this, 1);
        this.navigator.getViewingPlatform().getViewPlatformTransform().getTransform(this.view_start);
        this.view_scriptor.addKeyFrame(0, this.view_start, focalPoint);
        this.multi_scriptor = new NavByPickScriptor(this, 0);
        Transform3D multi_start = new Transform3D();
        this.navigator.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0).getTransform(multi_start);
        this.multi_scriptor.addKeyFrame(0, multi_start, focalPoint);
    }

    public void grabLocation() {
        PickIntersection intersection = this.pickResult.getClosestIntersection(this.findCurrentLocation());
        this.intersectPoint = intersection.getPointCoordinates();
        this.latitude = PointToLatLong.PointToLat(this.intersectPoint);
        this.longitude = PointToLatLong.PointToLong(this.intersectPoint);
        this.depth = PointToLatLong.PointToAltitude(this.intersectPoint);
        if (!this.isBoxMode) {
            Geo3dInfo.getActiveViewer().setMessage("picked: latitude: " + (float)this.latitude + " longitude: " + (float)this.longitude + " depth: " + (float)this.depth);
        }
    }

    private Point3d findCurrentLocation() {
        Transform3D currentLoc = new Transform3D();
        this.navigator.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0).getTransform(currentLoc);
        Transform3D currentLoc2 = new Transform3D();
        this.navigator.getViewingPlatform().getViewPlatformTransform().getTransform(currentLoc2);
        currentLoc.add(currentLoc2);
        Vector3d locVector = new Vector3d();
        currentLoc.get(locVector);
        return new Point3d(locVector.x, locVector.y, locVector.z);
    }

    private void relocate(double latitude, double longitude, double distance, boolean boxwise) {
        double zoom;
        this.t3d = new Transform3D();
        double eqr = Geo3dInfo.getActiveViewer().getEqRad();
        if (!boxwise) {
            double a = 0.2;
            zoom = eqr + a * distance;
        } else {
            zoom = distance + eqr;
        }
        Point3d eye = new Point3d(zoom * Math.cos(this.deg2rad(longitude)) * Math.cos(this.deg2rad(latitude)), zoom * Math.sin(this.deg2rad(latitude)), zoom * Math.cos(this.deg2rad(latitude)) * Math.sin(this.deg2rad(longitude)));
        Point3d center = new Point3d(0.0, 0.0, 0.0);
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        this.t3d.lookAt(eye, center, up);
        this.t3d.invert();
        Transform3D home = this.navigator.getViewPlatformHomeTransform();
        Vector3d focalPoint = new Vector3d(this.navigator.getFocalPoint());
        this.view_scriptor.addKeyFrame(1, home, focalPoint);
        this.multi_scriptor.addKeyFrame(1, this.t3d, focalPoint);
        this.view_scriptor.flyTo();
        this.multi_scriptor.flyTo();
    }

    public void resetTransforms() {
        Transform3D id = new Transform3D();
        this.navigator.getViewingPlatform().getViewPlatformTransform().setTransform(id);
        MultiTransformGroup mtg = this.navigator.getViewingPlatform().getMultiTransformGroup();
        mtg.getTransformGroup(0).setTransform(this.t3d);
        this.navigator.setFocusOnMe(this.intersectPoint);
    }

    private double grabDistance() {
        double radius = Geo3dInfo.getActiveViewer().getEqRad();
        Transform3D starting = new Transform3D();
        Geo3dInfo.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0).getTransform(starting);
        Vector3d startingLoc = new Vector3d();
        starting.get(startingLoc);
        Matrix3d startingMatrix = new Matrix3d();
        starting.get(startingMatrix);
        Transform3D movement = new Transform3D();
        Geo3dInfo.getViewingPlatform().getViewPlatformTransform().getTransform(movement);
        Vector3d movementLoc = new Vector3d();
        movement.get(movementLoc);
        movementLoc.set(movementLoc.x * startingMatrix.m00 + movementLoc.y * startingMatrix.m01 + movementLoc.z * startingMatrix.m02, movementLoc.x * startingMatrix.m10 + movementLoc.y * startingMatrix.m11 + movementLoc.z * startingMatrix.m12, movementLoc.x * startingMatrix.m20 + movementLoc.y * startingMatrix.m21 + movementLoc.z * startingMatrix.m22);
        movementLoc.set(startingLoc.x + movementLoc.x, startingLoc.y + movementLoc.y, startingLoc.z + movementLoc.z);
        double distance = movementLoc.length() - radius;
        return distance;
    }

    public void boxZoom(int start_x, int start_y, int end_x, int end_y) {
        this.isBoxMode = true;
        int mid_x = start_x >= end_x ? (start_x - end_x) / 2 + end_x : (end_x - start_x) / 2 + start_x;
        int mid_y = start_y >= end_y ? (start_y - end_y) / 2 + end_y : (end_y - start_y) / 2 + start_y;
        this.pickCanvas.setShapeLocation(mid_x, mid_y);
        this.pickResult = this.pickCanvas.pickClosest();
        double distance = this.calcBoxZoomDistance(start_x, start_y, end_x, end_y);
        this.prepareScriptors();
        this.grabLocation();
        this.relocate(this.latitude, this.longitude, distance, true);
        this.isBoxMode = false;
    }

    private double calcBoxZoomDistance(int start_x, int start_y, int end_x, int end_y) {
        boolean widthIsGreater = false;
        if (Math.abs(start_x - end_x) >= Math.abs(start_y - end_y)) {
            widthIsGreater = true;
        }
        double a = this.grabDistance();
        double b = widthIsGreater ? (double)(this.pickCanvas.getCanvas().getWidth() / 2) : (double)(this.pickCanvas.getCanvas().getHeight() / 2);
        double c = Math.sqrt(a * a + b * b);
        double angle = Math.acos((a * a - b * b - c * c) / (-2.0 * b * c));
        double b_angle = 1.5707963267948966 - angle;
        b = widthIsGreater ? (double)(Math.abs(start_x - end_x) / 2) : (double)(Math.abs(start_y - end_y) / 2);
        a = b * Math.sin(angle) / Math.sin(b_angle);
        return a;
    }

    public double deg2rad(double degree) {
        return degree * Math.PI / 180.0;
    }

    public void updateScene(int xpos, int ypos) {
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)new WakeupOnAWTEvent(501));
    }

    public void toggleAllowNav() {
        if (this.allowNav) {
            Geo3dInfo.getActiveViewer().turnNavByPickOn();
            this.allowNav = false;
        } else {
            Geo3dInfo.getActiveViewer().turnNavByPickOff();
            this.allowNav = true;
        }
    }
}

