/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.mod.visuals.grid;

import java.awt.Font;
import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.scec.geo3d.mod.visuals.grid.GlobeLayout;
import org.scec.geo3d.tools.LatLongToPoint;

public class GlobeBox {
    private GlobeLayout layout;
    static double PiBy2 = 1.5707963267948966;
    BranchGroup globeScene;
    TransformGroup globeTransform;
    private Appearance lineAppearance;
    private Appearance textAppearance;
    private Material lineMaterial;
    private ColoringAttributes lineColAtts;
    private ColoringAttributes textColAtts;
    private Color3f lineColor;
    boolean bLatTexts;
    boolean bLonTexts;
    boolean bLatHashes;
    boolean bLonHashes;

    public GlobeBox(TransformGroup globalTransformG, GlobeLayout layout) {
        this.layout = layout;
        this.globeScene = new BranchGroup();
        this.globeScene.setCapability(17);
        this.globeTransform = globalTransformG;
        this.globeTransform.setCapability(18);
        this.globeTransform.setCapability(17);
    }

    public BranchGroup drawGlobe() {
        ArrayList points = this.getPoints();
        ArrayList innerPoints = this.getInnerPoints();
        this.init();
        this.drawLatData(this.globeScene, points);
        this.drawLonData(this.globeScene, points);
        this.drawConnectionData(this.globeScene, points, innerPoints);
        return this.globeScene;
    }

    private void drawConnectionData(BranchGroup returnMe, ArrayList points, ArrayList innerPoints) {
        LineStripArray[] connections = this.drawConnectionsFromPoints(points, innerPoints);
        int i = 0;
        while (i < connections.length) {
            returnMe.addChild((Node)new Shape3D((Geometry)connections[i], this.lineAppearance));
            ++i;
        }
    }

    private void drawLonData(BranchGroup returnMe, ArrayList points) {
        LineStripArray[] lonLines = this.drawLonLinesFromPoints(points);
        TransformGroup[] lonTexts = this.drawLongitudeTexts(points);
        int i = 0;
        while (i < lonLines.length) {
            returnMe.addChild((Node)new Shape3D((Geometry)lonLines[i], this.lineAppearance));
            ++i;
        }
        i = 0;
        while (i < lonTexts.length) {
            returnMe.addChild((Node)lonTexts[i]);
            ++i;
        }
    }

    private void drawLatData(BranchGroup returnMe, ArrayList points) {
        LineStripArray[] latLines = this.drawLatLinesFromPoints(points);
        TransformGroup[] latTexts = this.drawLatitudeTexts(points);
        int i = 0;
        while (i < latLines.length) {
            returnMe.addChild((Node)new Shape3D((Geometry)latLines[i], this.lineAppearance));
            ++i;
        }
        i = 0;
        while (i < latTexts.length) {
            returnMe.addChild((Node)latTexts[i]);
            ++i;
        }
    }

    public ArrayList getPoints() {
        ArrayList<Point3d[]> points = new ArrayList<Point3d[]>();
        int count = 0;
        int lat = this.layout.topLat;
        while (lat >= this.layout.botLat) {
            points.add(count, this.getPointsOnLatLine(this.layout.centerOfEarth, LatLongToPoint.calcRadius(lat), lat));
            lat -= this.layout.latDegreeSpacing;
            ++count;
        }
        return points;
    }

    public ArrayList getInnerPoints() {
        ArrayList<Point3d[]> points = new ArrayList<Point3d[]>();
        int count = 0;
        int lat = this.layout.topLat;
        while (lat >= this.layout.botLat) {
            points.add(count, this.getPointsOnLatLine(this.layout.centerOfEarth, LatLongToPoint.calcRadius(lat) - (double)this.layout.maxDepth, lat));
            lat -= this.layout.latDegreeSpacing;
            ++count;
        }
        return points;
    }

    public LineStripArray[] drawLatLinesFromPoints(ArrayList points) {
        LineStripArray[] latLines = new LineStripArray[this.layout.numLatLinesWithSpacing + 1];
        int resolution = this.layout.numLonLinesWithSpacing + 1;
        int length = resolution + 1;
        int latcount = 0;
        while (latcount < latLines.length) {
            latLines[latcount] = new LineStripArray(length, 1, new int[]{length});
            Point3d[] pts = (Point3d[])points.get(latcount);
            int loncount = 0;
            while (loncount < pts.length) {
                latLines[latcount].setCoordinate(loncount, pts[loncount]);
                ++loncount;
            }
            latLines[latcount].setCoordinate(resolution, pts[--loncount]);
            ++latcount;
        }
        return latLines;
    }

    public TransformGroup[] drawLatitudeTexts(ArrayList points) {
        Text3D[] texts = new Text3D[this.layout.numLatLinesWithSpacing + 1];
        TransformGroup[] trans = new TransformGroup[this.layout.numLatLinesWithSpacing + 1];
        Font3D f3d = new Font3D(new Font("SansSerif", 0, this.layout.labelFontSize), 0.5, null);
        int degreeDiff = 0;
        int latcount = 0;
        while (latcount < this.layout.numLatLinesWithSpacing + 1) {
            Point3d[] pts = (Point3d[])points.get(latcount);
            texts[latcount] = new Text3D(f3d, Integer.toString(this.layout.topLat - degreeDiff), new Point3f(0.0f, 0.0f, 0.0f), 2, 1);
            OrientedShape3D txtShape = new OrientedShape3D((Geometry)texts[latcount], this.textAppearance, 1, new Vector3f(0.0f, 1.0f, 0.0f));
            Transform3D offset = new Transform3D();
            offset.setTranslation(new Vector3f((float)pts[pts.length - 1].x, (float)pts[pts.length - 1].y, (float)pts[pts.length - 1].z));
            trans[latcount] = new TransformGroup(offset);
            trans[latcount].addChild((Node)txtShape);
            degreeDiff += this.layout.latDegreeSpacing;
            ++latcount;
        }
        return trans;
    }

    public TransformGroup[] drawLongitudeTexts(ArrayList points) {
        Text3D[] texts = new Text3D[this.layout.numLonLinesWithSpacing + 1];
        TransformGroup[] trans = new TransformGroup[this.layout.numLonLinesWithSpacing + 1];
        Font3D f3d = new Font3D(new Font("SansSerif", 0, this.layout.labelFontSize), 0.5, null);
        Point3d[] pts = (Point3d[])points.get(0);
        int degreeDiff = 0;
        int loncount = 0;
        while (loncount < this.layout.numLonLinesWithSpacing + 1) {
            texts[loncount] = new Text3D(f3d, Integer.toString(this.layout.rightLon - degreeDiff), new Point3f(0.0f, 0.0f, 0.0f), 1, 1);
            OrientedShape3D txtShape = new OrientedShape3D((Geometry)texts[loncount], this.textAppearance, 1, new Vector3f(0.0f, 1.0f, 0.0f));
            Transform3D offset = new Transform3D();
            offset.setTranslation(new Vector3f((float)pts[loncount].x, (float)pts[loncount].y, (float)pts[loncount].z));
            trans[loncount] = new TransformGroup(offset);
            trans[loncount].addChild((Node)txtShape);
            degreeDiff += this.layout.lonDegreeSpacing;
            ++loncount;
        }
        return trans;
    }

    public LineStripArray[] drawConnectionsFromPoints(ArrayList points, ArrayList innerPoints) {
        LineStripArray[] cons = new LineStripArray[4];
        Font3D f3d = new Font3D(new Font("SansSerif", 0, this.layout.labelFontSize), new FontExtrusion());
        cons[0] = new LineStripArray(2, 1, new int[]{2});
        cons[0].setCoordinate(0, ((Point3d[])points.get(0))[0]);
        cons[0].setCoordinate(1, ((Point3d[])innerPoints.get(0))[0]);
        cons[1] = new LineStripArray(2, 1, new int[]{2});
        cons[1].setCoordinate(0, ((Point3d[])points.get(points.size() - 1))[0]);
        cons[1].setCoordinate(1, ((Point3d[])innerPoints.get(innerPoints.size() - 1))[0]);
        cons[2] = new LineStripArray(2, 1, new int[]{2});
        cons[2].setCoordinate(0, ((Point3d[])points.get(0))[((Point3d[])points.get(0)).length - 1]);
        cons[2].setCoordinate(1, ((Point3d[])innerPoints.get(0))[((Point3d[])points.get(0)).length - 1]);
        cons[3] = new LineStripArray(2, 1, new int[]{2});
        cons[3].setCoordinate(0, ((Point3d[])points.get(points.size() - 1))[((Point3d[])points.get(0)).length - 1]);
        cons[3].setCoordinate(1, ((Point3d[])innerPoints.get(points.size() - 1))[((Point3d[])points.get(0)).length - 1]);
        return cons;
    }

    public LineStripArray[] drawLonLinesFromPoints(ArrayList points) {
        LineStripArray[] lonLines = new LineStripArray[this.layout.numLonLinesWithSpacing + 1];
        Font3D f3d = new Font3D(new Font("SansSerif", 0, this.layout.labelFontSize), new FontExtrusion());
        int resolution = this.layout.numLatLinesWithSpacing + 1;
        int length = resolution + 1;
        int loncount = 0;
        while (loncount < lonLines.length) {
            lonLines[loncount] = new LineStripArray(length, 1, new int[]{length});
            int latcount = 0;
            while (latcount < points.size()) {
                lonLines[loncount].setCoordinate(latcount, ((Point3d[])points.get(latcount))[loncount]);
                ++latcount;
            }
            lonLines[loncount].setCoordinate(resolution, ((Point3d[])points.get(--latcount))[loncount]);
            ++loncount;
        }
        return lonLines;
    }

    private Point3d[] getPointsOnLatLine(Point3d coe, double radius, int lat) {
        double rCosPhi = radius * Math.cos(PiBy2 - LatLongToPoint.deg2rad(lat));
        double rSinPhi = radius * Math.sin(PiBy2 - LatLongToPoint.deg2rad(lat));
        int leftLon = -1 * this.layout.rightLon;
        int rightLon = -1 * this.layout.leftLon;
        int resolution = this.layout.numLonLinesWithSpacing + 1;
        int length = resolution + 1;
        Point3d[] returnme = new Point3d[resolution];
        int count = 0;
        Point3d pt = new Point3d();
        int i = leftLon;
        while (i <= rightLon) {
            pt.x = rSinPhi * Math.cos(LatLongToPoint.deg2rad(i));
            pt.y = rCosPhi;
            pt.z = rSinPhi * Math.sin(LatLongToPoint.deg2rad(i));
            returnme[count] = new Point3d(pt);
            i += this.layout.lonDegreeSpacing;
            ++count;
        }
        return returnme;
    }

    private void init() {
        Color3f ambientColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f emissiveColor = new Color3f(0.0f, 0.0f, 0.0f);
        float shininess = 1.0f;
        this.lineAppearance = new Appearance();
        TransparencyAttributes lineTransAtts = new TransparencyAttributes();
        lineTransAtts.setTransparency(0.4f);
        lineTransAtts.setTransparencyMode(1);
        this.lineAppearance.setTransparencyAttributes(lineTransAtts);
        Color3f lineDiffuseColor = new Color3f(1.0f, 1.0f, 1.0f);
        this.lineColAtts = new ColoringAttributes(lineDiffuseColor, 2);
        this.lineColAtts.setCapability(0);
        this.lineColAtts.setCapability(1);
        this.lineMaterial = new Material(ambientColor, emissiveColor, lineDiffuseColor, specularColor, shininess);
        this.lineAppearance.setMaterial(this.lineMaterial);
        this.lineAppearance.setPolygonAttributes(new PolygonAttributes(1, 0, 0.0f));
        this.lineAppearance.setColoringAttributes(this.lineColAtts);
        this.textAppearance = new Appearance();
        this.textAppearance.setCapability(8);
        this.textAppearance.setCapability(9);
        Color3f textColor = new Color3f(1.0f, 1.0f, 1.0f);
        this.textColAtts = new ColoringAttributes(textColor, 2);
        this.textColAtts.setCapability(0);
        this.textColAtts.setCapability(1);
        this.textAppearance.setColoringAttributes(this.textColAtts);
    }

    public BranchGroup getGlobeScene() {
        return this.globeScene;
    }

    public void setColor(Color3f clr) {
        this.lineColAtts.setColor(clr);
        this.textColAtts.setColor(clr);
    }

    public Color3f getColor() {
        Color3f color = new Color3f();
        this.lineColAtts.getColor(color);
        return color;
    }
}

