/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.mod.visuals.grid;

import javax.vecmath.Point3d;

public class GlobeLayout {
    protected double re = 6378.14;
    protected double rp = 6356.755;
    protected int topLat;
    protected int botLat;
    protected int leftLon;
    protected int rightLon;
    protected int maxDepth;
    protected int numLatLines;
    protected int numLonLines;
    protected int numLatLinesWithSpacing;
    protected int numLonLinesWithSpacing;
    protected int latDegreeSpacing;
    protected int lonDegreeSpacing;
    protected int labelFontSize = 25;
    protected Point3d centerOfEarth = new Point3d(0.0, 0.0, 0.0);
    protected String[] latTexts;
    protected String[] lonTexts;

    public GlobeLayout() {
        this.topLat = 36;
        this.botLat = 32;
        this.leftLon = -122;
        this.rightLon = -114;
        this.maxDepth = 40;
        this.latDegreeSpacing = 1;
        this.lonDegreeSpacing = 1;
        this.commonSetup();
    }

    private void commonSetup() {
        this.numLatLines = Math.abs(this.topLat - this.botLat);
        this.numLonLines = Math.abs(this.rightLon - this.leftLon);
        this.numLatLinesWithSpacing = this.numLatLines / this.latDegreeSpacing;
        this.numLonLinesWithSpacing = this.numLonLines / this.lonDegreeSpacing;
        this.latTexts = new String[Math.abs(this.topLat - this.botLat)];
        this.lonTexts = new String[Math.abs(this.rightLon - this.leftLon)];
        this.populateStringArray(true, this.topLat);
        this.populateStringArray(false, this.leftLon);
    }

    public GlobeLayout(int topLat, int botLat, int leftLon, int rightLon, int degreeSpacing) {
        this.topLat = topLat;
        this.botLat = botLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        this.maxDepth = 40;
        this.latDegreeSpacing = degreeSpacing;
        this.lonDegreeSpacing = degreeSpacing;
        this.commonSetup();
    }

    private void populateStringArray(boolean lat, int startValue) {
        int curValue = startValue;
        if (lat) {
            int i = 0;
            while (i < this.latTexts.length) {
                this.latTexts[i] = Integer.toString(curValue--);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.lonTexts.length) {
                this.lonTexts[i] = Integer.toString(curValue++);
                ++i;
            }
        }
    }
}

