/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.plugins.utils;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scec.geo3d.plugins.utils.DataAccessor;
import org.scec.geo3d.tools.Prefs;

public abstract class AbstractDataAccessor
implements DataAccessor,
Comparable {
    private Logger log;
    private String objectClass;
    private String sourceFile;
    private File attsFile;
    private File dataFile;
    private String displayName;
    private String sourceCite;
    private String sourceRef;
    private String objNotes;
    private boolean display;
    protected Element object_info;
    protected Document objectDocument;
    static /* synthetic */ Class class$0;

    public AbstractDataAccessor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.plugins.utils.AbstractDataAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger((Class)clazz);
        this.display = false;
    }

    protected boolean newDocument() {
        SAXBuilder parser = new SAXBuilder();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.plugins.utils.AbstractDataAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL dataDoc = clazz.getResource("components/resources/xml/object_template.xml");
        try {
            this.objectDocument = parser.build(dataDoc);
            this.object_info = this.objectDocument.getRootElement().getChild("object_info");
        }
        catch (Exception e) {
            this.log.debug((Object)"problem parsing XML");
            return false;
        }
        return true;
    }

    public boolean readDataFile() {
        return false;
    }

    public boolean writeDataFile() {
        return false;
    }

    public void setInMemory(boolean load) {
    }

    public boolean isInMemory() {
        return true;
    }

    public void setDisplayed(boolean show) {
        this.display = show;
    }

    public boolean isDisplayed() {
        return this.display;
    }

    public int compareTo(Object obj) throws ClassCastException {
        if (!(obj instanceof DataAccessor)) {
            throw new ClassCastException();
        }
        return this.getDisplayName().compareTo(((DataAccessor)obj).getDisplayName());
    }

    public boolean equals(Object obj) throws ClassCastException {
        if (obj instanceof DataAccessor) {
            return ((DataAccessor)obj).getAttributeFile().equals(this.getAttributeFile());
        }
        if (obj instanceof File) {
            return ((File)obj).equals(this.getAttributeFile());
        }
        throw new ClassCastException();
    }

    public boolean readAttributeFile(File file) {
        SAXBuilder parser = new SAXBuilder();
        try {
            this.objectDocument = parser.build(file);
            this.object_info = this.objectDocument.getRootElement().getChild("object_info");
        }
        catch (Exception e) {
            this.log.debug((Object)"problem parsing XML");
            return false;
        }
        this.objectClass = this.object_info.getChild("class").getText();
        this.sourceFile = this.object_info.getChild("source_file").getText();
        this.attsFile = new File(String.valueOf(Prefs.getLibLoc()) + this.object_info.getChild("attribute_file").getText());
        this.dataFile = new File(String.valueOf(Prefs.getLibLoc()) + this.object_info.getChild("data_file").getText());
        this.displayName = this.object_info.getChild("display_name").getText();
        this.sourceRef = this.object_info.getChild("source_info").getChild("reference").getText();
        this.sourceCite = this.object_info.getChild("source_info").getChild("citation").getText();
        this.objNotes = this.object_info.getChild("notes").getText();
        return true;
    }

    public boolean writeAttributeFile() {
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            BufferedWriter xmlOut = new BufferedWriter(new FileWriter(this.attsFile));
            outputter.output(this.objectDocument, (Writer)xmlOut);
            xmlOut.close();
        }
        catch (Exception e) {
            this.log.debug((Object)"problem writing XML");
            return false;
        }
        return true;
    }

    public Color readColorElement(Element element) {
        Color c = null;
        if (element.getAttributeValue("r") != "null") {
            try {
                c = new Color(element.getAttribute("r").getFloatValue(), element.getAttribute("g").getFloatValue(), element.getAttribute("b").getFloatValue());
            }
            catch (Exception e) {
                this.log.debug((Object)"problem parsing XML");
                return c;
            }
        }
        return c;
    }

    public void writeColorElement(Element element, Color color) {
        if (color != null) {
            float[] colors = color.getRGBColorComponents(new float[3]);
            element.getAttribute("r").setValue(String.valueOf(colors[0]));
            element.getAttribute("g").setValue(String.valueOf(colors[1]));
            element.getAttribute("b").setValue(String.valueOf(colors[2]));
        } else {
            element.getAttribute("r").setValue("null");
            element.getAttribute("g").setValue("null");
            element.getAttribute("b").setValue("null");
        }
    }

    public String toString() {
        return this.displayName;
    }

    public void setObjectClass(String classname) {
        this.objectClass = classname;
        this.object_info.getChild("class").setText(classname);
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setSourceFile(String filename) {
        this.sourceFile = filename;
        this.object_info.getChild("source_file").setText(filename);
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setAttributeFile(String filename) {
        this.attsFile = new File(String.valueOf(Prefs.getLibLoc()) + filename);
        this.object_info.getChild("attribute_file").setText(filename);
    }

    public File getAttributeFile() {
        return this.attsFile;
    }

    public String getAttributeFileLibPath() {
        return this.object_info.getChild("attribute_file").getText();
    }

    public void setDataFile(String filename) {
        this.dataFile = new File(String.valueOf(Prefs.getLibLoc()) + filename);
        this.object_info.getChild("data_file").setText(filename);
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.object_info.getChild("display_name").setText(name);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setNotes(String notes) {
        this.objNotes = notes;
        this.object_info.getChild("notes").setText(notes);
    }

    public String getNotes() {
        return this.objNotes;
    }

    public String getCitation() {
        return this.sourceCite;
    }

    public void setCitation(String citation) {
        this.sourceCite = citation;
        this.object_info.getChild("source_info").getChild("citation").setText(citation);
    }

    public String getReference() {
        return this.sourceRef;
    }

    public void setReference(String reference) {
        this.sourceRef = reference;
        this.object_info.getChild("source_info").getChild("reference").setText(reference);
    }
}

