/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.plugins.utils;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.scec.geo3d.plugins.utils.DataAccessor;

public abstract class AbstractLibraryModel
extends AbstractTableModel {
    private Logger log;
    protected Vector data;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AbstractLibraryModel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.plugins.utils.AbstractLibraryModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger((Class)clazz);
        this.data = new Vector();
    }

    public Class getColumnClass(int col) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.scec.geo3d.plugins.utils.DataAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getValueAt(int row, int col) {
        return this.getObjectAtRow(row);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public void clear() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void setVisibilityForRow(boolean show, int row) {
        if (this.getLoadedStateForRow(row) && this.getVisibilityForRow(row) != show) {
            this.getObjectAtRow(row).setDisplayed(show);
            this.fireTableCellUpdated(row, 0);
        }
    }

    public void setVisibilityForRows(boolean show, int[] rows) {
        int i = 0;
        while (i < rows.length) {
            this.setVisibilityForRow(show, rows[i]);
            ++i;
        }
    }

    public void toggleVisibilityForRow(int row) {
        this.setVisibilityForRow(!this.getObjectAtRow(row).isDisplayed(), row);
    }

    public void toggleVisibilityForRows(int[] rows) {
        boolean show = true;
        int i = 0;
        while (i < rows.length) {
            if (this.getLoadedStateForRow(rows[i])) {
                show = !this.getVisibilityForRow(rows[i]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < rows.length) {
            this.setVisibilityForRow(show, rows[i]);
            ++i;
        }
    }

    public boolean getVisibilityForRow(int row) {
        return this.getObjectAtRow(row).isDisplayed();
    }

    public ArrayList getVisibleObjects() {
        ArrayList<DataAccessor> visibleObjects = new ArrayList<DataAccessor>();
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getVisibilityForRow(i)) {
                visibleObjects.add(this.getObjectAtRow(i));
            }
            ++i;
        }
        return visibleObjects;
    }

    public boolean anyAreVisible() {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getObjectAtRow(i).isDisplayed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLoadedStateForRow(boolean load, int row) {
        this.getObjectAtRow(row).setInMemory(load);
        this.fireTableRowsUpdated(row, row);
    }

    public void setLoadedStateForRows(boolean load, int[] rows) {
        int i = 0;
        while (i < rows.length) {
            if (this.getLoadedStateForRow(rows[i]) != load) {
                this.setLoadedStateForRow(load, rows[i]);
            }
            ++i;
        }
    }

    public boolean getLoadedStateForRow(int row) {
        return this.getObjectAtRow(row).isInMemory();
    }

    public ArrayList getLoadedObjects() {
        ArrayList<DataAccessor> loadedObjects = new ArrayList<DataAccessor>();
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getLoadedStateForRow(i)) {
                loadedObjects.add(this.getObjectAtRow(i));
            }
            ++i;
        }
        return loadedObjects;
    }

    public boolean anyAreLoaded() {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getObjectAtRow(i).isInMemory()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean anyAreLoaded(int[] selectedRows) {
        int i = 0;
        while (i < selectedRows.length) {
            if (this.getObjectAtRow(selectedRows[i]).isInMemory()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean allAreLoaded(int[] selectedRows) {
        int i = 0;
        while (i < selectedRows.length) {
            if (!this.getObjectAtRow(selectedRows[i]).isInMemory()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean noneAreLoaded(int[] selectedRows) {
        int i = 0;
        while (i < selectedRows.length) {
            if (this.getObjectAtRow(selectedRows[i]).isInMemory()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
    }

    public void saveDisplayProperties() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.getObjectAtRow(i).writeAttributeFile();
            ++i;
        }
    }

    public void addObject(DataAccessor object) {
        if (!this.contains(object)) {
            this.data.add(object);
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    public void addObjects(List objects) {
        if (objects.size() > 0) {
            int i = 0;
            while (i < objects.size()) {
                try {
                    DataAccessor obj = (DataAccessor)objects.get(i);
                    if (!this.contains(obj)) {
                        this.data.add(obj);
                    }
                }
                catch (ClassCastException e) {
                    this.log.debug((Object)"Class cast exception while adding objects");
                }
                ++i;
            }
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    public void deleteObjects(Component owner, int[] rows) {
        int delete = JOptionPane.showConfirmDialog(owner, "Are you sure you want to delete the selected object(s)?\n(All attribute and backing data will be deleted)", "Delete Object(s)", 0, 3);
        if (delete == 1 || delete == -1) {
            return;
        }
        int i = 0;
        while (i < rows.length) {
            this.getObjectAtRow(rows[i] - i).getAttributeFile().delete();
            this.getObjectAtRow(rows[i] - i).getDataFile().delete();
            this.removeObjectAtRow(rows[i] - i);
            ++i;
        }
    }

    public void removeObjectAtRow(int row) {
        DataAccessor obj = this.getObjectAtRow(row);
        if (obj.isDisplayed()) {
            obj.setDisplayed(false);
        }
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
    }

    public DataAccessor findObject(File objSource) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getObjectAtRow(i).equals(objSource)) {
                return this.getObjectAtRow(i);
            }
            ++i;
        }
        return null;
    }

    public boolean contains(DataAccessor object) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getObjectAtRow(i).equals(object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(Object object) {
        int i = 0;
        while (i < this.data.size()) {
            if (this.getObjectAtRow(i).equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DataAccessor getObjectAtRow(int row) {
        return (DataAccessor)this.data.get(row);
    }
}

