/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.plugins.utils.components;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DataFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    protected String filterExtension = "ALL";
    protected String filterDescription = "";
    private Filter filter = new Filter();
    private Component parent = null;

    public DataFileChooser(Component component, String title, boolean multiple) {
        this.commonSetup(component, title, multiple);
    }

    public DataFileChooser(Component component, String title, boolean multiple, File directory) {
        super(directory);
        this.commonSetup(component, title, multiple);
    }

    private void commonSetup(Component component, String title, boolean multiple) {
        this.parent = component;
        this.setDialogTitle(title);
        this.setMultiSelectionEnabled(multiple);
        this.setFileFilter(this.getAcceptAllFileFilter());
        this.setApproveButtonText("Import");
    }

    public void reset() {
        this.filterExtension = "ALL";
        this.filterDescription = "";
        this.setAcceptAllFileFilterUsed(true);
        this.removeChoosableFileFilter(this.filter);
    }

    public String getCurrentFilter() {
        return this.filterExtension;
    }

    public void setCurrentFilter(String ext, String desc) {
        this.setAcceptAllFileFilterUsed(false);
        this.filterExtension = ext;
        this.filterDescription = desc;
        this.setFileFilter(this.filter);
    }

    public void setTitle(String title) {
        this.setDialogTitle(title);
    }

    public void setParams(String title, String ext, String desc) {
        this.setTitle(title);
        this.setCurrentFilter(ext, desc);
    }

    public File getFile() {
        int option = this.showOpenDialog(this.parent);
        if (option == 0) {
            return this.getSelectedFile();
        }
        return null;
    }

    public File[] getFiles() {
        int option = this.showOpenDialog(this.parent);
        if (option == 0) {
            return this.getSelectedFiles();
        }
        return null;
    }

    private class Filter
    extends FileFilter {
        Filter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(DataFileChooser.this.filterExtension);
        }

        public String getDescription() {
            return DataFileChooser.this.filterDescription;
        }
    }
}

