/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.plugins.utils.components;

import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DecimalTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 1L;
    private final String format = "0.0";

    public DecimalTextField(int maxInteger, int maxDecimal, int columns) {
        this.setColumns(columns);
        DecimalFormat decFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        decFormat.applyPattern("0.0");
        decFormat.setMaximumIntegerDigits(maxInteger);
        decFormat.setMaximumFractionDigits(maxDecimal);
        DefaultFormatterFactory formatFactory = new DefaultFormatterFactory(new NumberFormatter(decFormat));
        this.setFormatterFactory(formatFactory);
    }

    public Float getFloatValue() {
        try {
            return Float.valueOf(this.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005 && this.getText().length() == 0) {
            this.setValue(null);
        }
        super.processFocusEvent(e);
    }
}

