/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.plugins.utils.components;

import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class IntegerTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 1L;

    public IntegerTextField(int maxDigits, boolean grouped, int columns) {
        this.setColumns(columns);
        NumberFormat numFormat = NumberFormat.getIntegerInstance();
        numFormat.setMaximumIntegerDigits(maxDigits);
        numFormat.setGroupingUsed(grouped);
        DefaultFormatterFactory formatFactory = new DefaultFormatterFactory(new NumberFormatter(numFormat));
        this.setFormatterFactory(formatFactory);
    }

    public Integer getIntegerValue() {
        try {
            return Integer.valueOf(this.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005 && this.getText().length() == 0) {
            this.setValue(null);
        }
        super.processFocusEvent(e);
    }
}

